/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class ExpressionBuilder
extends ObjectExpression {
    protected transient AbstractSession session;
    protected Class queryClass;
    protected SQLSelectStatement statement;
    protected DatabaseTable viewTable;
    protected DatabaseTable aliasedViewTable;
    protected boolean wasQueryClassSetInternally = true;
    protected boolean wasAdditionJoinCriteriaUsed = false;

    public ExpressionBuilder() {
    }

    public ExpressionBuilder(Class clazz) {
        this.queryClass = clazz;
        this.wasQueryClassSetInternally = false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return super.equals(object) && this.getQueryClass() == null && ((ExpressionBuilder)object).getQueryClass() == null;
    }

    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        if (this.hasViewTable()) {
            return this.getAliasedViewTable();
        }
        if (this.doesNotRepresentAnObjectInTheQuery()) {
            Enumeration enumeration = this.derivedTables.elements();
            while (enumeration.hasMoreElements()) {
                TableExpression tableExpression = (TableExpression)enumeration.nextElement();
                DatabaseTable databaseTable2 = tableExpression.aliasForTable(databaseTable);
                if (databaseTable2 == null) continue;
                return databaseTable2;
            }
        } else {
            return super.aliasForTable(databaseTable);
        }
        return null;
    }

    public int assignTableAliasesStartingAt(int n) {
        if (this.hasBeenAliased()) {
            return n;
        }
        if (this.doesNotRepresentAnObjectInTheQuery()) {
            return n;
        }
        if (this.hasViewTable()) {
            DatabaseTable databaseTable = (DatabaseTable)this.viewTable.clone();
            String string = "t" + n;
            databaseTable.setName(string);
            this.assignAlias(string, this.viewTable);
            this.aliasedViewTable = databaseTable;
            return n + 1;
        }
        return super.assignTableAliasesStartingAt(n);
    }

    public String descriptionOfNodeType() {
        return "Base";
    }

    public boolean doesNotRepresentAnObjectInTheQuery() {
        return this.hasDerivedTables() && !this.hasDerivedFields() && !this.hasDerivedExpressions();
    }

    public DatabaseTable getAliasedViewTable() {
        return this.aliasedViewTable;
    }

    public ExpressionBuilder getBuilder() {
        return this;
    }

    public ClassDescriptor getDescriptor() {
        if (this.descriptor == null) {
            if (this.getQueryClass() == null) {
                return null;
            }
            if (this.getSession() == null) {
                throw QueryException.noExpressionBuilderFound(this);
            }
            this.descriptor = this.getSession().getDescriptor(this.getQueryClass());
        }
        return this.descriptor;
    }

    public Class getQueryClass() {
        return this.queryClass;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public SQLSelectStatement getStatement() {
        return this.statement;
    }

    public DatabaseTable getViewTable() {
        return this.viewTable;
    }

    public boolean hasViewTable() {
        return this.viewTable != null;
    }

    public boolean isExpressionBuilder() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        Expression expression;
        if (this.hasBeenNormalized()) {
            return this;
        }
        this.setHasBeenNormalized(true);
        if (this.queryClass != null) {
            expression = null;
            this.setSession(expressionNormalizer.getSession().getRootSession(null));
            if (this.getDescriptor() == null) {
                throw QueryException.noExpressionBuilderFound(this);
            }
            if (!this.wasAdditionJoinCriteriaUsed && (expression = this.getDescriptor().getQueryManager().getAdditionalJoinExpression()) != null) {
                expression = this.twist(expression, this);
            }
            if (this.isUsingOuterJoinForMultitableInheritance() && this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                Expression expression2 = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
                expression2 = this.twist(expression2, this);
                expression2.convertToUseOuterJoin();
                expression = expression == null ? expression2 : expression.and(expression2);
            }
            if (this.isUsingOuterJoinForMultitableInheritance() && !this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause()) {
                expressionNormalizer.getStatement().getOuterJoinExpressions().addElement(null);
                expressionNormalizer.getStatement().getOuterJoinedMappingCriteria().addElement(null);
                expressionNormalizer.getStatement().getOuterJoinedAdditionalJoinCriteria().addElement(this.additionalExpressionCriteriaMap());
                expressionNormalizer.getStatement().getDescriptorsForMultitableInheritanceOnly().add(this.getDescriptor());
            }
            expressionNormalizer.addAdditionalExpression(expression);
        }
        this.setStatement(expressionNormalizer.getStatement());
        if (this.getAsOfClause() == null) {
            this.asOf(AsOfClause.NO_CLAUSE);
        }
        if (this.getDescriptor() != null && this.getDescriptor().getHistoryPolicy() != null) {
            expression = this.getDescriptor().getHistoryPolicy().additionalHistoryExpression(this);
            expressionNormalizer.addAdditionalExpression(expression);
        }
        return super.normalize(expressionNormalizer);
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        expressionJavaPrinter.printString(expressionJavaPrinter.getBuilderString());
    }

    public Expression rebuildOn(Expression expression) {
        return expression;
    }

    protected Expression registerIn(Map map) {
        Object v = map.get(map);
        if (v == null || v == map) {
            return super.registerIn(map);
        }
        ObjectExpression objectExpression = (ObjectExpression)v;
        map.put(map, map);
        map.put(this, objectExpression);
        if (this.derivedExpressions != null) {
            if (objectExpression.derivedExpressions == null) {
                objectExpression.derivedExpressions = this.copyCollection(this.derivedExpressions, map);
            } else {
                objectExpression.derivedExpressions.addAll(this.copyCollection(this.derivedExpressions, map));
            }
        }
        objectExpression.postCopyIn(map, this.derivedFields, this.derivedTables);
        return objectExpression;
    }

    public void setQueryClass(Class clazz) {
        this.queryClass = clazz;
        this.descriptor = null;
    }

    public void setQueryClassAndDescriptor(Class clazz, ClassDescriptor classDescriptor) {
        this.queryClass = clazz;
        this.descriptor = classDescriptor;
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public void setStatement(SQLSelectStatement sQLSelectStatement) {
        this.statement = sQLSelectStatement;
    }

    public void setViewTable(DatabaseTable databaseTable) {
        this.viewTable = databaseTable;
    }

    public void setWasAdditionJoinCriteriaUsed(boolean bl) {
        this.wasAdditionJoinCriteriaUsed = bl;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        return expression;
    }

    public Object valueFromObject(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord, int n, boolean bl) {
        return object;
    }

    public boolean wasAdditionJoinCriteriaUsed() {
        return this.wasAdditionJoinCriteriaUsed;
    }

    public boolean wasQueryClassSetInternally() {
        return this.wasQueryClassSetInternally;
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        String string = this.getQueryClass() == null ? "QUERY OBJECT" : this.getQueryClass().getName();
        bufferedWriter.write(string + this.tableAliasesDescription());
    }
}

