/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;

public abstract class BaseExpression
extends Expression {
    protected Expression baseExpression;
    protected ExpressionBuilder builder;

    public BaseExpression() {
    }

    public BaseExpression(Expression expression) {
        this.baseExpression = expression;
    }

    public Expression getBaseExpression() {
        return this.baseExpression;
    }

    public ExpressionBuilder getBuilder() {
        if (this.builder == null && this.baseExpression != null) {
            this.builder = this.baseExpression.getBuilder();
        }
        return this.builder;
    }

    protected void postCopyIn(Map map) {
        super.postCopyIn(map);
        if (this.baseExpression != null) {
            this.setBaseExpression(this.baseExpression.copiedVersionFrom(map));
        }
    }

    public void setBaseExpression(Expression expression) {
        this.baseExpression = expression;
        this.builder = null;
    }

    public Expression shallowClone() {
        BaseExpression baseExpression = (BaseExpression)super.shallowClone();
        baseExpression.builder = null;
        return baseExpression;
    }
}

