/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DatabaseType {
    public static final String TARGET_SUFFIX = "_TARGET";
    public static final String COMPAT_SUFFIX = "_COMPAT";

    public boolean isComplexDatabaseType();

    public boolean isJDBCType();

    public int getSqlCode();

    public int getConversionCode();

    public String getTypeName();

    public int computeInIndex(PLSQLargument var1, int var2, ListIterator<PLSQLargument> var3);

    public int computeOutIndex(PLSQLargument var1, int var2, ListIterator<PLSQLargument> var3);

    public void buildInDeclare(StringBuilder var1, PLSQLargument var2);

    public void buildOutDeclare(StringBuilder var1, PLSQLargument var2);

    public void buildBeginBlock(StringBuilder var1, PLSQLargument var2, PLSQLStoredProcedureCall var3);

    public void buildOutAssignment(StringBuilder var1, PLSQLargument var2, PLSQLStoredProcedureCall var3);

    public void translate(PLSQLargument var1, AbstractRecord var2, AbstractRecord var3, Vector var4, Vector var5, Vector var6, StoredProcedureCall var7);

    public void buildOutputRow(PLSQLargument var1, AbstractRecord var2, DatabaseRecord var3, Vector var4, Vector var5);

    public void logParameter(StringBuilder var1, Integer var2, PLSQLargument var3, AbstractRecord var4, DatabasePlatform var5);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseTypeHelper {
        databaseTypeHelper;


        public String buildTarget(PLSQLargument pLSQLargument) {
            StringBuilder stringBuilder = new StringBuilder(pLSQLargument.name);
            stringBuilder.append(DatabaseType.TARGET_SUFFIX);
            return stringBuilder.toString();
        }

        public String buildCompatible(PLSQLargument pLSQLargument) {
            StringBuilder stringBuilder = new StringBuilder(pLSQLargument.name);
            stringBuilder.append(DatabaseType.COMPAT_SUFFIX);
            return stringBuilder.toString();
        }

        public void declareTarget(StringBuilder stringBuilder, PLSQLargument pLSQLargument, DatabaseType databaseType) {
            stringBuilder.append("  ");
            stringBuilder.append(this.buildTarget(pLSQLargument));
            stringBuilder.append(" ");
            stringBuilder.append(databaseType.getTypeName());
        }

        public int computeInIndex(PLSQLargument pLSQLargument, int n) {
            pLSQLargument.inIndex = n++;
            return n;
        }

        public int computeOutIndex(PLSQLargument pLSQLargument, int n) {
            pLSQLargument.outIndex = n++;
            return n;
        }

        public void buildOutAssignment(StringBuilder stringBuilder, PLSQLargument pLSQLargument, PLSQLStoredProcedureCall pLSQLStoredProcedureCall) {
            stringBuilder.append("  :");
            stringBuilder.append(pLSQLargument.outIndex);
            stringBuilder.append(" := ");
            stringBuilder.append(this.buildTarget(pLSQLargument));
            stringBuilder.append(";");
            stringBuilder.append(Helper.NL);
        }

        public void translate(PLSQLargument pLSQLargument, AbstractRecord abstractRecord, AbstractRecord abstractRecord2, Vector vector, Vector vector2, Vector vector3, StoredProcedureCall storedProcedureCall) {
            DatabaseField databaseField = null;
            for (DatabaseField databaseField2 : vector) {
                if (!databaseField2.getName().equals(pLSQLargument.name)) continue;
                databaseField = databaseField2;
                break;
            }
            if (pLSQLargument.length != Integer.MIN_VALUE) {
                databaseField.setLength(pLSQLargument.length);
            }
            if (pLSQLargument.precision != Integer.MIN_VALUE) {
                databaseField.setPrecision(pLSQLargument.precision);
            }
            if (pLSQLargument.scale != Integer.MIN_VALUE) {
                databaseField.setScale(pLSQLargument.scale);
            }
            vector2.setElementAt(databaseField, pLSQLargument.inIndex - 1);
            Object object = abstractRecord2.get(databaseField);
            vector3.setElementAt(object, pLSQLargument.inIndex - 1);
        }

        public void buildOutputRow(PLSQLargument pLSQLargument, AbstractRecord abstractRecord, DatabaseRecord databaseRecord, Vector vector, Vector vector2) {
            DatabaseField databaseField = null;
            for (DatabaseField databaseField2 : vector) {
                if (!databaseField2.getName().equals(pLSQLargument.name)) continue;
                databaseField = databaseField2;
                break;
            }
            Object object = abstractRecord.get(databaseField);
            databaseRecord.add(databaseField, object);
        }

        public void logParameter(StringBuilder stringBuilder, Integer n, PLSQLargument pLSQLargument, AbstractRecord abstractRecord, DatabasePlatform databasePlatform) {
            if (n == DatasourceCall.IN && pLSQLargument.inIndex != Integer.MIN_VALUE) {
                stringBuilder.append(":");
                stringBuilder.append(pLSQLargument.inIndex);
                stringBuilder.append(" => ");
                stringBuilder.append(databasePlatform.convertToDatabaseType(abstractRecord.get(pLSQLargument.name)));
            }
            if (n == DatasourceCall.OUT && pLSQLargument.outIndex != Integer.MIN_VALUE) {
                stringBuilder.append(pLSQLargument.name);
                stringBuilder.append(" => :");
                stringBuilder.append(pLSQLargument.outIndex);
            }
        }
    }
}

