/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.internal.helper.JDK15Platform;
import org.eclipse.persistence.internal.helper.JDKPlatform;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class JavaPlatform {
    protected static JDKPlatform platform = null;

    protected static JDKPlatform getPlatform() {
        if (platform == null) {
            if (Version.isJDK15()) {
                try {
                    Class clazz = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName("org.eclipse.persistence.internal.helper.JDK15Platform"));
                        }
                        catch (PrivilegedActionException privilegedActionException) {}
                    } else {
                        clazz = PrivilegedAccessHelper.getClassForName("org.eclipse.persistence.internal.helper.JDK15Platform");
                    }
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            platform = (JDKPlatform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                        }
                        catch (PrivilegedActionException privilegedActionException) {}
                    } else {
                        platform = (JDKPlatform)PrivilegedAccessHelper.newInstanceFromClass(clazz);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (platform == null) {
                platform = new JDK15Platform();
            }
        }
        return platform;
    }

    public static Boolean conformLike(Object object, Object object2) {
        return JavaPlatform.getPlatform().conformLike(object, object2);
    }

    public static Map getConcurrentMap() {
        return JavaPlatform.getPlatform().getConcurrentMap();
    }
}

