/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.io.Serializable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class IndirectionPolicy
implements Cloneable,
Serializable {
    protected DatabaseMapping mapping;

    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        return this.getMapping().buildBackupCloneForPartObject(object, object2, object3, unitOfWorkImpl);
    }

    protected ReadObjectQuery buildCascadeQuery(MergeManager mergeManager) {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        if (mergeManager.shouldCascadeAllParts()) {
            readObjectQuery.cascadeAllParts();
            readObjectQuery.refreshIdentityMapResult();
        }
        if (mergeManager.shouldCascadePrivateParts() && this.getForeignReferenceMapping().isPrivateOwned()) {
            readObjectQuery.cascadePrivateParts();
            readObjectQuery.refreshIdentityMapResult();
        }
        return readObjectQuery;
    }

    public abstract Object buildIndirectObject(ValueHolderInterface var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract Object cloneAttribute(Object var1, Object var2, Object var3, UnitOfWorkImpl var4, boolean var5);

    public Vector extractPrimaryKeyForReferenceObject(Object object, AbstractSession abstractSession) {
        return this.getOneToOneMapping().extractPrimaryKeysFromRealReferenceObject(object, abstractSession);
    }

    public abstract AbstractRecord extractReferenceRow(Object var1);

    public abstract void fixObjectReferences(Object var1, Map var2, Map var3, ObjectLevelReadQuery var4, RemoteSession var5);

    protected CollectionMapping getCollectionMapping() {
        return (CollectionMapping)this.getMapping();
    }

    protected ForeignReferenceMapping getForeignReferenceMapping() {
        return (ForeignReferenceMapping)this.getMapping();
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected ObjectReferenceMapping getOneToOneMapping() {
        return (ObjectReferenceMapping)this.getMapping();
    }

    public abstract Object getOriginalIndirectionObject(Object var1, AbstractSession var2);

    public abstract Object getOriginalValueHolder(Object var1, AbstractSession var2);

    public abstract Object getRealAttributeValueFromObject(Object var1, Object var2);

    public void instantiateObject(Object object, Object object2) {
        this.getRealAttributeValueFromObject(object, object2);
    }

    protected AbstractTransformationMapping getTransformationMapping() {
        return (AbstractTransformationMapping)this.getMapping();
    }

    public static Object getValueFromProxy(Object object) {
        return object;
    }

    public abstract Object getValueFromRemoteValueHolder(RemoteValueHolder var1);

    public void initialize() {
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (object != null) {
            this.getMapping().iterateOnRealAttributeValue(descriptorIterator, object);
        }
    }

    protected void mergeClientIntoServerValueHolder(RemoteValueHolder remoteValueHolder, MergeManager mergeManager) {
        remoteValueHolder.setMapping(this.getMapping());
        remoteValueHolder.setSession(mergeManager.getSession());
        if (this.getMapping().isForeignReferenceMapping()) {
            ReadObjectQuery readObjectQuery = this.buildCascadeQuery(mergeManager);
            remoteValueHolder.setQuery(readObjectQuery);
        }
    }

    public abstract void mergeRemoteValueHolder(Object var1, Object var2, MergeManager var3);

    public abstract Object nullValueFromRow();

    public abstract boolean objectIsInstantiated(Object var1);

    public boolean objectIsInstantiatedOrChanged(Object object) {
        return this.objectIsInstantiated(object);
    }

    public void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        this.getMapping().setAttributeValueInObject(object, object2);
    }

    public void reset(Object object) {
    }

    public boolean usesIndirection() {
        return true;
    }

    public boolean usesTransparentIndirection() {
        return false;
    }

    public Object validateAttributeOfInstantiatedObject(Object object) throws DescriptorException {
        return object;
    }

    public void validateContainerPolicy(IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateDeclaredAttributeTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateGetMethodReturnTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public void validateSetMethodParameterTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
    }

    public abstract Object valueFromBatchQuery(ReadQuery var1, AbstractRecord var2, ObjectLevelReadQuery var3);

    public abstract Object valueFromMethod(Object var1, AbstractRecord var2, AbstractSession var3);

    public abstract Object valueFromQuery(ReadQuery var1, AbstractRecord var2, AbstractSession var3);

    public abstract Object valueFromRow(Object var1);
}

