/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteAllStatement;
import org.eclipse.persistence.internal.expressions.SQLDeleteAllStatementForTempTable;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateAllStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateAllStatementForOracleAnonymousBlock;
import org.eclipse.persistence.internal.expressions.SQLUpdateAllStatementForTempTable;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.DatasourceCallQueryMechanism;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.UpdateAllQuery;

public class ExpressionQueryMechanism
extends StatementQueryMechanism {
    protected Expression selectionCriteria;

    public ExpressionQueryMechanism(DatabaseQuery databaseQuery) {
        super(databaseQuery);
    }

    public ExpressionQueryMechanism(DatabaseQuery databaseQuery, Expression expression) {
        super(databaseQuery);
        this.selectionCriteria = expression;
    }

    protected Vector aliasFields(ObjectExpression objectExpression, Vector vector) {
        Vector<DatabaseField> vector2 = new Vector<DatabaseField>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)((DatabaseField)enumeration.nextElement()).clone();
            databaseField.setTable(objectExpression.aliasForTable(databaseField.getTable()));
            vector2.addElement(databaseField);
        }
        return vector2;
    }

    public Vector aliasPresetFields(SQLSelectStatement sQLSelectStatement) {
        Vector vector = sQLSelectStatement.getFields();
        Expression expression = sQLSelectStatement.getWhereClause();
        if (expression == null) {
            return vector;
        }
        ExpressionBuilder expressionBuilder = expression.getBuilder();
        return this.aliasFields(expressionBuilder, vector);
    }

    public Expression buildBaseSelectionCriteria(boolean bl, Map map) {
        DescriptorQueryManager descriptorQueryManager;
        Expression expression = this.getSelectionCriteria();
        if (expression == null && this.getQuery().isObjectLevelReadQuery()) {
            expression = ((ObjectLevelReadQuery)this.getQuery()).getExpressionBuilder();
        }
        if (!bl && expression != null) {
            expression = expression.copiedVersionFrom(map);
        }
        if (!((descriptorQueryManager = this.getDescriptor().getQueryManager()).getAdditionalJoinExpression() == null || this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasView())) {
            Expression expression2 = descriptorQueryManager.getAdditionalJoinExpression();
            if (expression == null) {
                expression = (Expression)expression2.clone();
            } else {
                if (this.query.isObjectLevelReadQuery()) {
                    ExpressionBuilder expressionBuilder = ((ObjectLevelReadQuery)this.query).getExpressionBuilder();
                    if (expression2.getBuilder() != expressionBuilder && expression2.getBuilder().getQueryClass() == null) {
                        if (!bl && expressionBuilder != null) {
                            expressionBuilder = (ExpressionBuilder)expressionBuilder.copiedVersionFrom(map);
                        }
                        expression2 = expression2.rebuildOn(expressionBuilder);
                    }
                }
                expression = expression.and(expression2);
            }
            expression2.getBuilder().setWasAdditionJoinCriteriaUsed(true);
        }
        return expression;
    }

    public SQLSelectStatement buildBaseSelectStatement(boolean bl, Map map) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        sQLSelectStatement.setQuery(objectLevelReadQuery);
        sQLSelectStatement.setLockingClause(objectLevelReadQuery.getLockingClause());
        sQLSelectStatement.setDistinctState(objectLevelReadQuery.getDistinctState());
        sQLSelectStatement.setTables((Vector)this.getDescriptor().getTables().clone());
        sQLSelectStatement.setWhereClause(this.buildBaseSelectionCriteria(bl, map));
        if (objectLevelReadQuery.isReadAllQuery() && ((ReadAllQuery)objectLevelReadQuery).hasOrderByExpressions()) {
            sQLSelectStatement.setOrderByExpressions(this.cloneExpressions(((ReadAllQuery)this.getQuery()).getOrderByExpressions(), map));
        }
        if (this.getQuery().isReadAllQuery() && ((ReadAllQuery)this.getQuery()).hasHierarchicalExpressions()) {
            ReadAllQuery readAllQuery = (ReadAllQuery)objectLevelReadQuery;
            sQLSelectStatement.setHierarchicalQueryExpressions(readAllQuery.getStartWithExpression(), readAllQuery.getConnectByExpression(), readAllQuery.getOrderSiblingsByExpressions());
        }
        sQLSelectStatement.setHintString(objectLevelReadQuery.getHintString());
        sQLSelectStatement.setTranslationRow(this.getTranslationRow());
        return sQLSelectStatement;
    }

    protected SQLSelectStatement buildConcreteSelectStatement() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        SQLSelectStatement sQLSelectStatement = this.buildBaseSelectStatement(false, identityHashMap);
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses()) {
            Expression expression = this.getDescriptor().getInheritancePolicy().getOnlyInstancesExpression();
            if (expression != null && sQLSelectStatement.getWhereClause() != null) {
                sQLSelectStatement.setWhereClause(sQLSelectStatement.getWhereClause().and(expression));
            } else if (expression != null) {
                sQLSelectStatement.setWhereClause((Expression)expression.clone());
            }
        }
        sQLSelectStatement.setFields(this.getSelectionFields(sQLSelectStatement, false));
        sQLSelectStatement.normalize(this.getSession(), this.getDescriptor(), identityHashMap);
        if (((ObjectLevelReadQuery)this.getQuery()).hasJoining()) {
            ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(false, this.getSession(), 0);
        }
        return sQLSelectStatement;
    }

    protected SQLDeleteStatement buildDeleteAllStatement(DatabaseTable databaseTable, Expression expression, SQLCall sQLCall, SQLSelectStatement sQLSelectStatement, SQLCall sQLCall2, SQLSelectStatement sQLSelectStatement2, Collection collection) {
        if (sQLCall == null && sQLCall2 == null) {
            return this.buildDeleteStatementForDeleteAllQuery(databaseTable, expression);
        }
        SQLDeleteAllStatement sQLDeleteAllStatement = new SQLDeleteAllStatement();
        sQLDeleteAllStatement.setTable(databaseTable);
        sQLDeleteAllStatement.setTranslationRow(this.getTranslationRow());
        if (sQLCall != null) {
            sQLDeleteAllStatement.setSelectCallForExist(sQLCall);
            sQLDeleteAllStatement.setShouldExtractWhereClauseFromSelectCallForExist(!sQLSelectStatement.requiresAliases() && databaseTable.equals(sQLSelectStatement.getTables().firstElement()));
            sQLDeleteAllStatement.setTableAliasInSelectCallForExist(ExpressionQueryMechanism.getAliasTableName(sQLSelectStatement, databaseTable));
        } else if (expression != null) {
            sQLDeleteAllStatement.setInheritanceExpression((Expression)expression.clone());
        }
        if (sQLCall2 != null) {
            sQLDeleteAllStatement.setSelectCallForNotExist(sQLCall2);
            sQLDeleteAllStatement.setTableAliasInSelectCallForNotExist(ExpressionQueryMechanism.getAliasTableName(sQLSelectStatement2, databaseTable));
        }
        sQLDeleteAllStatement.setPrimaryKeyFieldsForAutoJoin(collection);
        return sQLDeleteAllStatement;
    }

    protected SQLDeleteStatement buildDeleteAllStatementForMapping(SQLCall sQLCall, SQLSelectStatement sQLSelectStatement, Vector vector, Vector vector2) {
        DatabaseTable databaseTable = ((DatabaseField)vector2.firstElement()).getTable();
        if (sQLCall == null) {
            return this.buildDeleteStatementForDeleteAllQuery(databaseTable);
        }
        SQLDeleteAllStatement sQLDeleteAllStatement = new SQLDeleteAllStatement();
        sQLDeleteAllStatement.setTable(databaseTable);
        sQLDeleteAllStatement.setTranslationRow(this.getTranslationRow());
        sQLDeleteAllStatement.setSelectCallForExist(sQLCall);
        DatabaseTable databaseTable2 = ((DatabaseField)vector.firstElement()).getTable();
        if (sQLSelectStatement != null) {
            sQLDeleteAllStatement.setTableAliasInSelectCallForExist(ExpressionQueryMechanism.getAliasTableName(sQLSelectStatement, databaseTable2));
        }
        sQLDeleteAllStatement.setAliasedFieldsForJoin(vector);
        sQLDeleteAllStatement.setOriginalFieldsForJoin(vector2);
        return sQLDeleteAllStatement;
    }

    protected Vector buildDeleteAllStatementsForMappingsWithTempTable(ClassDescriptor classDescriptor, DatabaseTable databaseTable, Collection collection, boolean bl) {
        Vector<SQLDeleteAllStatementForTempTable> vector = new Vector<SQLDeleteAllStatementForTempTable>();
        for (DatabaseMapping databaseMapping : classDescriptor.getMappings()) {
            if (!databaseMapping.isManyToManyMapping() && !databaseMapping.isDirectCollectionMapping() || !bl && !databaseMapping.getDescriptor().equals(classDescriptor)) continue;
            Vector<DatabaseField> vector2 = null;
            if (databaseMapping.isManyToManyMapping()) {
                vector2 = ((ManyToManyMapping)databaseMapping).getSourceRelationKeyFields();
            } else if (databaseMapping.isDirectCollectionMapping()) {
                vector2 = ((DirectCollectionMapping)databaseMapping).getReferenceKeyFields();
            }
            DatabaseTable databaseTable2 = vector2.firstElement().getTable();
            SQLDeleteAllStatementForTempTable sQLDeleteAllStatementForTempTable = this.buildDeleteAllStatementForTempTable(databaseTable, collection, databaseTable2, vector2);
            vector.addElement(sQLDeleteAllStatementForTempTable);
        }
        return vector;
    }

    protected static String getAliasTableName(SQLSelectStatement sQLSelectStatement, DatabaseTable databaseTable) {
        Map.Entry entry;
        if (!sQLSelectStatement.requiresAliases()) {
            return null;
        }
        HashSet<DatabaseTable> hashSet = new HashSet<DatabaseTable>();
        Iterator iterator = sQLSelectStatement.getTableAliases().entrySet().iterator();
        DatabaseTable databaseTable2 = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!databaseTable.equals(entry.getValue())) continue;
            databaseTable2 = (DatabaseTable)entry.getKey();
            hashSet.add(databaseTable2);
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        if (hashSet.size() == 1) {
            return databaseTable2.getQualifiedName();
        }
        entry = new ExpressionIterator(){

            public void iterate(Expression expression) {
                DataExpression dataExpression;
                DatabaseField databaseField;
                if (expression instanceof DataExpression && (databaseField = (dataExpression = (DataExpression)expression).getField()) != null && dataExpression.getBaseExpression() != this.getStatement().getBuilder()) {
                    ((Collection)this.getResult()).remove(dataExpression.getAliasedField().getTable());
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        ((ExpressionIterator)((Object)entry)).setStatement(sQLSelectStatement);
        ((ExpressionIterator)((Object)entry)).setResult(hashSet);
        ((ExpressionIterator)((Object)entry)).iterateOn(sQLSelectStatement.getWhereClause());
        if (hashSet.size() == 1) {
            databaseTable2 = (DatabaseTable)hashSet.iterator().next();
            return databaseTable2.getQualifiedName();
        }
        if (hashSet.isEmpty()) {
            return databaseTable2.getQualifiedName();
        }
        databaseTable2 = (DatabaseTable)hashSet.iterator().next();
        return databaseTable2.getQualifiedName();
    }

    protected SQLDeleteStatement buildDeleteStatementForDeleteAllQuery(DatabaseTable databaseTable) {
        return this.buildDeleteStatementForDeleteAllQuery(databaseTable, null);
    }

    protected SQLDeleteStatement buildDeleteStatementForDeleteAllQuery(DatabaseTable databaseTable, Expression expression) {
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        if (expression != null) {
            sQLDeleteStatement.setWhereClause((Expression)expression.clone());
        }
        sQLDeleteStatement.setTable(databaseTable);
        sQLDeleteStatement.setTranslationRow(this.getTranslationRow());
        sQLDeleteStatement.setHintString(this.getQuery().getHintString());
        return sQLDeleteStatement;
    }

    protected SQLDeleteStatement buildDeleteStatement(DatabaseTable databaseTable) {
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        Expression expression = this.getDescriptor().getObjectBuilder().buildDeleteExpression(databaseTable, this.getTranslationRow());
        sQLDeleteStatement.setWhereClause(expression);
        sQLDeleteStatement.setTable(databaseTable);
        sQLDeleteStatement.setTranslationRow(this.getTranslationRow());
        sQLDeleteStatement.setHintString(this.getQuery().getHintString());
        return sQLDeleteStatement;
    }

    protected SQLInsertStatement buildInsertStatement(DatabaseTable databaseTable) {
        SQLInsertStatement sQLInsertStatement = new SQLInsertStatement();
        sQLInsertStatement.setTable(databaseTable);
        sQLInsertStatement.setModifyRow(this.getModifyRow());
        if (this.getDescriptor().hasReturningPolicy()) {
            sQLInsertStatement.setReturnFields(this.getDescriptor().getReturningPolicy().getFieldsToGenerateInsert(databaseTable));
        }
        sQLInsertStatement.setHintString(this.getQuery().getHintString());
        return sQLInsertStatement;
    }

    protected SQLSelectStatement buildNormalSelectStatement() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        SQLSelectStatement sQLSelectStatement = this.buildBaseSelectStatement(false, identityHashMap);
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().appendWithAllSubclassesExpression(sQLSelectStatement);
            if (!objectLevelReadQuery.isReportQuery() && objectLevelReadQuery.shouldOuterJoinSubclasses()) {
                sQLSelectStatement.getExpressionBuilder().setShouldUseOuterJoinForMultitableInheritance(true);
            }
        }
        sQLSelectStatement.setFields(this.getSelectionFields(sQLSelectStatement, true));
        sQLSelectStatement.setNonSelectFields(this.getNonSelectionFields());
        sQLSelectStatement.normalize(this.getSession(), this.getDescriptor(), identityHashMap);
        if (((ObjectLevelReadQuery)this.getQuery()).hasJoining()) {
            ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), 0);
        }
        return sQLSelectStatement;
    }

    protected SQLSelectStatement buildReportQuerySelectStatement(boolean bl) {
        return this.buildReportQuerySelectStatement(bl, false, null);
    }

    protected SQLSelectStatement buildReportQuerySelectStatement(boolean bl, boolean bl2, Expression expression) {
        int n;
        int n2;
        List list;
        ConstructorReportItem constructorReportItem;
        IdentityHashMap identityHashMap = bl ? null : new IdentityHashMap();
        SQLSelectStatement sQLSelectStatement = this.buildBaseSelectStatement(bl, identityHashMap);
        sQLSelectStatement.setGroupByExpressions(((ReportQuery)this.getQuery()).getGroupByExpressions());
        sQLSelectStatement.setHavingExpression(((ReportQuery)this.getQuery()).getHavingExpression());
        if (this.getDescriptor().hasInheritance()) {
            if (bl2) {
                if (expression != null) {
                    if (sQLSelectStatement.getWhereClause() == null) {
                        sQLSelectStatement.setWhereClause((Expression)expression.clone());
                    } else {
                        sQLSelectStatement.setWhereClause(sQLSelectStatement.getWhereClause().and(expression));
                    }
                }
            } else {
                this.getDescriptor().getInheritancePolicy().appendWithAllSubclassesExpression(sQLSelectStatement);
            }
        }
        Vector vector = ((ReportQuery)this.getQuery()).getQueryExpressions();
        int n3 = vector.size();
        for (ReportItem reportItem : ((ReportQuery)this.getQuery()).getItems()) {
            if (reportItem.isConstructorItem()) {
                constructorReportItem = (ConstructorReportItem)reportItem;
                list = constructorReportItem.getReportItems();
                n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    reportItem = (ReportItem)list.get(n);
                    this.extractStatementFromItem(reportItem, identityHashMap, sQLSelectStatement, vector);
                }
                continue;
            }
            this.extractStatementFromItem(reportItem, identityHashMap, sQLSelectStatement, vector);
        }
        sQLSelectStatement.setFields(vector);
        sQLSelectStatement.setNonSelectFields(((ReportQuery)this.getQuery()).getNonFetchJoinAttributeExpressions());
        if (!bl) {
            sQLSelectStatement.normalize(this.getSession(), this.getDescriptor(), identityHashMap);
        }
        for (ReportItem reportItem : ((ReportQuery)this.getQuery()).getItems()) {
            if (reportItem.isConstructorItem()) {
                constructorReportItem = (ConstructorReportItem)reportItem;
                list = constructorReportItem.getReportItems();
                n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    reportItem = (ReportItem)list.get(n);
                    n3 = this.computeAndSetItemOffset(reportItem, n3);
                }
                continue;
            }
            n3 = this.computeAndSetItemOffset(reportItem, n3);
        }
        return sQLSelectStatement;
    }

    protected int computeAndSetItemOffset(ReportItem reportItem, int n) {
        reportItem.setResultIndex(n);
        if (reportItem.getAttributeExpression() != null) {
            n = reportItem.hasJoining() ? reportItem.getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), n) : (reportItem.getDescriptor() != null ? (n += reportItem.getDescriptor().getAllFields().size()) : ++n);
        }
        return n;
    }

    public void extractStatementFromItem(ReportItem reportItem, Map map, SQLSelectStatement sQLSelectStatement, Vector vector) {
        if (reportItem.getAttributeExpression() != null) {
            Expression expression = reportItem.getAttributeExpression();
            ExpressionBuilder expressionBuilder = expression.getBuilder();
            if (expressionBuilder.wasQueryClassSetInternally() && ((ReportQuery)this.getQuery()).getExpressionBuilder() != expressionBuilder) {
                expressionBuilder = sQLSelectStatement.getBuilder();
                expression = expression.rebuildOn(expressionBuilder);
            } else if (map != null && map.get(expressionBuilder) != null) {
                Expression expression2 = (Expression)map.get(expression);
                if (expression2 != null && !expression2.isExpressionBuilder()) {
                    expression = expression2;
                } else {
                    expressionBuilder = (ExpressionBuilder)expressionBuilder.copiedVersionFrom(map);
                    expression = expression.rebuildOn(expressionBuilder);
                }
            }
            if (expression.isExpressionBuilder() && reportItem.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null && !expressionBuilder.wasAdditionJoinCriteriaUsed()) {
                if (sQLSelectStatement.getWhereClause() == null) {
                    sQLSelectStatement.setWhereClause(reportItem.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(expressionBuilder));
                } else {
                    sQLSelectStatement.setWhereClause(sQLSelectStatement.getWhereClause().and(reportItem.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(expressionBuilder)));
                }
            }
            vector.add(expression);
            if (reportItem.hasJoining()) {
                vector.addAll(reportItem.getJoinedAttributeManager().getJoinedAttributeExpressions());
                vector.addAll(reportItem.getJoinedAttributeManager().getJoinedMappingExpressions());
            }
        }
    }

    protected SQLSelectStatement buildSelectStatementForDoesExist(DatabaseField databaseField) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.addField(databaseField);
        sQLSelectStatement.setWhereClause(((Expression)this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression().clone()).and(this.getDescriptor().getQueryManager().getAdditionalJoinExpression()));
        sQLSelectStatement.setTranslationRow(this.getTranslationRow());
        sQLSelectStatement.normalize(this.getSession(), this.getQuery().getDescriptor());
        sQLSelectStatement.setHintString(this.getQuery().getHintString());
        return sQLSelectStatement;
    }

    protected SQLUpdateAllStatement buildUpdateAllStatement(DatabaseTable databaseTable, HashMap hashMap, SQLCall sQLCall, SQLSelectStatement sQLSelectStatement, Collection collection) {
        SQLUpdateAllStatement sQLUpdateAllStatement = new SQLUpdateAllStatement();
        sQLUpdateAllStatement.setTable(databaseTable);
        sQLUpdateAllStatement.setTranslationRow(this.getTranslationRow());
        HashMap<DatabaseField, SQLCall> hashMap2 = new HashMap<DatabaseField, SQLCall>(hashMap.size());
        HashMap<DatabaseField, String> hashMap3 = null;
        for (Map.Entry entry : hashMap.entrySet()) {
            DatabaseField databaseField = (DatabaseField)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof SQLSelectStatement) {
                SQLSelectStatement sQLSelectStatement2 = (SQLSelectStatement)v;
                SQLCall sQLCall2 = (SQLCall)sQLSelectStatement2.buildCall(this.getSession());
                hashMap2.put(databaseField, sQLCall2);
                if (hashMap3 == null) {
                    hashMap3 = new HashMap<DatabaseField, String>();
                    sQLUpdateAllStatement.setPrimaryKeyFieldsForAutoJoin(collection);
                }
                hashMap3.put(databaseField, ExpressionQueryMechanism.getAliasTableName(sQLSelectStatement2, databaseTable));
                continue;
            }
            hashMap2.put(databaseField, (SQLCall)v);
        }
        sQLUpdateAllStatement.setUpdateClauses(hashMap2);
        sQLUpdateAllStatement.setDatabaseFieldsToTableAliases(hashMap3);
        sQLUpdateAllStatement.setSelectCallForExist(sQLCall);
        sQLUpdateAllStatement.setShouldExtractWhereClauseFromSelectCallForExist(!sQLSelectStatement.requiresAliases() && databaseTable.equals(sQLSelectStatement.getTables().firstElement()));
        sQLUpdateAllStatement.setTableAliasInSelectCallForExist(ExpressionQueryMechanism.getAliasTableName(sQLSelectStatement, databaseTable));
        sQLUpdateAllStatement.setPrimaryKeyFieldsForAutoJoin(collection);
        return sQLUpdateAllStatement;
    }

    protected SQLUpdateStatement buildUpdateStatement(DatabaseTable databaseTable) {
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        sQLUpdateStatement.setModifyRow(this.getModifyRow());
        sQLUpdateStatement.setTranslationRow(this.getTranslationRow());
        if (this.getDescriptor().hasReturningPolicy()) {
            sQLUpdateStatement.setReturnFields(this.getDescriptor().getReturningPolicy().getFieldsToGenerateUpdate(databaseTable));
        }
        sQLUpdateStatement.setTable(databaseTable);
        sQLUpdateStatement.setWhereClause(this.getDescriptor().getObjectBuilder().buildUpdateExpression(databaseTable, this.getTranslationRow(), this.getModifyRow()));
        sQLUpdateStatement.setHintString(this.getQuery().getHintString());
        return sQLUpdateStatement;
    }

    public Object checkCacheForObject(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Cloneable cloneable;
        Vector vector;
        Expression expression;
        Object object;
        int n;
        UnitOfWorkImpl unitOfWorkImpl;
        boolean bl;
        ClassDescriptor classDescriptor;
        ReadObjectQuery readObjectQuery;
        block35: {
            readObjectQuery = this.getReadObjectQuery();
            classDescriptor = this.getDescriptor();
            bl = false;
            unitOfWorkImpl = null;
            if (abstractSession.isUnitOfWork()) {
                bl = readObjectQuery.shouldConformResultsInUnitOfWork() || classDescriptor.shouldAlwaysConformResultsInUnitOfWork();
                unitOfWorkImpl = (UnitOfWorkImpl)abstractSession;
            }
            n = readObjectQuery.getInMemoryQueryIndirectionPolicyState();
            if (bl && n != 1) {
                n = 2;
            }
            object = null;
            expression = this.getSelectionCriteria();
            vector = readObjectQuery.getSelectionKey();
            Object object2 = readObjectQuery.getSelectionObject();
            if (vector != null || object2 != null) {
                if (vector == null) {
                    vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object2, abstractSession, true);
                    if (vector == null) {
                        return InvalidObject.instance;
                    }
                    readObjectQuery.setSelectionKey(vector);
                }
                object = classDescriptor.shouldAcquireCascadedLocks() ? abstractSession.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(vector, readObjectQuery.getReferenceClass(), false, classDescriptor) : abstractSession.getIdentityMapAccessorInstance().getFromIdentityMap(vector, readObjectQuery.getReferenceClass(), false, classDescriptor);
                if (vector.contains(null)) {
                    return InvalidObject.instance;
                }
            } else if (expression == null) {
                if (readObjectQuery.shouldConformResultsInUnitOfWork() || classDescriptor.shouldAlwaysConformResultsInUnitOfWork() || readObjectQuery.shouldCheckCacheOnly() || readObjectQuery.shouldCheckCacheThenDatabase()) {
                    object = abstractSession.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(null, readObjectQuery.getReferenceClass(), abstractRecord, n, bl, false, classDescriptor);
                }
            } else {
                vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromExpression(true, expression, abstractRecord, abstractSession);
                if (vector != null || readObjectQuery.shouldCheckCacheByExactPrimaryKey()) {
                    if (vector != null) {
                        object = classDescriptor.shouldAcquireCascadedLocks() ? abstractSession.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(vector, readObjectQuery.getReferenceClass(), false, classDescriptor) : abstractSession.getIdentityMapAccessorInstance().getFromIdentityMap(vector, readObjectQuery.getReferenceClass(), false, classDescriptor);
                        if (vector.contains(null)) {
                            return InvalidObject.instance;
                        }
                    }
                } else {
                    boolean bl2;
                    cloneable = classDescriptor.getObjectBuilder().extractPrimaryKeyFromExpression(false, expression, abstractRecord, abstractSession);
                    if (cloneable != null && (object = classDescriptor.shouldAcquireCascadedLocks() ? abstractSession.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock((Vector)cloneable, readObjectQuery.getReferenceClass(), false, classDescriptor) : abstractSession.getIdentityMapAccessorInstance().getFromIdentityMap((Vector)cloneable, readObjectQuery.getReferenceClass(), false, classDescriptor)) != null) {
                        try {
                            ExpressionBuilder expressionBuilder = expression.getBuilder();
                            expressionBuilder.setSession(abstractSession.getRootSession(null));
                            expressionBuilder.setQueryClass(classDescriptor.getJavaClass());
                            if (!expression.doesConform(object, abstractSession, abstractRecord, n)) {
                                object = null;
                            }
                        }
                        catch (QueryException queryException) {
                            if (readObjectQuery.shouldCheckCacheOnly()) {
                                throw queryException;
                            }
                            object = null;
                        }
                    }
                    boolean bl3 = bl2 = (readObjectQuery.shouldConformResultsInUnitOfWork() || classDescriptor.shouldAlwaysConformResultsInUnitOfWork()) && !abstractSession.isUnitOfWork();
                    if (object == null && (bl || !readObjectQuery.shouldCheckCacheByPrimaryKey() && !bl2)) {
                        if (expression != null) {
                            ExpressionBuilder expressionBuilder = expression.getBuilder();
                            expressionBuilder.setSession(abstractSession.getRootSession(null));
                            expressionBuilder.setQueryClass(classDescriptor.getJavaClass());
                        }
                        try {
                            object = abstractSession.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(expression, readObjectQuery.getReferenceClass(), abstractRecord, n, bl, false, classDescriptor);
                        }
                        catch (QueryException queryException) {
                            if (!readObjectQuery.shouldCheckCacheOnly()) break block35;
                            throw queryException;
                        }
                    }
                }
            }
        }
        if (bl) {
            if (object == null) {
                if (vector != null) {
                    if (!unitOfWorkImpl.shouldNewObjectsBeCached()) {
                        object = unitOfWorkImpl.getObjectFromNewObjects(readObjectQuery.getReferenceClass(), vector);
                    }
                } else {
                    if (expression != null) {
                        cloneable = expression.getBuilder();
                        ((ExpressionBuilder)cloneable).setSession(abstractSession.getRootSession(null));
                        ((ExpressionBuilder)cloneable).setQueryClass(classDescriptor.getJavaClass());
                    }
                    try {
                        object = unitOfWorkImpl.getObjectFromNewObjects(expression, readObjectQuery.getReferenceClass(), abstractRecord, n);
                    }
                    catch (QueryException queryException) {
                        // empty catch block
                    }
                }
            }
            if (object != null && unitOfWorkImpl.isObjectDeleted(object)) {
                if (vector != null) {
                    return InvalidObject.instance;
                }
                object = null;
            }
        }
        if (object != null && classDescriptor.hasFetchGroupManager() && classDescriptor.getFetchGroupManager().isPartialObject(object) && !classDescriptor.getFetchGroupManager().isObjectValidForFetchGroup(object, readObjectQuery.getFetchGroup())) {
            object = null;
        }
        if (object == null && readObjectQuery.shouldCheckCacheOnly() && !abstractSession.isUnitOfWork()) {
            return InvalidObject.instance;
        }
        return object;
    }

    public void clearStatement() {
        this.setSQLStatement(null);
        this.setSQLStatements(null);
    }

    public DatabaseQueryMechanism clone(DatabaseQuery databaseQuery) {
        DatabaseQueryMechanism databaseQueryMechanism = (DatabaseQueryMechanism)this.clone();
        databaseQueryMechanism.setQuery(databaseQuery);
        return databaseQueryMechanism;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.getSelectionCriteria() != null) {
            return this.getSelectionCriteria().getBuilder();
        }
        return null;
    }

    public Expression getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public Vector getSelectionFields(SQLSelectStatement sQLSelectStatement, boolean bl) {
        Vector vector;
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        if (objectLevelReadQuery.hasPartialAttributeExpressions()) {
            return objectLevelReadQuery.getPartialAttributeSelectionFields(false);
        }
        if (objectLevelReadQuery.hasFetchGroup()) {
            return objectLevelReadQuery.getFetchGroupSelectionFields(false);
        }
        ExpressionBuilder expressionBuilder = sQLSelectStatement.getExpressionBuilder();
        if (bl) {
            vector = (Vector)this.getDescriptor().getAllFields().clone();
        } else {
            vector = NonSynchronizedVector.newInstance();
            ((Vector)vector).addElement(expressionBuilder);
        }
        if (objectLevelReadQuery.hasJoining()) {
            Helper.addAllToVector(vector, objectLevelReadQuery.getJoinedAttributeManager().getJoinedAttributeExpressions());
            Helper.addAllToVector(vector, objectLevelReadQuery.getJoinedAttributeManager().getJoinedMappingExpressions());
        }
        if (objectLevelReadQuery.hasAdditionalFields()) {
            Helper.addAllToVector(vector, objectLevelReadQuery.getAdditionalFields());
        }
        return vector;
    }

    public Vector getNonSelectionFields() {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        ((Vector)nonSynchronizedVector).addAll(((ObjectLevelReadQuery)this.getQuery()).getNonFetchJoinAttributeExpressions());
        return nonSynchronizedVector;
    }

    public boolean isExpressionQueryMechanism() {
        return true;
    }

    public boolean isStatementQueryMechanism() {
        return false;
    }

    public void prepare() throws QueryException {
    }

    public void prepareCursorSelectAllRows() {
        if (this.getQuery().isReportQuery()) {
            SQLSelectStatement sQLSelectStatement = this.buildReportQuerySelectStatement(false);
            this.setSQLStatement(sQLSelectStatement);
        } else if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && this.getDescriptor().getInheritancePolicy().hasView()) {
            InheritancePolicy inheritancePolicy = this.getDescriptor().getInheritancePolicy();
            SQLSelectStatement sQLSelectStatement = inheritancePolicy.buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery());
            this.setSQLStatement(sQLSelectStatement);
        } else {
            this.setSQLStatement(this.buildNormalSelectStatement());
        }
        super.prepareCursorSelectAllRows();
    }

    public void prepareDeleteAll() {
        this.prepareDeleteAll(null);
    }

    protected void prepareDeleteAll(Vector vector) {
        boolean bl;
        Cloneable cloneable;
        Cloneable cloneable2;
        Vector<DatabaseTable> vector2;
        if (vector == null) {
            vector2 = this.getDescriptor().getMultipleTableInsertOrder();
        } else {
            vector2 = new Vector(this.getDescriptor().getMultipleTableInsertOrder().size());
            for (DatabaseTable cloneable3 : this.getDescriptor().getMultipleTableInsertOrder()) {
                if (vector.contains(cloneable3)) continue;
                vector2.addElement(cloneable3);
            }
        }
        boolean bl2 = this.getDescriptor().hasInheritance();
        if (!vector2.isEmpty()) {
            Object object;
            boolean bl3;
            Expression bl6 = this.getSelectionCriteria();
            SQLCall sQLCall = null;
            boolean bl4 = vector == null && vector2.size() > 1;
            Object object2 = null;
            Cloneable cloneable3 = null;
            cloneable2 = null;
            if (vector == null && bl2) {
                cloneable2 = this.getDescriptor().getInheritancePolicy().shouldReadSubclasses() ? this.getDescriptor().getInheritancePolicy().getWithAllSubclassesExpression() : this.getDescriptor().getInheritancePolicy().getOnlyInstancesExpression();
            }
            if (bl3 = ((SQLSelectStatement)(cloneable = this.createSQLSelectStatementForModifyAll(bl6))).requiresAliases()) {
                if (bl6 != null) {
                    if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll() && vector == null && !this.getSession().getPlatform().isOracle()) {
                        this.prepareDeleteAllUsingTempStorage();
                        return;
                    }
                    if (bl4) {
                        object2 = this.createSQLSelectStatementForModifyAll(null, null);
                        cloneable3 = (SQLCall)((SQLSelectStatement)object2).buildCall(this.getSession());
                    }
                } else if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll() && vector == null && !this.getSession().getPlatform().isOracle() && bl2 && (cloneable2 != null || !this.getDescriptor().getInheritancePolicy().isRootParentDescriptor())) {
                    this.prepareDeleteAllUsingTempStorage();
                    return;
                }
            } else if (bl6 != null && this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll() && vector == null && !this.getSession().getPlatform().isOracle() && bl2 && this.getDescriptor().getInheritancePolicy().hasMultipleTableChild()) {
                this.prepareDeleteAllUsingTempStorage();
                return;
            }
            if (bl6 != null) {
                sQLCall = (SQLCall)((SQLSelectStatement)cloneable).buildCall(this.getSession());
            }
            if (bl3) {
                object = vector2.elements();
                while (object.hasMoreElements()) {
                    SQLDeleteStatement sQLDeleteStatement;
                    DatabaseTable databaseTable = object.nextElement();
                    Collection collection = this.getPrimaryKeyFieldsForTable(databaseTable);
                    if (!bl4) {
                        sQLDeleteStatement = this.buildDeleteAllStatement(databaseTable, (Expression)cloneable2, sQLCall, (SQLSelectStatement)cloneable, null, null, collection);
                    } else {
                        boolean bl5 = databaseTable.equals(vector2.lastElement());
                        if (cloneable2 == null) {
                            sQLDeleteStatement = bl5 ? this.buildDeleteAllStatement(databaseTable, null, sQLCall, (SQLSelectStatement)cloneable, null, null, collection) : this.buildDeleteAllStatement(databaseTable, null, null, null, (SQLCall)cloneable3, (SQLSelectStatement)object2, collection);
                        } else if (databaseTable.equals(this.getDescriptor().getMultipleTableInsertOrder().firstElement())) {
                            sQLDeleteStatement = this.buildDeleteAllStatement(databaseTable, (Expression)cloneable2, null, null, (SQLCall)cloneable3, (SQLSelectStatement)object2, collection);
                        } else {
                            ClassDescriptor classDescriptor = this.getHighestDescriptorMappingTable(databaseTable);
                            if (classDescriptor == this.getDescriptor()) {
                                sQLDeleteStatement = bl5 ? this.buildDeleteAllStatement(databaseTable, null, sQLCall, (SQLSelectStatement)cloneable, null, null, collection) : this.buildDeleteAllStatement(databaseTable, null, null, null, (SQLCall)cloneable3, (SQLSelectStatement)object2, collection);
                            } else {
                                SQLSelectStatement sQLSelectStatement = this.createSQLSelectStatementForModifyAll(null, (Expression)cloneable2, classDescriptor);
                                SQLCall sQLCall2 = (SQLCall)sQLSelectStatement.buildCall(this.getSession());
                                sQLDeleteStatement = bl5 ? this.buildDeleteAllStatement(databaseTable, null, sQLCall2, sQLSelectStatement, null, null, collection) : this.buildDeleteAllStatement(databaseTable, null, sQLCall2, sQLSelectStatement, (SQLCall)cloneable3, (SQLSelectStatement)object2, collection);
                            }
                        }
                    }
                    if (this.getDescriptor().getTables().size() > 1) {
                        this.getSQLStatements().addElement(sQLDeleteStatement);
                        continue;
                    }
                    this.setSQLStatement(sQLDeleteStatement);
                }
            } else {
                this.setSQLStatement(this.buildDeleteAllStatement(this.getDescriptor().getDefaultTable(), (Expression)cloneable2, sQLCall, (SQLSelectStatement)cloneable, null, null, null));
            }
            if (sQLCall == null && bl2 && (vector != null || cloneable2 != null)) {
                sQLCall = (SQLCall)((SQLSelectStatement)cloneable).buildCall(this.getSession());
            }
            if (!((Vector)(object = this.buildDeleteAllStatementsForMappings(sQLCall, (SQLSelectStatement)cloneable, vector == null))).isEmpty()) {
                if (this.getSQLStatement() != null) {
                    this.getSQLStatements().add(this.getSQLStatement());
                    this.setSQLStatement(null);
                }
                this.getSQLStatements().addAll(object);
            }
        }
        boolean bl6 = bl2 && this.getDescriptor().getInheritancePolicy().hasChildren() && this.getDescriptor().getInheritancePolicy().hasMultipleTableChild();
        boolean bl7 = bl = bl6 && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses();
        if (bl) {
            Vector<DatabaseTable> vector3 = new Vector<DatabaseTable>();
            if (vector != null) {
                vector3.addAll(vector);
            }
            if (this.getDescriptor().getInheritancePolicy().shouldReadSubclasses()) {
                vector3.addAll(vector2);
            }
            for (Cloneable cloneable3 : this.getDescriptor().getInheritancePolicy().getChildDescriptors()) {
                if (((ClassDescriptor)cloneable3).getTables().size() <= this.getDescriptor().getTables().size() && !((ClassDescriptor)cloneable3).getInheritancePolicy().hasMultipleTableChild()) continue;
                cloneable2 = new DeleteAllQuery();
                ((ModifyAllQuery)cloneable2).setReferenceClass(((ClassDescriptor)cloneable3).getJavaClass());
                ((DatabaseQuery)cloneable2).setSelectionCriteria(this.getSelectionCriteria());
                ((DatabaseQuery)cloneable2).setDescriptor((ClassDescriptor)cloneable3);
                ((DatabaseQuery)cloneable2).setSession(this.getSession());
                cloneable = (ExpressionQueryMechanism)((DatabaseQuery)cloneable2).getQueryMechanism();
                ((ExpressionQueryMechanism)cloneable).prepareDeleteAll(vector3);
                Vector<SQLStatement> vector4 = new Vector<SQLStatement>();
                if (((DatasourceCallQueryMechanism)cloneable).getCall() != null) {
                    vector4.add(((StatementQueryMechanism)cloneable).getSQLStatement());
                } else if (((StatementQueryMechanism)cloneable).getSQLStatements() != null) {
                    vector4.addAll(((StatementQueryMechanism)cloneable).getSQLStatements());
                }
                if (vector4.isEmpty()) continue;
                if (this.getSQLStatement() != null) {
                    this.getSQLStatements().add(this.getSQLStatement());
                    this.setSQLStatement(null);
                }
                this.getSQLStatements().addAll(vector4);
            }
        }
        if (vector == null) {
            ((DeleteAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(false);
            super.prepareDeleteAll();
        }
    }

    protected void prepareDeleteAllUsingTempStorage() {
        if (!this.getSession().getPlatform().supportsTempTables()) {
            throw QueryException.tempTablesNotSupported(this.getQuery(), Helper.getShortClassName(this.getSession().getPlatform()));
        }
        this.prepareDeleteAllUsingTempTables();
    }

    protected void prepareDeleteAllUsingTempTables() {
        this.getSQLStatements().addAll(this.buildStatementsForDeleteAllForTempTables());
        ((DeleteAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(true);
        super.prepareDeleteAll();
    }

    protected Vector buildDeleteAllStatementsForMappings(SQLCall sQLCall, SQLSelectStatement sQLSelectStatement, boolean bl) {
        Vector<SQLDeleteStatement> vector = new Vector<SQLDeleteStatement>();
        for (DatabaseMapping databaseMapping : this.getDescriptor().getMappings()) {
            if (!databaseMapping.isManyToManyMapping() && !databaseMapping.isDirectCollectionMapping() || !bl && !databaseMapping.getDescriptor().equals(this.getDescriptor())) continue;
            Vector<DatabaseField> vector2 = null;
            Vector<DatabaseField> vector3 = null;
            if (databaseMapping.isManyToManyMapping()) {
                vector2 = ((ManyToManyMapping)databaseMapping).getSourceKeyFields();
                vector3 = ((ManyToManyMapping)databaseMapping).getSourceRelationKeyFields();
            } else if (databaseMapping.isDirectCollectionMapping()) {
                vector2 = ((DirectCollectionMapping)databaseMapping).getSourceKeyFields();
                vector3 = ((DirectCollectionMapping)databaseMapping).getReferenceKeyFields();
            }
            vector.addElement(this.buildDeleteAllStatementForMapping(sQLCall, sQLSelectStatement, vector2, vector3));
        }
        return vector;
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression expression) {
        return this.createSQLSelectStatementForModifyAll(expression, null, this.getDescriptor(), false);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression expression, Expression expression2) {
        return this.createSQLSelectStatementForModifyAll(expression, expression2, this.getDescriptor(), true);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression expression, Expression expression2, ClassDescriptor classDescriptor) {
        return this.createSQLSelectStatementForModifyAll(expression, expression2, classDescriptor, true);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression expression, Expression expression2, ClassDescriptor classDescriptor, boolean bl) {
        ExpressionBuilder expressionBuilder;
        if (expression != null) {
            expression = (Expression)expression.clone();
            expressionBuilder = expression.getBuilder();
        } else {
            expressionBuilder = new ExpressionBuilder();
        }
        ReportQuery reportQuery = new ReportQuery(classDescriptor.getJavaClass(), expressionBuilder);
        reportQuery.setDescriptor(classDescriptor);
        reportQuery.setShouldRetrieveFirstPrimaryKey(true);
        reportQuery.setSelectionCriteria(expression);
        reportQuery.setSession(this.getSession());
        return ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false, bl, expression2);
    }

    protected SQLSelectStatement createSQLSelectStatementForAssignedExpressionForUpdateAll(Expression expression) {
        ReportQuery reportQuery = new ReportQuery(this.getQuery().getReferenceClass(), expression.getBuilder());
        reportQuery.setDescriptor(this.getQuery().getDescriptor());
        reportQuery.setSession(this.getSession());
        reportQuery.addAttribute("", expression);
        return ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false);
    }

    private Vector cloneExpressions(Vector vector, Map map) {
        if (vector == null || vector.size() == 0) {
            return vector;
        }
        Vector<Expression> vector2 = new Vector<Expression>(vector.size());
        for (Expression expression : vector) {
            vector2.add(expression.copiedVersionFrom(map));
        }
        return vector2;
    }

    public void prepareDeleteObject() {
        if (this.getDescriptor().usesFieldLocking() && this.getTranslationRow() == null) {
            return;
        }
        Enumeration<DatabaseTable> enumeration = this.getDescriptor().getMultipleTableInsertOrder().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = enumeration.nextElement();
            SQLDeleteStatement sQLDeleteStatement = this.buildDeleteStatement(databaseTable);
            if (this.getDescriptor().getTables().size() > 1) {
                this.getSQLStatements().addElement(sQLDeleteStatement);
                continue;
            }
            this.setSQLStatement(sQLDeleteStatement);
        }
        super.prepareDeleteObject();
    }

    public void prepareDoesExist(DatabaseField databaseField) {
        this.setSQLStatement(this.buildSelectStatementForDoesExist(databaseField));
        super.prepareDoesExist(databaseField);
    }

    public void prepareInsertObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        Enumeration<DatabaseTable> enumeration = this.getDescriptor().getMultipleTableInsertOrder().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = enumeration.nextElement();
            SQLInsertStatement sQLInsertStatement = this.buildInsertStatement(databaseTable);
            if (this.getDescriptor().getTables().size() > 1) {
                this.getSQLStatements().addElement(sQLInsertStatement);
                continue;
            }
            this.setSQLStatement(sQLInsertStatement);
        }
        super.prepareInsertObject();
    }

    public void prepareReportQuerySelectAllRows() {
        SQLSelectStatement sQLSelectStatement = this.buildReportQuerySelectStatement(false);
        this.setSQLStatement(sQLSelectStatement);
        this.setCallFromStatement();
        this.setSQLStatement(null);
        this.getCall().returnManyRows();
        this.prepareCall();
    }

    public void prepareReportQuerySubSelect() {
        this.setSQLStatement(this.buildReportQuerySelectStatement(true));
        this.setSelectionCriteria(null);
    }

    public void prepareSelectAllRows() {
        if (!this.getDescriptor().hasInheritance() || !this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            this.setSQLStatement(this.buildNormalSelectStatement());
            super.prepareSelectAllRows();
        } else {
            InheritancePolicy inheritancePolicy = this.getDescriptor().getInheritancePolicy();
            if (inheritancePolicy.hasView()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectAllRows();
            } else if (((ObjectLevelReadQuery)this.getQuery()).shouldOuterJoinSubclasses()) {
                this.setSQLStatement(this.buildNormalSelectStatement());
                super.prepareSelectAllRows();
            } else if (!this.getDescriptor().getInheritancePolicy().hasClassExtractor()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildClassIndicatorSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectAllRows();
            }
        }
    }

    public void prepareSelectOneRow() {
        if (!this.getDescriptor().hasInheritance() || !this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            this.setSQLStatement(this.buildNormalSelectStatement());
            super.prepareSelectOneRow();
        } else {
            InheritancePolicy inheritancePolicy = this.getDescriptor().getInheritancePolicy();
            if (inheritancePolicy.hasView()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectOneRow();
            } else if (((ObjectLevelReadQuery)this.getQuery()).shouldOuterJoinSubclasses()) {
                this.setSQLStatement(this.buildNormalSelectStatement());
                super.prepareSelectOneRow();
            } else if (!this.getDescriptor().getInheritancePolicy().hasClassExtractor()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildClassIndicatorSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectOneRow();
            }
        }
    }

    public void prepareUpdateObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        Vector vector = this.getDescriptor().getQueryManager().getCachedUpdateCalls(this.getModifyRow().getFields());
        if (vector != null) {
            int n = vector.size();
            if (n == 1) {
                DatasourceCall datasourceCall = (DatasourceCall)vector.get(0);
                DatasourceCall datasourceCall2 = (DatasourceCall)datasourceCall.clone();
                this.setCall(datasourceCall2);
            } else {
                Vector<Object> vector2 = new Vector<Object>(n);
                for (int i = 0; i < n; ++i) {
                    DatasourceCall datasourceCall = (DatasourceCall)vector.get(i);
                    vector2.add(datasourceCall.clone());
                }
                this.setCalls(vector2);
            }
            return;
        }
        int n = this.getDescriptor().getTables().size();
        for (int i = 0; i < n; ++i) {
            DatabaseTable databaseTable = this.getDescriptor().getTables().get(i);
            SQLUpdateStatement sQLUpdateStatement = this.buildUpdateStatement(databaseTable);
            if (n > 1) {
                this.getSQLStatements().addElement(sQLUpdateStatement);
                continue;
            }
            this.setSQLStatement(sQLUpdateStatement);
        }
        super.prepareUpdateObject();
        if (this.hasMultipleCalls()) {
            vector = this.getCalls();
        } else {
            vector = NonSynchronizedVector.newInstance(1);
            if (this.getCall() != null) {
                vector.add(this.getCall());
            }
        }
        this.getDescriptor().getQueryManager().putCachedUpdateCalls(this.getModifyRow().getFields(), vector);
    }

    /*
     * WARNING - void declaration
     */
    public void prepareUpdateAll() {
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object3;
        Cloneable cloneable2;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Cloneable cloneable3;
        Object object13;
        ExpressionBuilder expressionBuilder = ((UpdateAllQuery)this.getQuery()).getExpressionBuilder();
        HashMap hashMap = ((UpdateAllQuery)this.getQuery()).getUpdateClauses();
        OptimisticLockingPolicy optimisticLockingPolicy = this.getDescriptor().getOptimisticLockingPolicy();
        if (optimisticLockingPolicy != null && optimisticLockingPolicy.getWriteLockField() != null) {
            object13 = expressionBuilder.getField(optimisticLockingPolicy.getWriteLockField());
            cloneable3 = optimisticLockingPolicy.getWriteLockUpdateExpression(expressionBuilder, this.getQuery().getSession());
            if (cloneable3 != null) {
                hashMap = (HashMap)hashMap.clone();
                hashMap.put(object13, cloneable3);
            }
        }
        object13 = new HashMap();
        cloneable3 = new HashMap();
        for (Map.Entry object122 : hashMap.entrySet()) {
            int n;
            int n2;
            object8 = object122.getKey();
            DataExpression dataExpression = null;
            object7 = null;
            object6 = null;
            if (object8 instanceof String) {
                object6 = (String)object8;
            } else {
                dataExpression = (DataExpression)object8;
            }
            Object var12_16 = null;
            object5 = null;
            if (object6 != null) {
                void var12_18;
                object5 = this.getDescriptor().getObjectBuilder().getMappingForAttributeName((String)object6);
                if (object5 != null && !((DatabaseMapping)object5).getFields().isEmpty()) {
                    DatabaseField databaseField = ((DatabaseMapping)object5).getFields().get(0);
                }
                if (var12_18 == null) {
                    throw QueryException.updateAllQueryAddUpdateDoesNotDefineField(this.getDescriptor(), this.getQuery(), (String)object6);
                }
                object7 = ((UpdateAllQuery)this.getQuery()).getExpressionBuilder().get((String)object6);
            } else if (dataExpression != null) {
                void var12_22;
                void var12_20;
                if (dataExpression.getBaseExpression() instanceof ExpressionBuilder) {
                    DatabaseField databaseField = this.getDescriptor().getObjectBuilder().getFieldForQueryKeyName(dataExpression.getName());
                }
                if (var12_20 == null) {
                    object4 = (DataExpression)dataExpression.clone();
                    ((BaseExpression)object4).getBuilder().setQueryClass(this.getQuery().getReferenceClass());
                    ((BaseExpression)object4).getBuilder().setSession(this.getSession().getRootSession(null));
                    DatabaseField databaseField = ((DataExpression)object4).getField();
                    if (databaseField == null) {
                        throw QueryException.updateAllQueryAddUpdateDoesNotDefineField(this.getDescriptor(), this.getQuery(), dataExpression.toString());
                    }
                }
                object5 = this.getDescriptor().getObjectBuilder().getMappingForField((DatabaseField)var12_22);
                object7 = dataExpression;
            }
            object4 = object122.getValue();
            if (object5 != null && ((DatabaseMapping)object5).isOneToOneMapping()) {
                cloneable2 = ((DatabaseMapping)object5).getFields();
                n2 = ((Vector)cloneable2).size();
                object3 = NonSynchronizedVector.newInstance(n2);
                NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(n2);
                for (n = 0; n < n2; ++n) {
                    if (object4 instanceof ConstantExpression) {
                        object4 = ((ConstantExpression)object4).getValue();
                    }
                    if (object4 == null) {
                        ((Vector)object3).add(null);
                    } else {
                        DatabaseField databaseField = ((OneToOneMapping)object5).getSourceToTargetKeyFields().get(((Vector)cloneable2).get(n));
                        if (object4 instanceof Expression) {
                            ((Vector)object3).add(((Expression)((Expression)object4).clone()).getField(databaseField));
                        } else {
                            ((Vector)object3).add(((OneToOneMapping)object5).getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object4, databaseField, this.getSession()));
                        }
                    }
                    ((Vector)nonSynchronizedVector).add(new FieldExpression((DatabaseField)((Vector)cloneable2).elementAt(n), ((QueryKeyExpression)object7).getBaseExpression()));
                }
            } else {
                void var12_23;
                cloneable2 = NonSynchronizedVector.newInstance(1);
                ((Vector)cloneable2).add(var12_23);
                object3 = NonSynchronizedVector.newInstance(1);
                ((Vector)object3).add(object4);
                NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
                ((Vector)nonSynchronizedVector).add(object7);
            }
            n2 = ((Vector)cloneable2).size();
            for (n = 0; n < n2; ++n) {
                DatabaseField databaseField = (DatabaseField)((Vector)cloneable2).elementAt(n);
                DatabaseTable databaseTable = databaseField.getTable();
                if (!this.getDescriptor().getTables().contains(databaseTable)) {
                    if (object6 != null) {
                        throw QueryException.updateAllQueryAddUpdateDefinesWrongField(this.getDescriptor(), this.getQuery(), (String)object6, databaseField.getQualifiedName());
                    }
                    throw QueryException.updateAllQueryAddUpdateDefinesWrongField(this.getDescriptor(), this.getQuery(), dataExpression.toString(), databaseField.getQualifiedName());
                }
                object2 = (HashMap)((HashMap)object13).get(databaseTable);
                if (object2 == null) {
                    object2 = new HashMap();
                    ((HashMap)object13).put(databaseTable, object2);
                    ((HashMap)cloneable3).put(databaseTable, this.getPrimaryKeyFieldsForTable(databaseTable));
                }
                object = ((Vector)object3).elementAt(n);
                cloneable = object4 instanceof Expression ? (Expression)object : expressionBuilder.value(object);
                if (((Expression)cloneable).isValueExpression()) {
                    void var17_32;
                    ((Expression)cloneable).setLocalBase((Expression)var17_32.elementAt(n));
                }
                ((HashMap)object2).put(databaseField, cloneable);
            }
        }
        Object var7_8 = null;
        object8 = this.createSQLSelectStatementForModifyAll(this.getSelectionCriteria());
        boolean bl = ((SQLSelectStatement)object8).requiresAliases();
        if (bl && this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll()) {
            this.prepareUpdateAllUsingTempStorage((HashMap)object13, (HashMap)cloneable3);
            return;
        }
        SQLCall sQLCall = (SQLCall)((SQLSelectStatement)object8).buildCall(this.getSession());
        object7 = new ExpressionIterator(){

            public void iterate(Expression expression) {
                if (this.getResult() == null) {
                    return;
                }
                if (expression instanceof DataExpression) {
                    DatabaseField databaseField;
                    DataExpression dataExpression = (DataExpression)expression;
                    Expression expression2 = dataExpression.getBaseExpression();
                    if (expression2 != null && !(expression2 instanceof ExpressionBuilder)) {
                        DataExpression dataExpression2;
                        boolean bl = true;
                        if (expression2 instanceof DataExpression && (dataExpression2 = (DataExpression)expression2).getMapping() != null && dataExpression2.getMapping().isAggregateObjectMapping()) {
                            bl = false;
                        }
                        if (bl) {
                            this.setResult(null);
                            return;
                        }
                    }
                    if ((databaseField = dataExpression.getField()) != null && !databaseField.getTable().equals((DatabaseTable)this.getResult())) {
                        this.setResult(null);
                        return;
                    }
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        object6 = new HashMap();
        for (Map.Entry entry : ((HashMap)object13).entrySet()) {
            object5 = (DatabaseTable)entry.getKey();
            object4 = (HashMap)entry.getValue();
            cloneable2 = new HashMap();
            ((HashMap)object6).put(object5, cloneable2);
            for (Map.Entry entry2 : ((HashMap)object4).entrySet()) {
                DatabaseField databaseField = (DatabaseField)entry2.getKey();
                Expression expression = (Expression)entry2.getValue();
                ((ExpressionIterator)object7).setResult(object5);
                Expression expression2 = (Expression)expression.clone();
                expression2.getBuilder().setSession(this.getSession());
                expression2.getBuilder().setQueryClass(this.getQuery().getReferenceClass());
                ((ExpressionIterator)object7).iterateOn(expression2);
                if (((ExpressionIterator)object7).getResult() == null) {
                    if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll()) {
                        this.prepareUpdateAllUsingTempStorage((HashMap)object13, (HashMap)cloneable3);
                        return;
                    }
                    object2 = this.createSQLSelectStatementForAssignedExpressionForUpdateAll(expression);
                    ((HashMap)cloneable2).put(databaseField, object2);
                    continue;
                }
                ((HashMap)cloneable2).put(databaseField, expression2);
            }
        }
        Cloneable cloneable4 = object13;
        object13 = object6;
        if (((HashMap)object13).size() == 1) {
            object5 = ((HashMap)object13).entrySet().iterator().next();
            object4 = (DatabaseTable)object5.getKey();
            cloneable2 = (HashMap)object5.getValue();
            object3 = (Collection)((HashMap)cloneable3).values().iterator().next();
            this.setSQLStatement(this.buildUpdateAllStatement((DatabaseTable)object4, (HashMap)cloneable2, sQLCall, (SQLSelectStatement)object8, (Collection)object3));
        } else {
            Cloneable cloneable5;
            object5 = new ExpressionIterator(){

                public void iterate(Expression expression) {
                    DataExpression dataExpression;
                    DatabaseField databaseField;
                    if (expression instanceof DataExpression && (databaseField = (dataExpression = (DataExpression)expression).getField()) != null) {
                        ((Collection)this.getResult()).add(databaseField);
                    }
                }

                public boolean shouldIterateOverSubSelects() {
                    return true;
                }
            };
            object4 = new HashSet();
            if (sQLCall != null) {
                ((ExpressionIterator)object5).setResult(object4);
                ((ExpressionIterator)object5).iterateOn(((SQLStatement)object8).getWhereClause());
            }
            cloneable2 = new HashMap();
            object3 = new HashMap();
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
            NonSynchronizedVector nonSynchronizedVector2 = NonSynchronizedVector.newInstance();
            HashMap<DatabaseField, Object> hashMap2 = new HashMap<DatabaseField, Object>();
            for (Map.Entry entry : ((HashMap)object13).entrySet()) {
                Cloneable cloneable6;
                Object object9;
                object2 = (DatabaseTable)entry.getKey();
                object = (HashMap)entry.getValue();
                cloneable = new HashSet(((HashMap)object).size());
                cloneable5 = (HashSet)((HashSet)object4).clone();
                ((ExpressionIterator)object5).setResult(cloneable5);
                for (Map.Entry entry3 : ((HashMap)object).entrySet()) {
                    Cloneable cloneable7 = (DatabaseField)entry3.getKey();
                    ((HashSet)cloneable).add(cloneable7);
                    object9 = entry3.getValue();
                    if (object9 instanceof Expression) {
                        cloneable6 = (Expression)object9;
                        ((ExpressionIterator)object5).iterateOn((Expression)cloneable6);
                        continue;
                    }
                    cloneable6 = (SQLSelectStatement)object9;
                    ((ExpressionIterator)object5).iterateOn((Expression)((SQLSelectStatement)cloneable6).getFields().elementAt(0));
                    ((ExpressionIterator)object5).iterateOn(((SQLStatement)cloneable6).getWhereClause());
                }
                for (Cloneable cloneable7 : ((HashMap)cloneable2).keySet()) {
                    object9 = (HashSet)((HashMap)cloneable2).get(cloneable7);
                    cloneable6 = (HashSet)((HashMap)object3).get(cloneable7);
                    boolean bl2 = false;
                    Iterator iterator = ((HashSet)object9).iterator();
                    while (iterator.hasNext()) {
                        if (!((HashSet)cloneable5).contains(iterator.next())) continue;
                        bl2 = true;
                        break;
                    }
                    boolean bl3 = false;
                    Iterator iterator2 = ((HashSet)cloneable).iterator();
                    while (iterator2.hasNext()) {
                        if (!((HashSet)cloneable6).contains(iterator2.next())) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl2 && !bl3) {
                        ((Vector)nonSynchronizedVector).add(object2);
                        ((Vector)nonSynchronizedVector2).add(cloneable7);
                        continue;
                    }
                    if (!bl2 && bl3) {
                        ((Vector)nonSynchronizedVector).add(cloneable7);
                        ((Vector)nonSynchronizedVector2).add(object2);
                        continue;
                    }
                    if (!bl2 || !bl3) continue;
                    hashMap2.put((DatabaseField)cloneable7, object2);
                }
                ((HashMap)cloneable2).put(object2, cloneable);
                ((HashMap)object3).put(object2, cloneable5);
            }
            if (!hashMap2.isEmpty()) {
                this.prepareUpdateAllUsingTempStorage((HashMap)cloneable4, (HashMap)cloneable3);
                return;
            }
            NonSynchronizedVector nonSynchronizedVector3 = NonSynchronizedVector.newInstance(((HashMap)object13).size());
            while (!((Vector)nonSynchronizedVector).isEmpty()) {
                int n;
                object2 = null;
                for (n = 0; n < ((Vector)nonSynchronizedVector).size(); ++n) {
                    cloneable = (DatabaseTable)((Vector)nonSynchronizedVector).elementAt(n);
                    if (nonSynchronizedVector2.contains(cloneable)) continue;
                    object2 = cloneable;
                    break;
                }
                if (object2 == null) {
                    this.prepareUpdateAllUsingTempStorage((HashMap)cloneable4, (HashMap)cloneable3);
                    return;
                }
                for (n = ((Vector)nonSynchronizedVector).size() - 1; n >= 0; --n) {
                    if (!((Vector)nonSynchronizedVector).elementAt(n).equals(object2)) continue;
                    ((Vector)nonSynchronizedVector).remove(n);
                    ((Vector)nonSynchronizedVector2).remove(n);
                }
                ((Vector)nonSynchronizedVector3).addElement(object2);
            }
            for (DatabaseTable databaseTable : ((HashMap)object13).keySet()) {
                if (nonSynchronizedVector3.contains(databaseTable)) continue;
                ((Vector)nonSynchronizedVector3).add(databaseTable);
            }
            for (int i = 0; i < ((Vector)nonSynchronizedVector3).size(); ++i) {
                cloneable = (DatabaseTable)((Vector)nonSynchronizedVector3).elementAt(i);
                cloneable5 = (HashMap)((HashMap)object13).get(cloneable);
                Collection collection = (Collection)((HashMap)cloneable3).get(cloneable);
                this.getSQLStatements().addElement(this.buildUpdateAllStatement((DatabaseTable)cloneable, (HashMap)cloneable5, sQLCall, (SQLSelectStatement)object8, collection));
            }
        }
        ((UpdateAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(false);
        super.prepareUpdateAll();
    }

    protected SQLSelectStatement createSQLSelectStatementForUpdateAllForOracleAnonymousBlock(HashMap hashMap) {
        ExpressionBuilder expressionBuilder = ((UpdateAllQuery)this.getQuery()).getExpressionBuilder();
        Expression expression = this.getSelectionCriteria();
        ReportQuery reportQuery = new ReportQuery(this.getDescriptor().getJavaClass(), expressionBuilder);
        reportQuery.setDescriptor(this.getDescriptor());
        reportQuery.setSelectionCriteria(expression);
        reportQuery.setSession(this.getSession());
        reportQuery.setShouldRetrievePrimaryKeys(true);
        for (HashMap hashMap2 : hashMap.values()) {
            Iterator iterator = hashMap2.values().iterator();
            while (iterator.hasNext()) {
                reportQuery.addAttribute("", (Expression)iterator.next());
            }
        }
        return ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAllForTempTable(HashMap hashMap) {
        ExpressionBuilder expressionBuilder = ((ModifyAllQuery)this.getQuery()).getExpressionBuilder();
        Expression expression = this.getSelectionCriteria();
        ReportQuery reportQuery = new ReportQuery(this.getDescriptor().getJavaClass(), expressionBuilder);
        reportQuery.setDescriptor(this.getDescriptor());
        reportQuery.setSelectionCriteria(expression);
        reportQuery.setSession(this.getSession());
        reportQuery.setShouldRetrievePrimaryKeys(true);
        if (hashMap != null) {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                reportQuery.addAttribute("", (Expression)iterator.next());
            }
        }
        return ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false);
    }

    protected SQLModifyStatement buildUpdateAllStatementForOracleAnonymousBlock(HashMap hashMap, HashMap hashMap2) {
        SQLSelectStatement sQLSelectStatement = this.createSQLSelectStatementForUpdateAllForOracleAnonymousBlock(hashMap);
        SQLCall sQLCall = (SQLCall)sQLSelectStatement.buildCall(this.getSession());
        SQLUpdateAllStatementForOracleAnonymousBlock sQLUpdateAllStatementForOracleAnonymousBlock = new SQLUpdateAllStatementForOracleAnonymousBlock();
        sQLUpdateAllStatementForOracleAnonymousBlock.setTranslationRow(this.getTranslationRow());
        sQLUpdateAllStatementForOracleAnonymousBlock.setSelectCall(sQLCall);
        sQLUpdateAllStatementForOracleAnonymousBlock.setTables_databaseFieldsToValues(hashMap);
        sQLUpdateAllStatementForOracleAnonymousBlock.setTablesToPrimaryKeyFields(hashMap2);
        sQLUpdateAllStatementForOracleAnonymousBlock.setTable(this.getDescriptor().getTables().firstElement());
        return sQLUpdateAllStatementForOracleAnonymousBlock;
    }

    protected void prepareUpdateAllUsingTempStorage(HashMap hashMap, HashMap hashMap2) {
        if (this.getSession().getPlatform().supportsTempTables()) {
            this.prepareUpdateAllUsingTempTables(hashMap, hashMap2);
        } else if (this.getSession().getPlatform().isOracle()) {
            this.prepareUpdateAllUsingOracleAnonymousBlock(hashMap, hashMap2);
        } else {
            throw QueryException.tempTablesNotSupported(this.getQuery(), Helper.getShortClassName(this.getSession().getPlatform()));
        }
    }

    protected void prepareUpdateAllUsingOracleAnonymousBlock(HashMap hashMap, HashMap hashMap2) {
        this.setSQLStatement(this.buildUpdateAllStatementForOracleAnonymousBlock(hashMap, hashMap2));
        ((UpdateAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(true);
        super.prepareUpdateAll();
    }

    protected void prepareUpdateAllUsingTempTables(HashMap hashMap, HashMap hashMap2) {
        int n = hashMap.size();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(n);
        NonSynchronizedVector nonSynchronizedVector2 = NonSynchronizedVector.newInstance(n);
        NonSynchronizedVector nonSynchronizedVector3 = NonSynchronizedVector.newInstance(n);
        NonSynchronizedVector nonSynchronizedVector4 = NonSynchronizedVector.newInstance(n);
        for (Map.Entry entry : hashMap.entrySet()) {
            DatabaseTable databaseTable = (DatabaseTable)entry.getKey();
            HashMap hashMap3 = (HashMap)entry.getValue();
            Collection collection = (Collection)hashMap2.get(databaseTable);
            Vector vector = this.buildStatementsForUpdateAllForTempTables(databaseTable, hashMap3, collection);
            ((Vector)nonSynchronizedVector).add(vector.elementAt(0));
            ((Vector)nonSynchronizedVector2).add(vector.elementAt(1));
            ((Vector)nonSynchronizedVector3).add(vector.elementAt(2));
            ((Vector)nonSynchronizedVector4).add(vector.elementAt(3));
        }
        this.getSQLStatements().addAll(nonSynchronizedVector);
        this.getSQLStatements().addAll(nonSynchronizedVector2);
        this.getSQLStatements().addAll(nonSynchronizedVector3);
        this.getSQLStatements().addAll(nonSynchronizedVector4);
        if (this.getSession().getPlatform().dontBindUpdateAllQueryUsingTempTables() && (this.getQuery().shouldBindAllParameters() || this.getQuery().shouldIgnoreBindAllParameters() && this.getSession().getPlatform().shouldBindAllParameters())) {
            this.getQuery().setShouldBindAllParameters(false);
            this.getSession().warning("update_all_query_cannot_use_binding_on_this_platform", "query");
        }
        ((UpdateAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(true);
        super.prepareUpdateAll();
    }

    protected Vector buildStatementsForDeleteAllForTempTables() {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        DatabaseTable databaseTable = this.getDescriptor().getMultipleTableInsertOrder().firstElement();
        Collection collection = this.getPrimaryKeyFieldsForTable(databaseTable);
        ClassDescriptor classDescriptor = this.getDescriptor();
        if (this.getDescriptor().hasInheritance()) {
            classDescriptor = classDescriptor.getInheritancePolicy().getRootParentDescriptor();
        }
        NonSynchronizedVector nonSynchronizedVector2 = NonSynchronizedVector.newInstance();
        for (DatabaseField cloneable2 : classDescriptor.getFields()) {
            if (!databaseTable.equals(cloneable2.getTable())) continue;
            ((Vector)nonSynchronizedVector2).add(cloneable2);
        }
        SQLDeleteAllStatementForTempTable sQLDeleteAllStatementForTempTable = new SQLDeleteAllStatementForTempTable();
        sQLDeleteAllStatementForTempTable.setMode(3);
        sQLDeleteAllStatementForTempTable.setTable(databaseTable);
        ((Vector)nonSynchronizedVector).addElement(sQLDeleteAllStatementForTempTable);
        Vector vector = this.buildDeleteAllStatementsForTempTable(this.getDescriptor(), databaseTable, collection, null);
        ((Vector)nonSynchronizedVector).addAll(vector);
        SQLSelectStatement sQLSelectStatement = this.createSQLSelectStatementForModifyAllForTempTable(null);
        SQLCall sQLCall = (SQLCall)sQLSelectStatement.buildCall(this.getSession());
        SQLDeleteAllStatementForTempTable sQLDeleteAllStatementForTempTable2 = new SQLDeleteAllStatementForTempTable();
        sQLDeleteAllStatementForTempTable2.setMode(1);
        sQLDeleteAllStatementForTempTable2.setTable(databaseTable);
        sQLDeleteAllStatementForTempTable2.setTranslationRow(this.getTranslationRow());
        sQLDeleteAllStatementForTempTable2.setSelectCall(sQLCall);
        sQLDeleteAllStatementForTempTable2.setPrimaryKeyFields(collection);
        ((Vector)nonSynchronizedVector).addElement(sQLDeleteAllStatementForTempTable2);
        SQLDeleteAllStatementForTempTable sQLDeleteAllStatementForTempTable3 = new SQLDeleteAllStatementForTempTable();
        sQLDeleteAllStatementForTempTable3.setMode(0);
        sQLDeleteAllStatementForTempTable3.setTable(databaseTable);
        sQLDeleteAllStatementForTempTable3.setAllFields(nonSynchronizedVector2);
        sQLDeleteAllStatementForTempTable3.setPrimaryKeyFields(collection);
        ((Vector)nonSynchronizedVector).addElement(sQLDeleteAllStatementForTempTable3);
        return nonSynchronizedVector;
    }

    private Vector buildDeleteAllStatementsForTempTable(ClassDescriptor classDescriptor, DatabaseTable databaseTable, Collection collection, Vector vector) {
        boolean bl;
        Cloneable cloneable;
        Vector<DatabaseTable> vector2;
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        if (vector == null) {
            vector2 = classDescriptor.getMultipleTableInsertOrder();
        } else {
            vector2 = new Vector(classDescriptor.getMultipleTableInsertOrder().size());
            for (Cloneable cloneable22 : classDescriptor.getMultipleTableInsertOrder()) {
                if (vector.contains(cloneable22)) continue;
                vector2.addElement((DatabaseTable)cloneable22);
            }
        }
        if (!vector2.isEmpty()) {
            Cloneable cloneable22;
            for (Cloneable cloneable22 : vector2) {
                cloneable = this.buildDeleteAllStatementForTempTable(databaseTable, collection, (DatabaseTable)cloneable22, this.getPrimaryKeyFieldsForTable(classDescriptor, (DatabaseTable)cloneable22));
                ((Vector)nonSynchronizedVector).addElement(cloneable);
            }
            cloneable22 = this.buildDeleteAllStatementsForMappingsWithTempTable(classDescriptor, databaseTable, collection, vector == null);
            ((Vector)nonSynchronizedVector).addAll(cloneable22);
        }
        boolean bl2 = classDescriptor.hasInheritance() && classDescriptor.getInheritancePolicy().hasChildren() && classDescriptor.getInheritancePolicy().hasMultipleTableChild();
        boolean bl3 = bl = bl2 && classDescriptor.getInheritancePolicy().shouldReadSubclasses();
        if (bl) {
            cloneable = new Vector();
            if (vector != null) {
                ((Vector)cloneable).addAll(vector);
            }
            if (classDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
                ((Vector)cloneable).addAll(vector2);
            }
            for (ClassDescriptor classDescriptor2 : classDescriptor.getInheritancePolicy().getChildDescriptors()) {
                if (classDescriptor2.getTables().size() <= classDescriptor.getTables().size() && !classDescriptor2.getInheritancePolicy().hasMultipleTableChild()) continue;
                Vector vector3 = this.buildDeleteAllStatementsForTempTable(classDescriptor2, databaseTable, collection, (Vector)cloneable);
                ((Vector)nonSynchronizedVector).addAll(vector3);
            }
        }
        return nonSynchronizedVector;
    }

    private SQLDeleteAllStatementForTempTable buildDeleteAllStatementForTempTable(DatabaseTable databaseTable, Collection collection, DatabaseTable databaseTable2, Collection collection2) {
        SQLDeleteAllStatementForTempTable sQLDeleteAllStatementForTempTable = new SQLDeleteAllStatementForTempTable();
        sQLDeleteAllStatementForTempTable.setMode(2);
        sQLDeleteAllStatementForTempTable.setTable(databaseTable);
        sQLDeleteAllStatementForTempTable.setPrimaryKeyFields(collection);
        sQLDeleteAllStatementForTempTable.setTargetTable(databaseTable2);
        sQLDeleteAllStatementForTempTable.setTargetPrimaryKeyFields(collection2);
        return sQLDeleteAllStatementForTempTable;
    }

    protected Vector buildStatementsForUpdateAllForTempTables(DatabaseTable databaseTable, HashMap hashMap, Collection collection) {
        Cloneable cloneable;
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(4);
        NonSynchronizedVector nonSynchronizedVector2 = NonSynchronizedVector.newInstance();
        for (DatabaseField object22 : this.getDescriptor().getFields()) {
            if (!databaseTable.equals(object22.getTable())) continue;
            ((Vector)nonSynchronizedVector2).add(object22);
        }
        Set set = hashMap.keySet();
        HashMap hashMap2 = hashMap;
        Set set2 = set;
        if (!this.getSession().getPlatform().isNullAllowedInSelectClause()) {
            hashMap2 = new HashMap(hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                if (entry.getValue() instanceof ConstantExpression && (cloneable = (ConstantExpression)entry.getValue()).getValue() == null) continue;
                hashMap2.put(entry.getKey(), entry.getValue());
            }
            set2 = hashMap2.keySet();
        }
        SQLUpdateAllStatementForTempTable sQLUpdateAllStatementForTempTable = new SQLUpdateAllStatementForTempTable();
        sQLUpdateAllStatementForTempTable.setMode(0);
        sQLUpdateAllStatementForTempTable.setTable(databaseTable);
        sQLUpdateAllStatementForTempTable.setAllFields(nonSynchronizedVector2);
        sQLUpdateAllStatementForTempTable.setAssignedFields(set);
        sQLUpdateAllStatementForTempTable.setPrimaryKeyFields(collection);
        ((Vector)nonSynchronizedVector).addElement(sQLUpdateAllStatementForTempTable);
        SQLSelectStatement sQLSelectStatement = this.createSQLSelectStatementForModifyAllForTempTable(hashMap2);
        cloneable = (SQLCall)sQLSelectStatement.buildCall(this.getSession());
        SQLUpdateAllStatementForTempTable sQLUpdateAllStatementForTempTable2 = new SQLUpdateAllStatementForTempTable();
        sQLUpdateAllStatementForTempTable2.setMode(1);
        sQLUpdateAllStatementForTempTable2.setTable(databaseTable);
        sQLUpdateAllStatementForTempTable2.setTranslationRow(this.getTranslationRow());
        sQLUpdateAllStatementForTempTable2.setSelectCall((SQLCall)cloneable);
        sQLUpdateAllStatementForTempTable2.setAssignedFields(set2);
        sQLUpdateAllStatementForTempTable2.setPrimaryKeyFields(collection);
        ((Vector)nonSynchronizedVector).addElement(sQLUpdateAllStatementForTempTable2);
        SQLUpdateAllStatementForTempTable sQLUpdateAllStatementForTempTable3 = new SQLUpdateAllStatementForTempTable();
        sQLUpdateAllStatementForTempTable3.setMode(2);
        sQLUpdateAllStatementForTempTable3.setTable(databaseTable);
        sQLUpdateAllStatementForTempTable3.setTranslationRow(this.getTranslationRow());
        sQLUpdateAllStatementForTempTable3.setAssignedFields(set);
        sQLUpdateAllStatementForTempTable3.setPrimaryKeyFields(collection);
        ((Vector)nonSynchronizedVector).addElement(sQLUpdateAllStatementForTempTable3);
        SQLUpdateAllStatementForTempTable sQLUpdateAllStatementForTempTable4 = new SQLUpdateAllStatementForTempTable();
        sQLUpdateAllStatementForTempTable4.setMode(3);
        sQLUpdateAllStatementForTempTable4.setTable(databaseTable);
        ((Vector)nonSynchronizedVector).addElement(sQLUpdateAllStatementForTempTable4);
        return nonSynchronizedVector;
    }

    protected Collection getPrimaryKeyFieldsForTable(DatabaseTable databaseTable) {
        return this.getPrimaryKeyFieldsForTable(this.getDescriptor(), databaseTable);
    }

    protected Collection getPrimaryKeyFieldsForTable(ClassDescriptor classDescriptor, DatabaseTable databaseTable) {
        Collection<DatabaseField> collection = databaseTable.equals(classDescriptor.getTables().firstElement()) ? classDescriptor.getPrimaryKeyFields() : classDescriptor.getAdditionalTablePrimaryKeyFields().get(databaseTable).values();
        return collection;
    }

    public Vector selectAllReportQueryRows() throws DatabaseException {
        return this.selectAllRowsFromTable();
    }

    public Vector selectAllRows() throws DatabaseException {
        if (!((ObjectLevelReadQuery)this.getQuery()).shouldOuterJoinSubclasses() && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && !this.getDescriptor().getInheritancePolicy().hasView()) {
            return this.getDescriptor().getInheritancePolicy().selectAllRowUsingMultipleTableSubclassRead((ReadAllQuery)this.getQuery());
        }
        return this.selectAllRowsFromTable();
    }

    public Vector selectAllRowsFromConcreteTable() throws DatabaseException {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        boolean bl = objectLevelReadQuery.shouldPrepare();
        DatabaseCall databaseCall = null;
        if (bl) {
            databaseCall = objectLevelReadQuery.getConcreteSubclassCalls().get(objectLevelReadQuery.getReferenceClass());
        }
        if (databaseCall == null) {
            AbstractRecord abstractRecord = objectLevelReadQuery.getTranslationRow();
            if (bl) {
                objectLevelReadQuery.setTranslationRow(null);
            }
            this.setSQLStatement(this.buildConcreteSelectStatement());
            super.prepareSelectAllRows();
            if (bl) {
                objectLevelReadQuery.getConcreteSubclassCalls().put(objectLevelReadQuery.getReferenceClass(), (DatabaseCall)this.getCall());
                objectLevelReadQuery.setTranslationRow(abstractRecord);
            }
        } else {
            this.setCall(databaseCall);
        }
        return super.selectAllRows();
    }

    public Vector selectAllRowsFromTable() throws DatabaseException {
        return super.selectAllRows();
    }

    public AbstractRecord selectOneRow() throws DatabaseException {
        if (!this.getReadObjectQuery().shouldOuterJoinSubclasses() && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && !this.getDescriptor().getInheritancePolicy().hasView()) {
            return this.getDescriptor().getInheritancePolicy().selectOneRowUsingMultipleTableSubclassRead((ReadObjectQuery)this.getQuery());
        }
        return this.selectOneRowFromTable();
    }

    public AbstractRecord selectOneRowFromConcreteTable() throws DatabaseException {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        DatabaseCall databaseCall = objectLevelReadQuery.getConcreteSubclassCalls().get(objectLevelReadQuery.getReferenceClass());
        if (databaseCall == null) {
            this.setSQLStatement(this.buildConcreteSelectStatement());
            super.prepareSelectOneRow();
            objectLevelReadQuery.getConcreteSubclassCalls().put(objectLevelReadQuery.getReferenceClass(), (DatabaseCall)this.getCall());
        } else {
            this.setCall(databaseCall);
        }
        return super.selectOneRow();
    }

    public AbstractRecord selectOneRowFromTable() throws DatabaseException {
        return super.selectOneRow();
    }

    public void setSelectionCriteria(Expression expression) {
        this.selectionCriteria = expression;
    }

    protected ClassDescriptor getHighestDescriptorMappingTable(DatabaseTable databaseTable) {
        ClassDescriptor classDescriptor = this.getDescriptor();
        ClassDescriptor classDescriptor2 = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
        while (classDescriptor2 != null && classDescriptor2.getTables().contains(databaseTable)) {
            classDescriptor = classDescriptor2;
            classDescriptor2 = classDescriptor2.getInheritancePolicy().getParentDescriptor();
        }
        return classDescriptor;
    }
}

