/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import org.eclipse.persistence.internal.sequencing.ClientSessionSequencing;
import org.eclipse.persistence.internal.sequencing.RemoteConnectionSequencing;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sequencing.SequencingManager;
import org.eclipse.persistence.internal.sequencing.SessionBrokerSequencing;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.sessions.server.ClientSession;

public class SequencingFactory {
    public static Sequencing createSequencing(AbstractSession abstractSession) {
        SessionBroker sessionBroker;
        Sequencing sequencing = null;
        if (abstractSession.isClientSession()) {
            ClientSession clientSession = (ClientSession)abstractSession;
            if (ClientSessionSequencing.sequencingServerExists(clientSession)) {
                sequencing = new ClientSessionSequencing(clientSession);
            }
        } else if (abstractSession.isRemoteSession()) {
            RemoteConnection remoteConnection = ((RemoteSession)abstractSession).getRemoteConnection();
            if (RemoteConnectionSequencing.masterSequencingExists(remoteConnection)) {
                sequencing = new RemoteConnectionSequencing(remoteConnection);
            }
        } else if (abstractSession.isBroker() && SessionBrokerSequencing.atLeastOneSessionHasSequencing(sessionBroker = (SessionBroker)abstractSession)) {
            sequencing = new SessionBrokerSequencing(sessionBroker);
        }
        return sequencing;
    }

    public static SequencingHome createSequencingHome(DatabaseSessionImpl databaseSessionImpl) {
        SequencingManager sequencingManager = null;
        if (!databaseSessionImpl.isBroker()) {
            sequencingManager = new SequencingManager(databaseSessionImpl);
        }
        return sequencingManager;
    }
}

