/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.amx.intf.config.ConfigConfig;
import org.glassfish.admin.amx.intf.config.ThreadPoolConfig;
import org.glassfish.admin.amx.intf.config.ThreadPoolsConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListener;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListeners;
import org.glassfish.admin.amx.intf.config.grizzly.Protocol;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyHandlers {
    private static List httpServiceSkipPropsList = new ArrayList();

    public static void getNetworkListeners(HandlerContext handlerCtx) {
        ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
        Map nls = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners().getNetworkListener();
        ArrayList result = new ArrayList();
        for (NetworkListener nl : nls.values()) {
            try {
                Map attrs = nl.attributesMap();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("Name", GrizzlyHandlers.getA(attrs, "Name"));
                oneRow.put("Protocol", GrizzlyHandlers.getA(attrs, "Protocol"));
                oneRow.put("selected", false);
                oneRow.put("Port", GrizzlyHandlers.getA(attrs, "Port"));
                oneRow.put("ThreadPool", GrizzlyHandlers.getA(attrs, "ThreadPool"));
                String enabled = GrizzlyHandlers.getA(attrs, "Enabled");
                oneRow.put("enabled", enabled);
                String enableURL = enabled.equals("true") ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
                oneRow.put("enableURL", enableURL);
                result.add(oneRow);
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    private static String getA(Map<String, Object> attrs, String key) {
        String res = (String)attrs.get(key);
        if (res == null) {
            res = "";
        }
        return res;
    }

    public static void getprotocols(HandlerContext handlerCtx) {
        ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
        Map pMap = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getProtocols().getProtocol();
        ArrayList result = new ArrayList();
        for (Protocol protocol : pMap.values()) {
            try {
                Map attrs = protocol.attributesMap();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("Name", GrizzlyHandlers.getA(attrs, "Name"));
                oneRow.put("SecurityEnabled", GrizzlyHandlers.getA(attrs, "SecurityEnabled"));
                oneRow.put("selected", false);
                result.add(oneRow);
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getThreadPools(HandlerContext handlerCtx) {
        ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
        Map pMap = config.getThreadPools().getThreadPool();
        ArrayList result = new ArrayList();
        for (ThreadPoolConfig tpc : pMap.values()) {
            try {
                Map attrs = tpc.attributesMap();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("Name", GrizzlyHandlers.getA(attrs, "Name"));
                oneRow.put("MinThreadPoolSize", GrizzlyHandlers.getA(attrs, "MinThreadPoolSize"));
                oneRow.put("MaxThreadPoolSize", GrizzlyHandlers.getA(attrs, "MaxThreadPoolSize"));
                oneRow.put("MaxQueueSize", GrizzlyHandlers.getA(attrs, "MaxQueueSize"));
                oneRow.put("IdleThreadTimeout", GrizzlyHandlers.getA(attrs, "IdleThreadTimeout"));
                oneRow.put("selected", false);
                result.add(oneRow);
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void deleteGrizzlyElement(HandlerContext handlerCtx) {
        List obj;
        ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
        String type = (String)handlerCtx.getInputValue("type");
        ThreadPoolsConfig amxP = null;
        if (type.equals("thread-pool")) {
            amxP = config.getThreadPools();
        } else if (type.equals("network-listener")) {
            amxP = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners();
        } else if (type.equals("protocol")) {
            amxP = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getProtocols();
        }
        if (amxP == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)("GUI internal error, Not such Type: " + type));
            return;
        }
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String Name = (String)oneRow.get("Name");
                amxP.removeChild(type, Name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getNetworkListenerAttr(HandlerContext handlerCtx) {
        try {
            String fromDefault = (String)handlerCtx.getInputValue("fromDefault");
            Map attrs = null;
            ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
            NetworkListeners nls = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners();
            if (GuiUtil.isEmpty((String)fromDefault) || fromDefault.equals("false")) {
                String name = (String)handlerCtx.getInputValue("name");
                NetworkListener nl = (NetworkListener)nls.getNetworkListener().get(name);
                attrs = nl.attributesMap();
            } else {
                attrs = nls.getDefaultValues("network-listener", true);
            }
            handlerCtx.setOutputValue("valueMap", (Object)attrs);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getThreadPoolAttr(HandlerContext handlerCtx) {
        try {
            String fromDefault = (String)handlerCtx.getInputValue("fromDefault");
            Map attrs = null;
            ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
            ThreadPoolsConfig tps = config.getThreadPools();
            if (GuiUtil.isEmpty((String)fromDefault) || fromDefault.equals("false")) {
                String name = (String)handlerCtx.getInputValue("name");
                ThreadPoolConfig tp = (ThreadPoolConfig)tps.getThreadPool().get(name);
                attrs = tp.attributesMap();
            } else {
                attrs = tps.getDefaultValues("thread-pool", true);
            }
            handlerCtx.setOutputValue("valueMap", (Object)attrs);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveThreadPoolAttr(HandlerContext handlerCtx) {
        try {
            Map attrs = (Map)handlerCtx.getInputValue("attrs");
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            ConfigConfig config = V3AMX.getServerConfig((String)((String)handlerCtx.getInputValue("configName")));
            ThreadPoolsConfig tps = config.getThreadPools();
            if (edit.booleanValue()) {
                String name = (String)attrs.get("Name");
                ThreadPoolConfig tpc = (ThreadPoolConfig)tps.getThreadPool().get(name);
                tpc.setClassname(GrizzlyHandlers.getA(attrs, "Classname"));
                tpc.setIdleThreadTimeoutInSeconds(GrizzlyHandlers.getA(attrs, "IdleThreadTimeout"));
                tpc.setMaxQueueSize(GrizzlyHandlers.getA(attrs, "MaxQueueSize"));
                tpc.setMinThreadPoolSize(GrizzlyHandlers.getA(attrs, "MinThreadPoolSize"));
                tpc.setMaxThreadPoolSize(GrizzlyHandlers.getA(attrs, "MaxThreadPoolSize"));
            } else {
                tps.createChild("thread-pool", attrs);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    static {
        httpServiceSkipPropsList.add("accessLogBufferSize");
        httpServiceSkipPropsList.add("accessLogWriteInterval");
        httpServiceSkipPropsList.add("accessLoggingEnabled");
    }
}

