/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import org.apache.felix.framework.Felix;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class URLHandlersServiceTracker
implements ServiceListener {
    private final BundleContext m_context;
    private final String m_filter;
    private ServiceReference m_ref = null;
    private volatile Object m_svcObj = null;
    private long m_id = -1L;
    private int m_rank = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLHandlersServiceTracker(Felix framework, String filter) {
        this.m_context = framework.getBundleContext();
        this.m_filter = filter;
        URLHandlersServiceTracker uRLHandlersServiceTracker = this;
        synchronized (uRLHandlersServiceTracker) {
            try {
                this.m_context.addServiceListener(this, this.m_filter);
            }
            catch (InvalidSyntaxException ex) {
                System.out.println("Cannot add service listener." + ex);
            }
            this.selectBestService();
        }
    }

    public void unregister() {
        this.m_context.removeServiceListener(this);
    }

    public Object getService() {
        return this.m_svcObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        ServiceReference eventRef = event.getServiceReference();
        if (event.getType() == 1 || event.getType() == 2) {
            URLHandlersServiceTracker uRLHandlersServiceTracker = this;
            synchronized (uRLHandlersServiceTracker) {
                int rank;
                Long idObj = (Long)eventRef.getProperty("service.id");
                Integer rankObj = (Integer)eventRef.getProperty("service.ranking");
                int n = rank = rankObj == null ? 0 : rankObj;
                if (rank > this.m_rank || rank == this.m_rank && idObj < this.m_id) {
                    if (this.m_ref != null) {
                        this.m_context.ungetService(this.m_ref);
                    }
                    this.m_ref = eventRef;
                    this.m_rank = rank;
                    this.m_id = idObj;
                    this.m_svcObj = this.m_context.getService(this.m_ref);
                }
            }
        }
        if (event.getType() == 4) {
            URLHandlersServiceTracker uRLHandlersServiceTracker = this;
            synchronized (uRLHandlersServiceTracker) {
                if (eventRef == this.m_ref) {
                    this.selectBestService();
                }
            }
        }
    }

    private synchronized void selectBestService() {
        if (this.m_ref != null) {
            this.m_context.ungetService(this.m_ref);
            this.m_ref = null;
            this.m_svcObj = null;
            this.m_id = -1L;
            this.m_rank = -1;
        }
        try {
            ServiceReference[] refs = this.m_context.getServiceReferences(null, this.m_filter);
            for (int i = 0; refs != null && i < refs.length; ++i) {
                int rank;
                Long idObj = (Long)refs[i].getProperty("service.id");
                Integer rankObj = (Integer)refs[i].getProperty("service.ranking");
                int n = rank = rankObj == null ? 0 : rankObj;
                if (rank <= this.m_rank && (rank != this.m_rank || idObj >= this.m_id)) continue;
                this.m_ref = refs[i];
                this.m_rank = rank;
                this.m_id = idObj;
            }
            if (this.m_ref != null) {
                this.m_svcObj = this.m_context.getService(this.m_ref);
            }
        }
        catch (InvalidSyntaxException ex) {
            System.err.println("URLHandlersServiceTracker: " + ex);
        }
    }
}

