/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.lang.management.ManagementFactory;
import javax.faces.context.FacesContext;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.AMXBooter;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.intf.config.ConfigConfig;
import org.glassfish.admin.amx.intf.config.ConfigsConfig;
import org.glassfish.admin.amx.intf.config.DomainConfig;
import org.jvnet.hk2.component.Habitat;

public class V3AMX {
    private static V3AMX v3amx;
    private final DomainRoot domainRoot;
    private final DomainConfig domainConfig;
    private final ProxyFactory proxyFactory;

    private V3AMX(DomainRoot dd, MBeanServerConnection msc) {
        this.proxyFactory = ProxyFactory.getInstance((MBeanServerConnection)msc);
        this.domainRoot = dd;
        this.domainConfig = (DomainConfig)this.domainRoot.getDomain().as(DomainConfig.class);
    }

    public static synchronized V3AMX getInstance() {
        if (v3amx == null) {
            ServletContext servletCtx = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            Habitat habitat = (Habitat)servletCtx.getAttribute("org.glassfish.servlet.habitat");
            MBeanServer mbs = (MBeanServer)habitat.getComponent(MBeanServer.class);
            if (mbs == null) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            if (mbs == null) {
                System.out.println("!!!!!!!!!!!!!!  Cannot get to MBeanServer");
            }
            AMXBooter.bootAMX((MBeanServerConnection)mbs);
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServer)mbs).getDomainRootProxy();
            v3amx = new V3AMX(domainRoot, mbs);
        }
        return v3amx;
    }

    public DomainConfig getDomainConfig() {
        return this.domainConfig;
    }

    public DomainRoot getDomainRoot() {
        return this.domainRoot;
    }

    public ConfigsConfig getConfigsConfig() {
        return this.domainConfig.getConfigs();
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public AMXProxy getProxy(ObjectName objName) {
        return this.proxyFactory.getProxy(objName);
    }

    public static ConfigConfig getServerConfig(String configName) {
        if (configName == null || configName.equals("")) {
            configName = "server-config";
        }
        return (ConfigConfig)V3AMX.getInstance().getConfigsConfig().getConfig().get(configName);
    }
}

