/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.Pathnames;
import org.glassfish.admin.amx.core.AMXException;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Extra;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AMXValidator {
    private static final String NL = StringUtil.NEWLINE();
    private final MBeanServerConnection mMBeanServer;
    private final ProxyFactory mProxyFactory;
    private final DomainRoot mDomainRoot;
    private static final String LEGAL_CHARS_FOR_TYPE = "[\\$a-zA-Z0-9\\._-]";
    private static final Pattern LEGAL_PATTERN_FOR_TYPE = Pattern.compile("[\\$a-zA-Z0-9\\._-][\\$a-zA-Z0-9\\._-]*");
    private static final String LEGAL_CHARS_FOR_NAME = "[^\\[\\]]";
    private static final Pattern LEGAL_PATTERN_FOR_NAME = Pattern.compile("[^\\[\\]]*");

    private static void debug(Object o) {
        System.out.println(o.toString());
    }

    public AMXValidator(MBeanServerConnection conn) {
        this.mMBeanServer = conn;
        this.mProxyFactory = ProxyFactory.getInstance(conn);
        this.mDomainRoot = this.mProxyFactory.getDomainRootProxy();
    }

    private String toString(Throwable t) {
        return ExceptionUtil.toString(ExceptionUtil.getRootCause(t));
    }

    private List<String> _validate(AMXProxy proxy) {
        ArrayList<String> problems = new ArrayList<String>();
        ObjectName objectName = proxy.objectName();
        try {
            this.validateObjectName(proxy);
        }
        catch (Throwable t) {
            problems.add(t.toString());
        }
        List<String> temp = null;
        try {
            temp = AMXValidator.validateMetadata(proxy);
            if (temp != null) {
                problems.addAll(temp);
            }
        }
        catch (Throwable t) {
            problems.add(t.toString());
        }
        try {
            this.validateRequiredAttributes(proxy);
        }
        catch (Throwable t) {
            problems.add(t.toString());
        }
        Pathnames paths = this.mDomainRoot.getPathnames();
        try {
            String name = proxy.getName();
        }
        catch (Throwable t) {
            problems.add("Proxy access to 'Name' failed: " + this.toString(t));
        }
        try {
            ObjectName parent = proxy.getParent();
        }
        catch (Throwable t) {
            problems.add("Proxy access to 'Parent' failed: " + this.toString(t));
        }
        try {
            ObjectName[] children = proxy.getChildren();
        }
        catch (Throwable t) {
            problems.add("Proxy access to 'Children' failed: " + this.toString(t));
        }
        try {
            String path = proxy.path();
            ObjectName actualObjectName = Util.getObjectName(proxy);
            ObjectName o = paths.resolvePath(path);
            if (o == null) {
                problems.add("Path " + path + " does not resolve to any ObjectName, should resolve to: " + actualObjectName);
            } else if (!actualObjectName.equals(o)) {
                problems.add("Path " + path + " does not resolve to ObjectName: " + actualObjectName);
            }
        }
        catch (Throwable t) {
            problems.add(ExceptionUtil.toString(ExceptionUtil.getRootCause(t)));
        }
        Set<String> attributeNames = proxy.extra().attributeNames();
        for (String attrName : attributeNames) {
            try {
                Object result = proxy.extra().getAttribute(attrName);
            }
            catch (Throwable t) {
                problems.add("Attribute failed: '" + attrName + "': " + this.toString(t));
            }
        }
        Object tempProblems = null;
        try {
            this.validateChildren(proxy);
        }
        catch (Throwable t) {
            problems.add(t.toString());
        }
        try {
            AMXProxy parent = proxy.parent();
            if (parent == null && !proxy.type().equals("DomainRoot")) {
                throw new Exception("Null parent");
            }
            String nameProp = proxy.nameProp();
            boolean valid = proxy.valid();
            String path = proxy.path();
            Extra extra = proxy.extra();
            Set<AMXProxy> childrenSet = proxy.childrenSet();
            Map<String, Map<String, AMXProxy>> childrenMaps = proxy.childrenMaps();
            Map<String, Object> attributesMap = proxy.attributesMap();
            Set<String> attrNames = proxy.attributeNames();
            if (!((Object)attrNames).equals(attributesMap.keySet())) {
                throw new Exception("Attributes Map differs from attribute names");
            }
            for (AMXProxy child : childrenSet) {
                if (!child.extra().singleton()) continue;
                String childType = child.type();
                if (child.objectName().equals(proxy.child(childType).objectName())) continue;
                throw new Exception("Child type " + childType + " cannot be found via child(type)");
            }
            for (String type : childrenMaps.keySet()) {
                Map<String, AMXProxy> m = proxy.childrenMap(type);
                if (m.keySet().size() != 0) continue;
                throw new Exception("Child type " + type + " has nothing in Map");
            }
        }
        catch (Throwable t) {
            problems.add("Test failure: " + this.toString(t));
        }
        return problems;
    }

    private void fail(ObjectName objectName, String msg) throws ValidationFailureException {
        throw new ValidationFailureException(objectName, msg);
    }

    private void fail(AMXProxy amx, String msg) throws ValidationFailureException {
        throw new ValidationFailureException(amx, msg);
    }

    private void validateObjectName(AMXProxy proxy) throws ValidationFailureException {
        String nameProp;
        ObjectName objectName = proxy.objectName();
        String type = objectName.getKeyProperty("type");
        if (type == null || type.length() == 0) {
            this.fail(objectName, "type property required in ObjectName");
        }
        if (!LEGAL_PATTERN_FOR_TYPE.matcher(type).matches()) {
            this.fail(objectName, "Illegal type \"" + type + "\", does not match " + LEGAL_PATTERN_FOR_TYPE.pattern());
        }
        if ((nameProp = objectName.getKeyProperty("name")) != null) {
            if (nameProp.length() == 0) {
                this.fail(objectName, "name property of ObjectName may not be empty");
            }
            if (!LEGAL_PATTERN_FOR_NAME.matcher(nameProp).matches()) {
                this.fail(objectName, "Illegal name \"" + nameProp + "\", does not match " + LEGAL_PATTERN_FOR_NAME.pattern());
            }
        } else {
            String name = proxy.getName();
            if (!name.equals("")) {
                this.fail(objectName, "getName() returned a non-empty name for a singleton: " + name);
            }
            if (!proxy.extra().singleton()) {
                this.fail(objectName, "Metadata claims named (non-singleton), but no name property present in ObjectName");
            }
        }
        if (proxy.parent() != null && !proxy.parentPath().equals(proxy.parent().path())) {
            this.fail(objectName, "Parent path of " + proxy.parentPath() + " does not match parent's path for " + proxy.parent().objectName());
        }
    }

    private void validateChildren(AMXProxy proxy) throws ValidationFailureException {
        Set<String> attrNames = proxy.attributeNames();
        if (!attrNames.contains("Children")) {
            try {
                ObjectName[] children = proxy.getChildren();
                this.fail(proxy, "MBean has no Children attribute in its MBeanInfo, but supplies the attribute");
            }
            catch (Exception e) {}
        } else {
            try {
                ObjectName[] children = proxy.getChildren();
                if (children == null) {
                    this.fail(proxy, "Children attribute must be non-null");
                }
                for (ObjectName childObjectName : children) {
                    if (childObjectName == null) {
                        this.fail(proxy, "Child in Children array is null");
                    }
                    AMXProxy child = this.mProxyFactory.getProxy(childObjectName);
                    if (proxy.objectName().equals(child.parent().objectName())) continue;
                    this.fail(proxy, "Child\u00e2\u0080\u0099s Parent of " + child.parent().objectName() + " does not match the actual parent of " + proxy.objectName());
                }
                HashSet<String> caseSensitiveTypes = new HashSet<String>();
                HashSet<String> caseInsensitiveTypes = new HashSet<String>();
                for (ObjectName o : children) {
                    caseSensitiveTypes.add(Util.getTypeProp(o));
                    caseInsensitiveTypes.add(Util.getTypeProp(o).toLowerCase());
                }
                if (caseSensitiveTypes.size() != caseInsensitiveTypes.size()) {
                    this.fail(proxy, "Children types must be case-insensitive");
                }
            }
            catch (Exception e) {
                this.fail(proxy, "MBean failed to supply Children attribute");
            }
        }
    }

    private static List<String> validateMetadata(AMXProxy proxy) {
        ArrayList<String> problems = new ArrayList<String>();
        Descriptor d = proxy.extra().mbeanInfo().getDescriptor();
        Set<String> LEGAL_AMX_DESCRIPTORS = SetUtil.newStringSet("amx.genericInterfaceName", "amx.isSingleton", "amx.group", "amx.supportsAdoption", "amx.subTypes");
        for (String fieldName : d.getFieldNames()) {
            if (!fieldName.startsWith("amx.") || LEGAL_AMX_DESCRIPTORS.contains(fieldName)) continue;
            problems.add("Illegal/unknown AMX metadata field: " + fieldName + " = " + d.getFieldValue(fieldName));
        }
        MetadataValidator val = new MetadataValidator(d, problems);
        val.validateMetadataBoolean("amx.isSingleton");
        val.validateMetadataBoolean("amx.supportsAdoption");
        val.validateMetadataBoolean("immutableInfo");
        val.validateMetadataStringNonEmpty("interfaceName");
        val.validateMetadataStringNonEmpty("amx.genericInterfaceName");
        val.validateMetadataStringNonEmpty("amx.group");
        val.validate("amx.subTypes", String[].class);
        return problems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateRequiredAttributes(AMXProxy proxy) throws ValidationFailureException {
        ObjectName objectName = proxy.objectName();
        Map<String, MBeanAttributeInfo> infos = JMXUtil.attributeInfosToMap(proxy.extra().mbeanInfo().getAttributes());
        Set<String> attrNames = infos.keySet();
        if (!attrNames.contains("Name")) {
            this.fail(objectName, "MBeanInfo does not contain Name attribute");
        }
        if (!attrNames.contains("Parent")) {
            this.fail(objectName, "MBeanInfo does not contain Parent attribute");
        }
        if (attrNames.contains("Children")) {
            try {
                if (proxy.getChildren() != null) return;
                this.fail(objectName, "value of Children attribute must not be null");
                return;
            }
            catch (AMXException e) {
                throw e;
            }
            catch (Exception e) {
                this.fail(objectName, "does not supply children correctly");
                return;
            }
        }
        try {
            proxy.getChildren();
            this.fail(objectName, "Children attribute is present, but not listed in MBeanInfo");
            return;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public ValidationResult validate(ObjectName[] targets) {
        Failures failures = new Failures();
        DomainRoot dr = this.mDomainRoot;
        for (ObjectName objectName : targets) {
            AMXProxy amx = this.mProxyFactory.getProxy(objectName);
            List<String> problems = this._validate(amx);
            failures.result(objectName, problems);
        }
        ValidationResult result = new ValidationResult(failures.getNumTested(), failures.getNumFailures(), failures.toString());
        return result;
    }

    public ValidationResult validate(ObjectName objectName) {
        ObjectName[] targets = new ObjectName[]{objectName};
        return this.validate(targets);
    }

    public ValidationResult validate() {
        Set<ObjectName> all = this.mDomainRoot.getQueryMgr().queryAllObjectNameSet();
        return this.validate(CollectionUtil.toArray(all, ObjectName.class));
    }

    public static final class ValidationResult {
        private final String mDetails;
        private final int mNumTested;
        private final int mNumFailures;

        public ValidationResult(int numTested, int numFailures, String details) {
            this.mNumTested = numTested;
            this.mNumFailures = numFailures;
            this.mDetails = details;
        }

        public String details() {
            return this.mDetails;
        }

        public int numTested() {
            return this.mNumTested;
        }

        public int numFailures() {
            return this.mNumFailures;
        }

        public String toString() {
            return this.details();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MetadataValidator {
        private final Descriptor mDescriptor;
        private final Set<String> mFieldNames;
        private final List<String> mProblems;

        public MetadataValidator(Descriptor d, List<String> problems) {
            this.mDescriptor = d;
            this.mFieldNames = SetUtil.newSet(d.getFieldNames());
            this.mProblems = problems;
        }

        void validateMetadataBoolean(String fieldName) {
            if (this.mFieldNames.contains(fieldName)) {
                Object value = this.mDescriptor.getFieldValue(fieldName);
                if (value == null) {
                    this.mProblems.add("Descriptor field " + fieldName + " must not be null");
                } else if (!(value instanceof Boolean || value.equals("true") || value.equals("false"))) {
                    this.mProblems.add("Descriptor field " + fieldName + " must be set to 'true' or 'false', value is " + value);
                }
            }
        }

        void validateMetadataStringNonEmpty(String fieldName) {
            Object value;
            if (this.mFieldNames.contains(fieldName) && ((value = this.mDescriptor.getFieldValue(fieldName)) == null || !(value instanceof String) || ((String)value).length() == 0)) {
                this.mProblems.add("Descriptor field " + fieldName + " must be non-zero length String, value = " + value);
            }
        }

        void validate(String fieldName, Class<?> clazz) {
            Object value;
            if (this.mFieldNames.contains(fieldName) && ((value = this.mDescriptor.getFieldValue(fieldName)) == null || !clazz.isAssignableFrom(value.getClass()))) {
                this.mProblems.add("Descriptor field " + fieldName + " must be of class " + clazz.getSimpleName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Failures {
        private final ConcurrentMap<ObjectName, List<String>> mFailures = new ConcurrentHashMap<ObjectName, List<String>>();
        private AtomicInteger mNumTested = new AtomicInteger();

        public int getNumTested() {
            return this.mNumTested.get();
        }

        public int getNumFailures() {
            return this.mFailures.keySet().size();
        }

        public Map<ObjectName, List<String>> getFailures() {
            return this.mFailures;
        }

        void result(ObjectName objectName, List<String> problems) {
            this.mNumTested.incrementAndGet();
            if (problems != null && problems.size() != 0) {
                this.mFailures.put(objectName, problems);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (ObjectName badBoy : this.mFailures.keySet()) {
                List failures = (List)this.mFailures.get(badBoy);
                builder.append(badBoy + NL);
                builder.append(CollectionUtil.toString(failures, NL));
                builder.append(NL);
                builder.append(NL);
            }
            builder.append(this.mFailures.size() + " failures.");
            return builder.toString() + NL + this.mNumTested + " MBeans tested.";
        }
    }

    private static final class ValidationFailureException
    extends Exception {
        private final ObjectName mObjectName;

        public ValidationFailureException(ObjectName objectName, String msg) {
            super(msg);
            this.mObjectName = objectName;
        }

        public ValidationFailureException(AMXProxy amx, String msg) {
            this(amx.objectName(), msg);
        }

        public ObjectName objectName() {
            return this.mObjectName;
        }

        public String toString() {
            return this.getMessage() + ", " + this.mObjectName;
        }
    }
}

