/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core.proxy;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.Descriptor;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.AMXBooter;
import org.glassfish.admin.amx.core.proxy.AMXProxyHandler;
import org.glassfish.admin.amx.util.AMXDebugHelper;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.ConnectionSource;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.jmx.MBeanServerConnectionConnectionSource;
import org.glassfish.admin.amx.util.jmx.MBeanServerConnectionSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyFactory
implements NotificationListener {
    private final ConnectionSource mConnectionSource;
    private final ObjectName mDomainRootObjectName;
    private final DomainRoot mDomainRoot;
    private final String mMBeanServerID;
    private final ConcurrentMap<ObjectName, MBeanInfo> mMBeanInfoCache = new ConcurrentHashMap<ObjectName, MBeanInfo>();
    private static final AMXDebugHelper mDebug = new AMXDebugHelper(ProxyFactory.class.getName());
    private static final Map<MBeanServerConnection, ProxyFactory> INSTANCES = Collections.synchronizedMap(new HashMap());
    private static final String DOMAIN_ROOT_KEY = "DomainRoot";

    private static void debug(Object ... args) {
        System.out.println(StringUtil.toString(", ", args));
    }

    private static void warning(Object ... args) {
        ProxyFactory.debug(args);
    }

    private ProxyFactory(ConnectionSource connSource) {
        mDebug.setEchoToStdOut(true);
        assert (connSource != null);
        this.mConnectionSource = connSource;
        try {
            MBeanServerConnection conn = this.getMBeanServerConnection();
            this.mMBeanServerID = JMXUtil.getMBeanServerID(conn);
            this.mDomainRootObjectName = AMXBooter.findDomainRoot(conn);
            if (this.mDomainRootObjectName == null) {
                throw new IllegalStateException("ProxyFactory: AMX has not been started");
            }
            ProxyFactory.debug("ProxyFactory: mDomainRootObjectName = " + this.mDomainRootObjectName);
            this.mDomainRoot = this.getProxy(this.mDomainRootObjectName, DomainRoot.class);
            try {
                MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
                filter.enableAllObjectNames();
                filter.disableAllTypes();
                filter.enableType("JMX.mbean.unregistered");
                JMXUtil.listenToMBeanServerDelegate(conn, this, filter, null);
            }
            catch (Exception e) {
                ProxyFactory.warning("ProxyFactory: connection does not support notifications: ", this.mMBeanServerID, connSource);
            }
            JMXConnector connector = connSource.getJMXConnector(false);
            if (connector != null) {
                try {
                    connector.addConnectionNotificationListener(this, null, null);
                }
                catch (Exception e) {
                    ProxyFactory.warning("addConnectionNotificationListener failed: ", this.mMBeanServerID, connSource, e);
                }
            }
        }
        catch (Exception e) {
            ProxyFactory.warning("ProxyFactory.ProxyFactory:\n", e);
            throw new RuntimeException(e);
        }
    }

    private void connectionBad() {
        HashSet proxies = new HashSet();
        for (AMXProxy amx : proxies) {
            AMXProxyHandler proxy = AMXProxyHandler.unwrap(amx);
            proxy.connectionBad();
        }
    }

    public boolean checkConnection() {
        boolean connectionGood = true;
        try {
            this.getMBeanServerConnection().isRegistered(JMXUtil.getMBeanServerDelegateObjectName());
            connectionGood = true;
        }
        catch (Exception e) {
            this.connectionBad();
        }
        return connectionGood;
    }

    void notifsLost() {
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        String type = notifIn.getType();
        if (type.equals("JMX.mbean.unregistered")) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
        } else if (notifIn instanceof JMXConnectionNotification) {
            if (type.equals("jmx.remote.connection.closed") || type.equals("jmx.remote.connection.failed")) {
                ProxyFactory.debug("ProxyFactory.handleNotification: connection closed or failed: ", notifIn);
                this.connectionBad();
            } else if (type.equals("jmx.remote.connection.notifs.lost")) {
                ProxyFactory.debug("ProxyFactory.handleNotification: notifications lost: ", notifIn);
                this.notifsLost();
            }
        } else {
            ProxyFactory.debug("ProxyFactory.handleNotification: UNKNOWN notification: ", notifIn);
        }
    }

    public DomainRoot createDomainRoot() throws IOException {
        return this.mDomainRoot;
    }

    public DomainRoot initDomainRoot() throws IOException {
        ObjectName domainRootObjectName = this.getDomainRootObjectName();
        DomainRoot dr = this.getProxy(domainRootObjectName, DomainRoot.class);
        return dr;
    }

    public ObjectName getDomainRootObjectName() {
        return this.mDomainRootObjectName;
    }

    public DomainRoot getDomainRootProxy() {
        return this.getDomainRootProxy(false);
    }

    public DomainRoot getDomainRootProxy(boolean waitReady) {
        if (waitReady) {
            this.mDomainRoot.waitAMXReady();
        }
        return this.mDomainRoot;
    }

    public ConnectionSource getConnectionSource() {
        return this.mConnectionSource;
    }

    public String getMBeanServerID() {
        return this.mMBeanServerID;
    }

    public static ProxyFactory getInstance(MBeanServer server) {
        return ProxyFactory.getInstance(new MBeanServerConnectionSource(server), true);
    }

    public static ProxyFactory getInstance(MBeanServerConnection conn) {
        return ProxyFactory.getInstance(new MBeanServerConnectionConnectionSource(conn), true);
    }

    public static ProxyFactory getInstance(ConnectionSource conn) {
        return ProxyFactory.getInstance(conn, true);
    }

    public static synchronized ProxyFactory getInstance(ConnectionSource connSource, boolean useMBeanServerID) {
        ProxyFactory instance = ProxyFactory.findInstance(connSource);
        if (instance == null) {
            try {
                MBeanServerConnection conn = connSource.getMBeanServerConnection(false);
                instance = ProxyFactory.findInstance(conn);
                if (instance == null && (useMBeanServerID || connSource instanceof MBeanServerConnectionSource)) {
                    String id = JMXUtil.getMBeanServerID(conn);
                    instance = ProxyFactory.findInstanceByID(id);
                }
                if (instance == null) {
                    instance = new ProxyFactory(connSource);
                    INSTANCES.put(conn, instance);
                }
            }
            catch (Exception e) {
                ProxyFactory.warning("ProxyFactory.getInstance: failure creating ProxyFactory: ", e);
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstance(ConnectionSource conn) {
        return INSTANCES.get(conn);
    }

    public static synchronized ProxyFactory findInstance(MBeanServerConnection conn) {
        ProxyFactory instance = null;
        Collection<ProxyFactory> values = INSTANCES.values();
        for (ProxyFactory factory : values) {
            if (factory.getConnectionSource().getExistingMBeanServerConnection() != conn) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstanceByID(String mbeanServerID) {
        ProxyFactory instance = null;
        Collection<ProxyFactory> values = INSTANCES.values();
        for (ProxyFactory factory : values) {
            if (!factory.getMBeanServerID().equals(mbeanServerID)) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) {
        try {
            MBeanInfo info = (MBeanInfo)this.mMBeanInfoCache.get(objectName);
            if (info == null && ProxyFactory.invariantMBeanInfo(info = this.getMBeanServerConnection().getMBeanInfo(objectName))) {
                this.mMBeanInfoCache.put(objectName, info);
            }
            return info;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean invariantMBeanInfo(MBeanInfo info) {
        Descriptor d = info.getDescriptor();
        if (d == null) {
            return false;
        }
        String value = "" + d.getFieldValue("immutableInfo");
        return Boolean.valueOf(value);
    }

    protected MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getConnectionSource().getMBeanServerConnection(false);
    }

    public <T extends AMXProxy> T getProxy(ObjectName objectName, Class<T> intf) {
        T proxy = this.getProxy(objectName, this.getMBeanInfo(objectName), intf);
        return proxy;
    }

    public AMXProxy getProxy(ObjectName objectName) {
        MBeanInfo info = this.getMBeanInfo(objectName);
        Class<? extends AMXProxy> intf = ProxyFactory.getGenericAMXInterface(info);
        AMXProxy proxy = this.getProxy(objectName, info, intf);
        return proxy;
    }

    public static Class<? extends AMXProxy> getGenericAMXInterface(MBeanInfo info) {
        String intfName = AMXProxyHandler.getGenericInterfaceName(info);
        Class<AMXProxy> intf = AMXProxy.class;
        if (intfName == null || AMXProxy.class.getName().equals(intfName)) {
            intf = AMXProxy.class;
        } else if (AMXConfigProxy.class.getName().equals(intfName)) {
            intf = AMXConfigProxy.class;
        } else if (intfName.startsWith(AMXProxy.class.getPackage().getName())) {
            try {
                intf = Class.forName(intfName, false, ProxyFactory.class.getClassLoader()).asSubclass(AMXProxy.class);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.getInterfaceClass(): Unable to load interface " + intfName);
            }
        } else {
            intf = AMXProxy.class;
        }
        return intf;
    }

    <T extends AMXProxy> T getProxy(ObjectName objectName, MBeanInfo mbeanInfoIn, Class<T> intfIn) {
        Class<Object> intf;
        AMXProxy proxy = null;
        MBeanInfo mbeanInfo = mbeanInfoIn;
        if (mbeanInfo == null) {
            mbeanInfo = this.getMBeanInfo(objectName);
        }
        if (AMXProxy.class == (intf = intfIn)) {
            intf = ProxyFactory.getGenericAMXInterface(mbeanInfoIn);
        }
        try {
            AMXProxyHandler handler = new AMXProxyHandler(this.getMBeanServerConnection(), objectName, mbeanInfo);
            proxy = (AMXProxy)Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)handler);
        }
        catch (IllegalArgumentException e) {
            ProxyFactory.debug("createProxy", e);
            throw e;
        }
        catch (Exception e) {
            ProxyFactory.debug("createProxy", e);
            throw new RuntimeException(e);
        }
        return (T)((AMXProxy)intfIn.cast(proxy));
    }

    protected static String toString(Object o) {
        return "" + o;
    }

    public AMXProxy[] toProxy(ObjectName[] objectNames) {
        AMXProxy[] result = new AMXProxy[objectNames.length];
        for (int i = 0; i < objectNames.length; ++i) {
            result[i] = this.getProxy(objectNames[i]);
        }
        return result;
    }

    public Set<AMXProxy> toProxySet(Set<ObjectName> objectNames) {
        HashSet<AMXProxy> s = new HashSet<AMXProxy>();
        for (ObjectName objectName : objectNames) {
            try {
                AMXProxy proxy = this.getProxy(objectName);
                assert (!s.contains(proxy));
                s.add(proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return s;
    }

    public Set<AMXProxy> toProxySet(ObjectName[] objectNames, Class<? extends AMXProxy> intf) {
        HashSet<AMXProxy> result = new HashSet<AMXProxy>();
        for (ObjectName objectName : objectNames) {
            result.add(this.getProxy(objectName, intf));
        }
        return result;
    }

    public List<AMXProxy> toProxyList(Collection<ObjectName> objectNames) {
        ArrayList<AMXProxy> list = new ArrayList<AMXProxy>();
        for (ObjectName objectName : objectNames) {
            try {
                AMXProxy proxy = this.getProxy(objectName);
                list.add(proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return list;
    }

    public Map<String, AMXProxy> toProxyMap(Map<String, ObjectName> objectNameMap) {
        HashMap<String, AMXProxy> resultMap = new HashMap<String, AMXProxy>();
        Set<String> keys = objectNameMap.keySet();
        for (String key : keys) {
            ObjectName objectName = objectNameMap.get(key);
            try {
                AMXProxy proxy = this.getProxy(objectName);
                resultMap.put(key, proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return resultMap;
    }

    public Map<String, AMXProxy> toProxyMap(ObjectName[] objectNames, Class<? extends AMXProxy> intf) {
        HashMap<String, AMXProxy> resultMap = new HashMap<String, AMXProxy>();
        for (ObjectName objectName : objectNames) {
            String key = objectName.getKeyProperty("name");
            AMXProxy proxy = this.getProxy(objectName, intf);
            resultMap.put(key, proxy);
        }
        return resultMap;
    }

    public List<AMXProxy> toProxyList(ObjectName[] objectNames, Class<? extends AMXProxy> intf) {
        ArrayList<AMXProxy> result = new ArrayList<AMXProxy>();
        for (ObjectName objectName : objectNames) {
            result.add(this.getProxy(objectName, intf));
        }
        return result;
    }
}

