/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.CookieConfigDescriptor;
import com.sun.enterprise.deployment.SessionConfigDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.web.CookieConfigNode;
import javax.servlet.SessionTrackingMode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SessionConfigNode
extends DeploymentDescriptorNode {
    private SessionConfigDescriptor descriptor;

    public SessionConfigNode() {
        this.registerElementHandler(new XMLElement("cookie-config"), CookieConfigNode.class, "setCookieConfigDescriptor");
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (SessionConfigDescriptor)super.getDescriptor();
        }
        return this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("session-timeout".equals(element.getQName())) {
            if (this.descriptor.getSessionTimeout() != 30) {
                throw new RuntimeException("Has more than one session-config element!");
            }
            this.descriptor.setSessionTimeout(Integer.valueOf(value.trim()));
        } else if ("tracking-mode".equals(element.getQName())) {
            this.descriptor.addTrackingMode(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, SessionConfigDescriptor descriptor) {
        CookieConfigDescriptor cookieConfigDesc;
        Element myNode = SessionConfigNode.appendChild(parent, nodeName);
        if (descriptor.getSessionTimeout() != 30) {
            SessionConfigNode.appendTextChild((Node)myNode, "session-timeout", String.valueOf(descriptor.getSessionTimeout()));
        }
        if ((cookieConfigDesc = descriptor.getCookieConfigDescriptor()) != null) {
            CookieConfigNode cookieConfigNode = new CookieConfigNode();
            cookieConfigNode.writeDescriptor((Node)myNode, "cookie-config", cookieConfigDesc);
        }
        if (descriptor.getTrackingModes().size() > 0) {
            for (SessionTrackingMode tmEnum : descriptor.getTrackingModes()) {
                SessionConfigNode.appendTextChild((Node)myNode, "tracking-mode", tmEnum.name());
            }
        }
        return myNode;
    }
}

