/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SelectItemsIterator
implements Iterator<SelectItem> {
    private Iterator<SelectItem> items;
    private ListIterator<UIComponent> kids;
    private SingleElementIterator singleItemIterator;
    private FacesContext ctx;

    public SelectItemsIterator(FacesContext ctx, UIComponent parent) {
        this.kids = parent.getChildren().listIterator();
        this.ctx = ctx;
        this.initializeItems();
    }

    @Override
    public boolean hasNext() {
        Object next;
        if (this.items != null) {
            if (this.items.hasNext()) {
                return true;
            }
            this.items = null;
        }
        if ((next = this.findNextValidChild()) != null) {
            this.kids.previous();
            return true;
        }
        return false;
    }

    @Override
    public SelectItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.items != null) {
            return this.items.next();
        }
        this.initializeItems();
        return this.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initializeItems() {
        UIComponent kid = (UIComponent)this.findNextValidChild();
        if (kid instanceof UISelectItem) {
            UISelectItem ui = (UISelectItem)kid;
            SelectItem item = (SelectItem)ui.getValue();
            if (item == null) {
                item = new SelectItem(ui.getItemValue(), ui.getItemLabel(), ui.getItemDescription(), ui.isItemDisabled(), ui.isItemEscaped(), ui.isNoSelectionOption());
            }
            this.updateSingeItemIterator(item);
            this.items = this.singleItemIterator;
        } else if (kid instanceof UISelectItems) {
            UISelectItems ui = (UISelectItems)kid;
            Object value = ui.getValue();
            if (value instanceof SelectItem) {
                this.updateSingeItemIterator((SelectItem)value);
                this.items = this.singleItemIterator;
            } else if (value.getClass().isArray()) {
                this.items = new ArrayIterator(this.ctx, (UISelectItems)kid, value);
            } else if (value instanceof Iterable) {
                this.items = new IterableItemIterator(this.ctx, (UISelectItems)kid, (Iterable)value);
            } else if (value instanceof Map) {
                this.items = new MapIterator((Map)value);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private Object findNextValidChild() {
        if (this.kids.hasNext()) {
            UIComponent next = this.kids.next();
            while (this.kids.hasNext() && !(next instanceof UISelectItem) && !(next instanceof UISelectItems)) {
                next = this.kids.next();
            }
            if (next instanceof UISelectItem || next instanceof UISelectItems) {
                return next;
            }
        }
        return null;
    }

    private void updateSingeItemIterator(SelectItem item) {
        if (this.singleItemIterator == null) {
            this.singleItemIterator = new SingleElementIterator();
        }
        this.singleItemIterator.updateItem(item);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IterableItemIterator
    extends GenericObjectSelectItemIterator {
        private FacesContext ctx;
        private Iterator<?> iterator;

        private IterableItemIterator(FacesContext ctx, UISelectItems sourceComponent, Iterable<?> iterable) {
            super(sourceComponent);
            this.ctx = ctx;
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SelectItem next() {
            Object item = this.iterator.next();
            if (item instanceof SelectItem) {
                return (SelectItem)item;
            }
            return this.getSelectItemFor(this.ctx, item);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ArrayIterator
    extends GenericObjectSelectItemIterator {
        private FacesContext ctx;
        private Object array;
        private int count;
        private int index;

        private ArrayIterator(FacesContext ctx, UISelectItems sourceComponent, Object array) {
            super(sourceComponent);
            this.ctx = ctx;
            this.array = array;
            this.count = Array.getLength(array);
        }

        public boolean hasNext() {
            return this.index < this.count;
        }

        public SelectItem next() {
            Object item;
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            if ((item = Array.get(this.array, this.index++)) instanceof SelectItem) {
                return (SelectItem)item;
            }
            return this.getSelectItemFor(this.ctx, item);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class GenericObjectSelectItemIterator
    implements Iterator<SelectItem> {
        private GenericObjectSelectItem genericObjectSI;
        protected UISelectItems sourceComponent;

        protected GenericObjectSelectItemIterator(UISelectItems sourceComponent) {
            this.sourceComponent = sourceComponent;
        }

        protected SelectItem getSelectItemFor(FacesContext ctx, Object value) {
            if (this.genericObjectSI == null) {
                this.genericObjectSI = new GenericObjectSelectItem(this.sourceComponent);
            }
            this.genericObjectSI.updateItem(ctx, value);
            return this.genericObjectSI;
        }

        private static final class GenericObjectSelectItem
        extends SelectItem {
            private static final String VAR = "var";
            private static final String ITEM_VALUE = "itemValue";
            private static final String ITEM_LABEL = "itemLabel";
            private static final String ITEM_DESCRIPTION = "itemDescription";
            private static final String ITEM_ESCAPED = "itemLabelEscaped";
            private static final String ITEM_DISABLED = "itemDisabled";
            private static final String NO_SELECTION_OPTION = "noSelectionOption";
            private ValueExpression itemValue;
            private ValueExpression itemLabel;
            private ValueExpression itemDescription;
            private ValueExpression itemEscaped;
            private ValueExpression itemDisabled;
            private ValueExpression noSelectionOption;
            private String var;
            private UISelectItems sourceComponent;

            private GenericObjectSelectItem(UISelectItems sourceComponent) {
                this.var = (String)sourceComponent.getAttributes().get(VAR);
                this.sourceComponent = sourceComponent;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateItem(FacesContext ctx, Object value) {
                Map<String, Object> reqMap = ctx.getExternalContext().getRequestMap();
                Object oldVarValue = null;
                if (this.var != null) {
                    oldVarValue = reqMap.put(this.var, value);
                }
                try {
                    Map<String, Object> attrs = this.sourceComponent.getAttributes();
                    Object itemValueResult = attrs.get(ITEM_VALUE);
                    Object itemLabelResult = attrs.get(ITEM_LABEL);
                    Object itemDescriptionResult = attrs.get(ITEM_DESCRIPTION);
                    Object itemEscapedResult = attrs.get(ITEM_ESCAPED);
                    Object itemDisabledResult = attrs.get(ITEM_DISABLED);
                    Object noSelectionOptionResult = attrs.get(NO_SELECTION_OPTION);
                    this.setValue(itemValueResult != null ? itemValueResult : value);
                    this.setLabel(itemLabelResult != null ? itemLabelResult.toString() : value.toString());
                    this.setDescription(itemDescriptionResult != null ? itemDescriptionResult.toString() : null);
                    this.setEscape(itemEscapedResult != null ? Boolean.valueOf(itemEscapedResult.toString()) : false);
                    this.setDisabled(itemDisabledResult != null ? Boolean.valueOf(itemDisabledResult.toString()) : false);
                    this.setNoSelectionOption(noSelectionOptionResult != null ? Boolean.valueOf(noSelectionOptionResult.toString()) : false);
                }
                finally {
                    if (this.var != null) {
                        if (oldVarValue != null) {
                            reqMap.put(this.var, oldVarValue);
                        } else {
                            reqMap.remove(this.var);
                        }
                    }
                }
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                throw new NotSerializableException();
            }

            private void readObject(ObjectInputStream in) throws IOException {
                throw new NotSerializableException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapIterator
    implements Iterator<SelectItem> {
        private SelectItem item = new SelectItem();
        private Iterator iterator;

        private MapIterator(Map map) {
            this.iterator = map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SelectItem next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.item.setLabel(key != null ? key.toString() : value.toString());
            this.item.setValue(value != null ? value : "");
            return this.item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingleElementIterator
    implements Iterator<SelectItem> {
        private SelectItem item;
        private boolean nextCalled;

        private SingleElementIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.nextCalled;
        }

        @Override
        public SelectItem next() {
            if (this.nextCalled) {
                throw new NoSuchElementException();
            }
            this.nextCalled = true;
            return this.item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void updateItem(SelectItem item) {
            this.item = item;
            this.nextCalled = false;
        }
    }
}

