/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="undeploy")
@I18n(value="undeploy.command")
@Scoped(value=PerLookup.class)
public class UndeployCommand
extends UndeployCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UndeployCommand.class);
    @Inject
    Deployment deployment;
    @Inject
    ArchiveFactory archiveFactory;

    public UndeployCommand() {
        this.origin = OpsParams.Origin.undeploy;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        this.name = new File(this.name).getName();
        ApplicationInfo info = this.deployment.get(this.name);
        Named module = ConfigBeansUtilities.getModule((String)this.name);
        Application application = null;
        if (module instanceof Application) {
            application = (Application)module;
        }
        if (module == null) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ReadableArchive source = null;
        if (info == null) {
            if (application != null) {
                File location = new File(application.getLocation());
                if (location.exists()) {
                    try {
                        source = this.archiveFactory.openArchive(location);
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, e.getMessage(), e);
                    }
                } else {
                    logger.warning("Originally deployed application at " + location + " not found");
                }
            }
        } else {
            source = info.getSource();
        }
        ExtendedDeploymentContext deploymentContext = null;
        try {
            deploymentContext = this.deployment.getContext(logger, source, (OpsParams)this, report);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot create context for undeployment ", e);
            report.setMessage(localStrings.getLocalString("undeploy.contextcreation.failed", "Cannot create context for undeployment : {0} ", new Object[]{e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        deploymentContext.getAppProps().putAll((Map<?, ?>)application.getDeployProperties());
        if (this.properties != null) {
            deploymentContext.getAppProps().putAll((Map<?, ?>)this.properties);
        }
        deploymentContext.setModulePropsMap(application.getModulePropertiesMap());
        if (info != null) {
            this.deployment.undeploy(this.name, deploymentContext);
        }
        boolean isDirectoryDeployed = false;
        if (application != null) {
            isDirectoryDeployed = Boolean.valueOf(application.getDirectoryDeployed());
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            try {
                this.deployment.unregisterAppFromDomainXML(this.name);
            }
            catch (TransactionFailure e) {
                logger.warning("Module " + this.name + " not found in configuration");
            }
            deploymentContext.clean();
            if (source != null && !this.keepreposdir.booleanValue() && !isDirectoryDeployed && source.exists()) {
                FileUtils.whack((File)new File(info.getSource().getURI()));
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }
}

