/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.ee.jms;

import javax.inject.ExecutionException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bean.ee.jms.ConnectionContextual;
import org.jboss.webbeans.bean.ee.jms.JmsMethodHandler;
import org.jboss.webbeans.bean.ee.jms.MessageConsumerContextual;
import org.jboss.webbeans.bean.ee.jms.MessageProducerContextual;
import org.jboss.webbeans.bean.ee.jms.SessionContextual;
import org.jboss.webbeans.messaging.spi.JmsServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JmsTopicMethodHandler
extends JmsMethodHandler<TopicConnection, TopicSession, TopicPublisher, TopicSubscriber> {
    private static final long serialVersionUID = 5209925842290226027L;
    private final ConnectionContextual<TopicConnection> connectionContexual;
    private final SessionContextual<TopicSession> sessionContextual;
    private final MessageProducerContextual<TopicPublisher> messageProducerContextual;
    private final MessageConsumerContextual<TopicSubscriber> messageConsumerContextual;

    public JmsTopicMethodHandler(String jndiName, String mappedName) {
        super(jndiName, mappedName);
        final JmsServices jmsServices = CurrentManager.rootManager().getServices().get(JmsServices.class);
        this.connectionContexual = new ConnectionContextual<TopicConnection>(){
            private static final long serialVersionUID = 7830020942920371399L;

            @Override
            protected TopicConnection createConnection() throws JMSException {
                return jmsServices.getTopicConnectionFactory().createTopicConnection();
            }
        };
        this.sessionContextual = new SessionContextual<TopicSession>(){
            private static final long serialVersionUID = -5964106446504141417L;

            @Override
            protected TopicSession createSession() throws JMSException {
                return JmsTopicMethodHandler.this.createSessionFromConnection((ConnectionContextual<TopicConnection>)JmsTopicMethodHandler.this.connectionContexual);
            }
        };
        this.messageProducerContextual = new MessageProducerContextual<TopicPublisher>(){
            private static final long serialVersionUID = 3215720243380210179L;

            @Override
            protected TopicPublisher createMessageProducer() throws JMSException {
                Topic topic = (Topic)jmsServices.resolveDestination(JmsTopicMethodHandler.this.getJndiName(), JmsTopicMethodHandler.this.getMappedName());
                try {
                    return JmsTopicMethodHandler.this.createSessionFromConnection((ConnectionContextual<TopicConnection>)JmsTopicMethodHandler.this.connectionContexual).createPublisher(topic);
                }
                catch (JMSException e) {
                    throw new ExecutionException("Error creating TopicPublisher", e);
                }
            }
        };
        this.messageConsumerContextual = new MessageConsumerContextual<TopicSubscriber>(){
            private static final long serialVersionUID = -5461921479716229659L;

            @Override
            protected TopicSubscriber createMessageConsumer() throws JMSException {
                Topic topic = (Topic)jmsServices.resolveDestination(JmsTopicMethodHandler.this.getJndiName(), JmsTopicMethodHandler.this.getMappedName());
                try {
                    return JmsTopicMethodHandler.this.createSessionFromConnection((ConnectionContextual<TopicConnection>)JmsTopicMethodHandler.this.connectionContexual).createSubscriber(topic);
                }
                catch (JMSException e) {
                    throw new ExecutionException("Error creating TopicSubscriber", e);
                }
            }
        };
    }

    @Override
    protected TopicSession createSessionFromConnection(ConnectionContextual<TopicConnection> connectionContexual) {
        try {
            return this.getConnection(connectionContexual).createTopicSession(false, 1);
        }
        catch (JMSException e) {
            throw new ExecutionException("Error creating session", e);
        }
    }

    @Override
    protected ConnectionContextual<TopicConnection> getConnectionContextual() {
        return this.connectionContexual;
    }

    @Override
    protected MessageConsumerContextual<TopicSubscriber> getMessageConsumerContextual() {
        return this.messageConsumerContextual;
    }

    @Override
    protected MessageProducerContextual<TopicPublisher> getMessageProducerContextual() {
        return this.messageProducerContextual;
    }

    @Override
    protected SessionContextual<TopicSession> getSessionContextual() {
        return this.sessionContextual;
    }
}

