/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.jboss.webbeans.BeanValidator;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.ee.AbstractJavaEEResourceBean;
import org.jboss.webbeans.bean.standard.EventBean;
import org.jboss.webbeans.bean.standard.InjectionPointBean;
import org.jboss.webbeans.bean.standard.InstanceBean;
import org.jboss.webbeans.bean.standard.ManagerBean;
import org.jboss.webbeans.bootstrap.BeanDeployer;
import org.jboss.webbeans.bootstrap.api.Bootstrap;
import org.jboss.webbeans.bootstrap.api.Environments;
import org.jboss.webbeans.bootstrap.api.helpers.AbstractBootstrap;
import org.jboss.webbeans.bootstrap.api.helpers.ServiceRegistries;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.ContextLifecycle;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.RequestContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.webbeans.conversation.ConversationImpl;
import org.jboss.webbeans.conversation.JavaSEConversationTerminator;
import org.jboss.webbeans.conversation.NumericConversationIdGenerator;
import org.jboss.webbeans.conversation.ServletConversationManager;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.ejb.EjbDescriptorCache;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.jsf.JSFApiAbstraction;
import org.jboss.webbeans.literal.DeployedLiteral;
import org.jboss.webbeans.literal.InitializedLiteral;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.persistence.DefaultEntityDiscovery;
import org.jboss.webbeans.persistence.PersistenceApiAbstraction;
import org.jboss.webbeans.persistence.spi.EntityDiscovery;
import org.jboss.webbeans.persistence.spi.JpaServices;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.resources.DefaultResourceLoader;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.resources.spi.ResourceServices;
import org.jboss.webbeans.servlet.HttpSessionManager;
import org.jboss.webbeans.servlet.ServletApiAbstraction;
import org.jboss.webbeans.transaction.spi.TransactionServices;
import org.jboss.webbeans.xml.XmlEnvironment;
import org.jboss.webbeans.xml.XmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeansBootstrap
extends AbstractBootstrap
implements Bootstrap {
    private static Log log = Logging.getLog(WebBeansBootstrap.class);
    private ManagerImpl manager;

    public WebBeansBootstrap() {
        this.getServices().add(ResourceLoader.class, new DefaultResourceLoader());
        this.getServices().add(EntityDiscovery.class, new DefaultEntityDiscovery(this.getServices()));
    }

    @Override
    public void initialize() {
        this.verify();
        if (!this.getServices().contains(TransactionServices.class)) {
            log.info((Object)"Transactional services not available.  Transactional observers will be invoked synchronously.", new Object[0]);
        }
        if (!this.getServices().contains(EjbServices.class)) {
            log.info((Object)"EJB services not available. Session beans will be simple beans, injection into non-contextual EJBs, injection of @EJB in simple beans, injection of Java EE resources and JMS resources will not be available.", new Object[0]);
        }
        if (!this.getServices().contains(JpaServices.class)) {
            log.info((Object)"JPA services not available. Injection of @PersistenceContext will not occur. Entity beans will be discovered as simple beans.", new Object[0]);
        }
        if (!this.getServices().contains(ResourceServices.class)) {
            log.info((Object)"@Resource injection not available.", new Object[0]);
        }
        this.addImplementationServices();
        this.createContexts();
        this.manager = ManagerImpl.newRootManager(ServiceRegistries.unmodifiableServiceRegistry(this.getServices()));
        CurrentManager.setRootManager(this.manager);
        this.initializeContexts();
    }

    private void addImplementationServices() {
        ResourceLoader resourceLoader = this.getServices().get(ResourceLoader.class);
        this.getServices().add(EJBApiAbstraction.class, new EJBApiAbstraction(resourceLoader));
        this.getServices().add(JSFApiAbstraction.class, new JSFApiAbstraction(resourceLoader));
        this.getServices().add(PersistenceApiAbstraction.class, new PersistenceApiAbstraction(resourceLoader));
        this.getServices().add(ServletApiAbstraction.class, new ServletApiAbstraction(resourceLoader));
        this.getServices().add(ClassTransformer.class, new ClassTransformer());
        this.getServices().add(MetaDataCache.class, new MetaDataCache(this.getServices().get(ClassTransformer.class)));
    }

    @Override
    public ManagerImpl getManager() {
        return this.manager;
    }

    protected void registerBeans(Iterable<Class<?>> classes, Collection<AnnotatedClass<?>> xmlClasses, Iterable<AbstractJavaEEResourceBean<?>> resourceBeans, EjbDescriptorCache ejbDescriptors) {
        BeanDeployer beanDeployer = new BeanDeployer(this.manager, ejbDescriptors);
        beanDeployer.addClasses(classes);
        beanDeployer.addClasses(xmlClasses);
        beanDeployer.addBean(ManagerBean.of(this.manager));
        beanDeployer.addBean(InjectionPointBean.of(this.manager));
        beanDeployer.addBean(EventBean.of(this.manager));
        beanDeployer.addBean(InstanceBean.of(this.manager));
        if (!this.getEnvironment().equals(Environments.SE)) {
            beanDeployer.addClass(ConversationImpl.class);
            beanDeployer.addClass(ServletConversationManager.class);
            beanDeployer.addClass(JavaSEConversationTerminator.class);
            beanDeployer.addClass(NumericConversationIdGenerator.class);
            beanDeployer.addClass(HttpSessionManager.class);
        }
        beanDeployer.addBeans(resourceBeans);
        beanDeployer.createBeans().deploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boot() {
        WebBeansBootstrap webBeansBootstrap = this;
        synchronized (webBeansBootstrap) {
            if (this.manager == null) {
                throw new IllegalStateException("Manager has not been initialized");
            }
            if (this.getApplicationContext() == null) {
                throw new IllegalStateException("No application context BeanStore set");
            }
            this.beginApplication(this.getApplicationContext());
            ConcurrentHashMapBeanStore requestBeanStore = new ConcurrentHashMapBeanStore();
            this.beginDeploy(requestBeanStore);
            EjbDescriptorCache ejbDescriptors = new EjbDescriptorCache();
            if (this.getServices().contains(EjbServices.class)) {
                ejbDescriptors.addAll(this.getServices().get(EjbServices.class).discoverEjbs());
            }
            XmlEnvironment xmlEnvironmentImpl = new XmlEnvironment(this.getServices(), ejbDescriptors, this.manager);
            XmlParser parser = new XmlParser(xmlEnvironmentImpl);
            parser.parse();
            List<Class<? extends Annotation>> enabledDeploymentTypes = xmlEnvironmentImpl.getEnabledDeploymentTypes();
            if (enabledDeploymentTypes.size() > 0) {
                this.manager.setEnabledDeploymentTypes(enabledDeploymentTypes);
            }
            log.debug((Object)("Deployment types: " + this.manager.getEnabledDeploymentTypes()), new Object[0]);
            this.registerBeans(this.getServices().get(WebBeanDiscovery.class).discoverWebBeanClasses(), xmlEnvironmentImpl.getClasses(), xmlEnvironmentImpl.getResourceBeans(), ejbDescriptors);
            this.manager.fireEvent(this.manager, new InitializedLiteral());
            log.debug((Object)"Web Beans initialized. Validating beans.", new Object[0]);
            this.manager.getResolver().resolveInjectionPoints();
            new BeanValidator(this.manager).validate();
            this.manager.fireEvent(this.manager, new DeployedLiteral());
            this.endDeploy(requestBeanStore);
        }
    }

    public static String getVersion() {
        Package pkg = WebBeansBootstrap.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    protected void initializeContexts() {
        this.manager.addContext(DependentContext.instance());
        this.manager.addContext(RequestContext.instance());
        this.manager.addContext(ConversationContext.instance());
        this.manager.addContext(SessionContext.instance());
        this.manager.addContext(ApplicationContext.instance());
    }

    protected void createContexts() {
        this.getServices().add(ContextLifecycle.class, new ContextLifecycle());
        this.getServices().add(DependentContext.class, new DependentContext());
        this.getServices().add(RequestContext.class, new RequestContext());
        this.getServices().add(ConversationContext.class, new ConversationContext());
        this.getServices().add(SessionContext.class, new SessionContext());
        this.getServices().add(ApplicationContext.class, new ApplicationContext());
    }

    protected void beginApplication(BeanStore applicationBeanStore) {
        log.trace((Object)"Starting application", new Object[0]);
        ApplicationContext.instance().setBeanStore(applicationBeanStore);
        ApplicationContext.instance().setActive(true);
    }

    protected void beginDeploy(BeanStore requestBeanStore) {
        RequestContext.instance().setBeanStore(requestBeanStore);
        RequestContext.instance().setActive(true);
    }

    protected void endDeploy(BeanStore requestBeanStore) {
        RequestContext.instance().setBeanStore(null);
        RequestContext.instance().setActive(false);
    }

    @Override
    public void shutdown() {
        this.manager.shutdown();
    }

    static {
        log.info((Object)("Web Beans " + WebBeansBootstrap.getVersion()), new Object[0]);
    }
}

