/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.BindingType;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.literal.CurrentLiteral;
import org.jboss.webbeans.util.collections.multi.SetHashMultiMap;
import org.jboss.webbeans.util.collections.multi.SetMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationStore {
    private static final Annotation[] DEFAULT_BINDING_ARRAY = new Annotation[]{new CurrentLiteral()};
    private static final Set<Annotation> DEFAULT_BINDING = new HashSet<Annotation>(Arrays.asList(DEFAULT_BINDING_ARRAY));
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Map<Class<? extends Annotation>, Annotation> annotationMap;
    private final SetMultiMap<Class<? extends Annotation>, Annotation> metaAnnotationMap;
    private final Set<Annotation> annotationSet;
    private final Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap;
    private final SetMultiMap<Class<? extends Annotation>, Annotation> declaredMetaAnnotationMap;
    private final Set<Annotation> declaredAnnotationSet;

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Annotation[] annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Iterable<Annotation> annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    public static AnnotationStore of(AnnotatedElement annotatedElement) {
        return new AnnotationStore(AnnotationStore.buildAnnotationMap(annotatedElement.getAnnotations()), AnnotationStore.buildAnnotationMap(annotatedElement.getDeclaredAnnotations()));
    }

    public static AnnotationStore of(Annotation[] annotations, Annotation[] declaredAnnotations) {
        return new AnnotationStore(AnnotationStore.buildAnnotationMap(annotations), AnnotationStore.buildAnnotationMap(declaredAnnotations));
    }

    public static AnnotationStore wrap(AnnotationStore annotationStore, Set<Annotation> annotations, Set<Annotation> declaredAnnotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        annotationMap.putAll(AnnotationStore.buildAnnotationMap(annotations));
        annotationMap.putAll(annotationStore.getAnnotationMap());
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        declaredAnnotationMap.putAll(AnnotationStore.buildAnnotationMap(declaredAnnotations));
        declaredAnnotationMap.putAll(annotationStore.getDeclaredAnnotationMap());
        return new AnnotationStore(annotationMap, declaredAnnotationMap);
    }

    protected AnnotationStore(Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap) {
        if (annotationMap == null) {
            throw new NullPointerException("annotationMap cannot be null");
        }
        this.annotationMap = annotationMap;
        this.annotationSet = new HashSet<Annotation>();
        this.metaAnnotationMap = new SetHashMultiMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotationMap.values()) {
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (!AnnotatedItem.MAPPED_METAANNOTATIONS.contains(metaAnnotation.annotationType())) continue;
                this.metaAnnotationMap.put(metaAnnotation.annotationType(), annotation);
            }
            this.annotationSet.add(annotation);
        }
        if (declaredAnnotationMap == null) {
            throw new NullPointerException("declaredAnnotationMap cannot be null");
        }
        this.declaredAnnotationMap = declaredAnnotationMap;
        this.declaredAnnotationSet = new HashSet<Annotation>();
        this.declaredMetaAnnotationMap = new SetHashMultiMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : declaredAnnotationMap.values()) {
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (!AnnotatedItem.MAPPED_METAANNOTATIONS.contains(metaAnnotation.annotationType())) continue;
                this.declaredMetaAnnotationMap.put(metaAnnotation.annotationType(), annotation);
            }
            this.declaredAnnotationSet.add(annotation);
        }
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotationSet);
    }

    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet((Set)this.metaAnnotationMap.get(metaAnnotationType));
    }

    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet((Set)this.declaredMetaAnnotationMap.get(metaAnnotationType));
    }

    public Annotation[] getMetaAnnotationsAsArray(Class<? extends Annotation> metaAnnotationType) {
        return this.getMetaAnnotations(metaAnnotationType).toArray(EMPTY_ANNOTATION_ARRAY);
    }

    @Deprecated
    public Set<Annotation> getBindings() {
        if (this.getMetaAnnotations(BindingType.class).size() > 0) {
            return Collections.unmodifiableSet(this.getMetaAnnotations(BindingType.class));
        }
        return Collections.unmodifiableSet(DEFAULT_BINDING);
    }

    @Deprecated
    public Annotation[] getBindingsAsArray() {
        return this.getBindings().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public <A extends Annotation> A getAnnotation(Class<? extends A> annotationType) {
        return (A)((Annotation)annotationType.cast(this.annotationMap.get(annotationType)));
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    public boolean isDeclaredAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.declaredAnnotationMap.containsKey(annotationType);
    }

    Map<Class<? extends Annotation>, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }

    Map<Class<? extends Annotation>, Annotation> getDeclaredAnnotationMap() {
        return this.declaredAnnotationMap;
    }
}

