/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.ExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationImpl<T extends Annotation>
implements Annotation {
    private final Class<T> annotationType;
    private final Method[] members;

    public AnnotationImpl(Class<T> annotationType, Method[] members) {
        this.annotationType = annotationType;
        this.members = members;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public String toString() {
        String string = "@" + this.annotationType().getName() + "(";
        for (int i = 0; i < this.members.length; ++i) {
            string = string + this.members[i].getName() + "=";
            string = string + AnnotationImpl.invoke(this.members[i], this);
            if (i >= this.members.length - 1) continue;
            string = string + ",";
        }
        return string + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Annotation) {
            Annotation that = (Annotation)other;
            if (this.annotationType().equals(that.annotationType())) {
                for (Method member : this.members) {
                    Object thatValue;
                    Object thisValue = AnnotationImpl.invoke(member, this);
                    if (thisValue.equals(thatValue = AnnotationImpl.invoke(member, that))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Method member : this.members) {
            int memberNameHashCode = 127 * member.getName().hashCode();
            int memberValueHashCode = AnnotationImpl.invoke(member, this).hashCode();
            hashCode += memberNameHashCode ^ memberValueHashCode;
        }
        return hashCode;
    }

    private static Object invoke(Method method, Object instance) {
        try {
            method.setAccessible(true);
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
    }
}

