/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.DefaultValidationProviderResolver;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validation.engine.ConstraintValidatorFactoryImpl;
import org.hibernate.validation.engine.DefaultTraversableResolver;
import org.hibernate.validation.engine.HibernateValidatorConfiguration;
import org.hibernate.validation.engine.ResourceBundleMessageInterpolator;
import org.hibernate.validation.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
implements HibernateValidatorConfiguration,
ConfigurationState {
    private static final MessageInterpolator defaultMessageInterpolator;
    private static final TraversableResolver defaultTraversableResolver;
    private MessageInterpolator messageInterpolator;
    private ConstraintValidatorFactory constraintValidatorFactory = new ConstraintValidatorFactoryImpl();
    private String configurationFile = "META-INF/validation.xml";
    private final ValidationProvider provider;
    private final ValidationProviderResolver providerResolver;
    private TraversableResolver traversableResolver;
    private boolean ignoreXmlConfiguration;

    public ConfigurationImpl(BootstrapState state) {
        this.providerResolver = state.getValidationProviderResolver() == null ? new DefaultValidationProviderResolver() : state.getValidationProviderResolver();
        this.provider = null;
        this.messageInterpolator = defaultMessageInterpolator;
        this.traversableResolver = defaultTraversableResolver;
    }

    public ConfigurationImpl(ValidationProvider provider) {
        if (provider == null) {
            throw new ValidationException("Assertion error: inconsistent ConfigurationImpl construction");
        }
        this.provider = provider;
        this.providerResolver = null;
        this.messageInterpolator = defaultMessageInterpolator;
        this.traversableResolver = defaultTraversableResolver;
    }

    @Override
    public HibernateValidatorConfiguration ignoreXmlConfiguration() {
        return null;
    }

    @Override
    public ConfigurationImpl messageInterpolator(MessageInterpolator interpolator) {
        this.messageInterpolator = interpolator;
        return this;
    }

    @Override
    public ConfigurationImpl traversableResolver(TraversableResolver resolver) {
        this.traversableResolver = resolver;
        return this;
    }

    @Override
    public ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    @Override
    public HibernateValidatorConfiguration addMapping(InputStream stream) {
        return null;
    }

    @Override
    public HibernateValidatorConfiguration addProperty(String name, String value) {
        return null;
    }

    @Override
    public ValidatorFactory buildValidatorFactory() {
        if (this.isSpecificProvider()) {
            return this.provider.buildValidatorFactory(this);
        }
        Class<Configuration<?>> providerClass = null;
        if (providerClass != null) {
            for (ValidationProvider provider : this.providerResolver.getValidationProviders()) {
                if (!provider.isSuitable(providerClass)) continue;
                return provider.buildValidatorFactory(this);
            }
            throw new ValidationException("Unable to find provider: " + providerClass);
        }
        List<ValidationProvider> providers = this.providerResolver.getValidationProviders();
        assert (providers.size() != 0);
        return providers.get(0).buildValidatorFactory(this);
    }

    private boolean isSpecificProvider() {
        return this.provider != null;
    }

    @Override
    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    @Override
    public Set<InputStream> getMappingStreams() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    @Override
    public Map<String, String> getProperties() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public MessageInterpolator getDefaultMessageInterpolator() {
        return defaultMessageInterpolator;
    }

    static {
        Version.touch();
        defaultMessageInterpolator = new ResourceBundleMessageInterpolator();
        defaultTraversableResolver = new DefaultTraversableResolver();
    }
}

