/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.impl.EntityManagerWrapper;
import com.sun.enterprise.container.common.impl.FactoryForEntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.impl.MailNamingObjectFactory;
import com.sun.enterprise.container.common.spi.EjbNamingReferenceManager;
import com.sun.enterprise.container.common.spi.WebServiceReferenceManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.naming.spi.NamingObjectFactory;
import com.sun.enterprise.naming.spi.NamingUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.JNDIBinding;
import org.glassfish.api.naming.NamingObjectProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ComponentEnvManagerImpl
implements ComponentEnvManager {
    private static final String JAVA_COMP_STRING = "java:comp/env/";
    private static final String EIS_STRING = "/eis/";
    @Inject
    private Habitat habitat;
    @Inject
    private Logger _logger;
    @Inject
    GlassfishNamingManager namingManager;
    @Inject
    private NamingUtils namingUtils;
    @Inject
    private InvocationManager invMgr;
    @Inject(optional=true)
    private EjbNamingReferenceManager ejbRefMgr;
    private Map<String, JndiNameEnvironment> compId2Env = new ConcurrentHashMap<String, JndiNameEnvironment>();
    private static final String ID_SEPARATOR = "_";

    public void register(String componentId, JndiNameEnvironment env) {
        this.compId2Env.put(componentId, env);
    }

    public void unregister(String componentId) {
        this.compId2Env.remove(componentId);
    }

    @Override
    public JndiNameEnvironment getJndiNameEnvironment(String componentId) {
        return this.compId2Env.get(componentId);
    }

    @Override
    public JndiNameEnvironment getCurrentJndiNameEnvironment() {
        JndiNameEnvironment desc = null;
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        if (inv != null && inv.componentId != null) {
            desc = this.compId2Env.get(inv.componentId);
        }
        return desc;
    }

    @Override
    public String bindToComponentNamespace(JndiNameEnvironment env) throws NamingException {
        String compEnvId = this.getComponentEnvId(env);
        Collection<JNDIBinding> bindings = this.getJNDIBindings(env);
        this.namingManager.bindToComponentNamespace(this.getApplicationName(env), compEnvId, bindings);
        this.register(compEnvId, env);
        return compEnvId;
    }

    @Override
    public void unbindFromComponentNamespace(JndiNameEnvironment env) throws NamingException {
        String compEnvId = this.getComponentEnvId(env);
        this.namingManager.unbindObjects(compEnvId);
        this.unregister(compEnvId);
    }

    public Collection<JNDIBinding> getJNDIBindings(JndiNameEnvironment env) {
        Object value;
        String name;
        ArrayList<JNDIBinding> jndiBindings = new ArrayList<JNDIBinding>();
        for (EnvironmentProperty next : env.getEnvironmentProperties()) {
            if (!next.hasAValue()) continue;
            name = JAVA_COMP_STRING + next.getName();
            value = next.getValueObject();
            jndiBindings.add(new CompEnvBinding(name, this.namingUtils.createSimpleNamingObjectFactory(name, value)));
        }
        for (EnvironmentProperty next : env.getJmsDestinationReferenceDescriptors()) {
            jndiBindings.add(this.getCompEnvBinding((JmsDestinationReferenceDescriptor)next));
        }
        for (EnvironmentProperty next : env.getEjbReferenceDescriptors()) {
            name = JAVA_COMP_STRING + next.getName();
            EjbReferenceProxy proxy = new EjbReferenceProxy(this.ejbRefMgr, (EjbReferenceDescriptor)next);
            jndiBindings.add(new CompEnvBinding(name, proxy));
        }
        for (EnvironmentProperty next : env.getMessageDestinationReferenceDescriptors()) {
            jndiBindings.add(this.getCompEnvBinding((MessageDestinationReferenceDescriptor)next));
        }
        for (ResourceReferenceDescriptor resourceRef : env.getResourceReferenceDescriptors()) {
            name = JAVA_COMP_STRING + resourceRef.getName();
            value = null;
            String physicalJndiName = resourceRef.getJndiName();
            if (resourceRef.isMailResource()) {
                value = new MailNamingObjectFactory(name, physicalJndiName, this.namingUtils);
            } else if (resourceRef.isURLResource()) {
                URL obj = null;
                try {
                    obj = new URL(physicalJndiName);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                NamingObjectFactory factory = this.namingUtils.createSimpleNamingObjectFactory(name, (Object)obj);
                value = this.namingUtils.createCloningNamingObjectFactory(name, factory);
            } else if (resourceRef.isORB()) {
                value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
            } else if (resourceRef.isWebServiceContext()) {
                WebServiceReferenceManager wsRefMgr = (WebServiceReferenceManager)this.habitat.getByContract(WebServiceReferenceManager.class);
                if (wsRefMgr != null) {
                    value = wsRefMgr.getWSContextObject();
                } else {
                    this._logger.log(Level.SEVERE, "Cannot find the following class to proceed with @Resource WebServiceContext" + wsRefMgr + "Please confirm if webservices module is installed ");
                }
            } else {
                value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, true);
            }
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (EnvironmentProperty next : env.getEntityManagerFactoryReferenceDescriptors()) {
            name = JAVA_COMP_STRING + next.getName();
            value = new FactoryForEntityManagerFactoryWrapper(next.getUnitName(), this.invMgr, this);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (EnvironmentProperty next : env.getServiceReferenceDescriptors()) {
            name = JAVA_COMP_STRING + next.getName();
            value = new WebServiceRefProxy((ServiceReferenceDescriptor)next);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (EnvironmentProperty next : env.getEntityManagerReferenceDescriptors()) {
            name = JAVA_COMP_STRING + next.getName();
            value = new FactoryForEntityManagerWrapper((EntityManagerReferenceDescriptor)next, this.habitat);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        return jndiBindings;
    }

    private CompEnvBinding getCompEnvBinding(final JmsDestinationReferenceDescriptor next) {
        final String name = JAVA_COMP_STRING + next.getName();
        Object value = null;
        value = next.isEJBContext() ? new EjbContextProxy(next.getRefType()) : new NamingObjectFactory(){
            NamingObjectFactory delegate;
            {
                this.delegate = ComponentEnvManagerImpl.this.namingUtils.createLazyNamingObjectFactory(name, next.getJndiName(), true);
            }

            public boolean isCreateResultCacheable() {
                return true;
            }

            public Object create(Context ic) throws NamingException {
                try {
                    return this.delegate.create(ic);
                }
                catch (NamingException e) {
                    Object ref = ComponentEnvManagerImpl.this.habitat.getComponent(next.getRefType(), next.getMappedName());
                    if (ref != null) {
                        return ref;
                    }
                    throw e;
                }
            }
        };
        return new CompEnvBinding(name, value);
    }

    private CompEnvBinding getCompEnvBinding(MessageDestinationReferenceDescriptor next) {
        String name = JAVA_COMP_STRING + next.getName();
        String physicalJndiName = null;
        physicalJndiName = next.isLinkedToMessageDestination() ? next.getMessageDestination().getJndiName() : next.getJndiName();
        NamingObjectFactory value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, true);
        return new CompEnvBinding(name, value);
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        return JAVA_COMP_STRING + descriptor.getName();
    }

    private String getComponentEnvId(JndiNameEnvironment env) {
        String id = null;
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            String flattedJndiName = ejbEnv.getJndiName().replace('/', '.');
            EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
            id = ejbEnv.getApplication().getName() + ID_SEPARATOR + ejbBundle.getModuleDescriptor().getArchiveUri() + ID_SEPARATOR + ejbEnv.getName() + ID_SEPARATOR + flattedJndiName + ejbEnv.getUniqueId();
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            id = webEnv.getApplication().getName() + ID_SEPARATOR + webEnv.getContextRoot();
        } else if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            id = "client_" + appEnv.getName() + ID_SEPARATOR + appEnv.getMainClassName();
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this.getApplicationName(env) + "Component Id: " + id);
        }
        return id;
    }

    private String getApplicationName(JndiNameEnvironment env) {
        String appName = "";
        String moduleName = "";
        if (env instanceof EjbDescriptor) {
            EjbDescriptor ejbEnv = (EjbDescriptor)env;
            EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
            appName = "ejb [" + ejbEnv.getApplication().getRegistrationName();
            moduleName = ejbEnv.getName();
            appName = moduleName == null || moduleName.equals("") ? appName + "]" : appName + ":" + ejbEnv.getName() + "]";
        } else if (env instanceof WebBundleDescriptor) {
            WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
            appName = "web module [" + webEnv.getApplication().getRegistrationName();
            moduleName = webEnv.getContextRoot();
            appName = moduleName == null || moduleName.equals("") ? appName + "]" : appName + ":" + webEnv.getContextRoot() + "]";
        } else if (env instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
            appName = "client [" + appEnv.getName() + ":" + appEnv.getMainClassName() + "]";
        }
        return appName;
    }

    private static boolean isConnector(String logicalJndiName) {
        return logicalJndiName.indexOf(EIS_STRING) != -1;
    }

    private static class CompEnvBinding
    implements JNDIBinding {
        private String name;
        private Object value;

        CompEnvBinding(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private class EjbReferenceProxy
    implements NamingObjectProxy {
        private volatile EjbNamingReferenceManager ejbRefMgr;
        private EjbReferenceDescriptor ejbRef;

        EjbReferenceProxy(EjbNamingReferenceManager ejbRefMgr, EjbReferenceDescriptor ejbRef) {
            this.ejbRefMgr = ejbRefMgr;
            this.ejbRef = ejbRef;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            if (this.ejbRefMgr == null) {
                this.ejbRefMgr = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.habitat.getByContract(EjbNamingReferenceManager.class);
            }
            if (this.ejbRefMgr != null) {
                result = this.ejbRefMgr.resolveEjbReference(this.ejbRef, ctx);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve ejb reference " + this.ejbRef.getName() + " : " + this.ejbRef);
            }
            return result;
        }
    }

    private class WebServiceRefProxy
    implements NamingObjectProxy {
        private WebServiceReferenceManager wsRefMgr;
        private ServiceReferenceDescriptor serviceRef;

        WebServiceRefProxy(ServiceReferenceDescriptor servRef) {
            this.serviceRef = servRef;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            this.wsRefMgr = (WebServiceReferenceManager)ComponentEnvManagerImpl.this.habitat.getByContract(WebServiceReferenceManager.class);
            if (this.wsRefMgr != null) {
                result = this.wsRefMgr.resolveWSReference(this.serviceRef, ctx);
            } else {
                ComponentEnvManagerImpl.this._logger.log(Level.SEVERE, "Cannot find the following class to proceed with @WebServiceRef" + this.wsRefMgr + "Please confirm if webservices module is installed ");
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve webservice context of type " + this.serviceRef.getName());
            }
            return result;
        }
    }

    private class EjbContextProxy
    implements NamingObjectProxy {
        private volatile EjbNamingReferenceManager ejbRefMgr;
        private String contextType;

        EjbContextProxy(String contextType) {
            this.contextType = contextType;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            if (this.ejbRefMgr == null) {
                this.ejbRefMgr = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.habitat.getByContract(EjbNamingReferenceManager.class);
            }
            if (this.ejbRefMgr != null) {
                result = this.ejbRefMgr.getEJBContextObject(this.contextType);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve EJB context of type " + this.contextType);
            }
            return result;
        }
    }

    private class FactoryForEntityManagerWrapper
    implements NamingObjectProxy {
        private EntityManagerReferenceDescriptor refDesc;
        private Habitat habitat;

        FactoryForEntityManagerWrapper(EntityManagerReferenceDescriptor refDesc, Habitat habitat) {
            this.refDesc = refDesc;
            this.habitat = habitat;
        }

        public Object create(Context ctx) {
            EntityManagerWrapper emWrapper = (EntityManagerWrapper)this.habitat.getComponent(EntityManagerWrapper.class);
            emWrapper.initializeEMWrapper(this.refDesc.getUnitName(), this.refDesc.getPersistenceContextType(), this.refDesc.getProperties());
            return emWrapper;
        }
    }
}

