/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.DependAction;
import com.sun.pkg.client.DirAction;
import com.sun.pkg.client.FileAction;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.LicenseAction;
import com.sun.pkg.client.LinkAction;
import com.sun.pkg.client.SetAction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manifest {
    static final Manifest nullManifest = new Manifest();
    List<Action> actions = new ArrayList<Action>();
    Map<String, String> attrs = new HashMap<String, String>();

    public Manifest(Image img, Fmri pi) throws IOException {
        String line;
        File mfile = new File(pi.getPkgVersionDir(new File(img.getMetaDirectory(), "pkg")), "manifest");
        if (!mfile.exists()) {
            String line2;
            img.getLogger().log(Level.FINE, "downloadmanifest", pi.toString());
            HttpURLConnection urlc = img.getRepositoryURLConnection("manifest/0/" + pi.getURLPath(), pi);
            img.checkRepositoryConnection(urlc);
            BufferedReader ir = new BufferedReader(new InputStreamReader(urlc.getInputStream(), "ISO-8859-1"));
            new File(mfile.getParent()).mkdirs();
            BufferedWriter ow = new BufferedWriter(new FileWriter(mfile));
            ow.write("set name=fmri value=" + pi);
            ow.newLine();
            ow.write("set name=authority value=" + pi.getAuthority());
            ow.newLine();
            while ((line2 = ir.readLine()) != null) {
                if (line2.startsWith("#")) continue;
                ow.write(line2);
                ow.newLine();
            }
            ir.close();
            ow.close();
        }
        BufferedReader r = new BufferedReader(new FileReader(mfile));
        while ((line = r.readLine()) != null) {
            String[] tokens = line.split(" ");
            if (line.indexOf(34) != -1) {
                tokens = this.rejoin(tokens);
            }
            if (tokens.length < 1) continue;
            String ttype = tokens[0];
            if (ttype.equals("file")) {
                this.actions.add(new FileAction(img, pi, tokens));
                continue;
            }
            if (ttype.equals("depend")) {
                this.actions.add(new DependAction(img, tokens));
                continue;
            }
            if (ttype.equals("dir")) {
                this.actions.add(new DirAction(img, tokens));
                continue;
            }
            if (ttype.equals("link")) {
                this.actions.add(new LinkAction(img, tokens));
                continue;
            }
            if (ttype.equals("license")) {
                this.actions.add(new LicenseAction(img, pi, tokens));
                continue;
            }
            if (!ttype.equals("set")) continue;
            SetAction sa = new SetAction(img, tokens);
            this.actions.add(sa);
            this.attrs.put(sa.name, sa.value);
        }
    }

    private Manifest() {
    }

    private String[] rejoin(String[] list) {
        boolean inStr = false;
        ArrayList<String> nlist = new ArrayList<String>();
        String n = "";
        for (String i : list) {
            if (i.indexOf("=\"") != -1) {
                n = i.replaceAll("=\"", "=");
                if (n.endsWith("\"")) {
                    nlist.add(n.substring(0, n.length() - 1));
                    n = "";
                    continue;
                }
                inStr = true;
                continue;
            }
            if (i.endsWith("\"")) {
                n = n + " " + i.substring(0, i.length() - 1);
                nlist.add(n);
                n = "";
                inStr = false;
                continue;
            }
            if (inStr) {
                n = n + " " + i;
                continue;
            }
            nlist.add(i);
        }
        if (n.length() != 0) {
            throw new IllegalArgumentException("Unmatched \" in action");
        }
        return nlist.toArray(new String[0]);
    }

    List<Action> getActions() {
        return this.actions;
    }

    public <T extends Action> List<T> getActionsByType(Class<T> actionClass) {
        ArrayList<T> alist = new ArrayList<T>();
        for (Action a : this.actions) {
            if (!actionClass.isInstance(a)) continue;
            alist.add(actionClass.cast(a));
        }
        return alist;
    }

    Difference getDifference(Manifest origin) {
        if (origin == null) {
            origin = nullManifest;
        }
        Difference diff = new Difference();
        diff.added = new ArrayList<Action>(this.getActions());
        diff.added.removeAll(origin.getActions());
        diff.removed = new ArrayList<Action>(origin.getActions());
        diff.removed.removeAll(this.getActions());
        diff.changed = new ArrayList<Difference.ActionPair>();
        HashMap<Action, Action> sset = new HashMap<Action, Action>();
        for (Action a : this.getActions()) {
            sset.put(a, a);
        }
        HashMap<Action, Action> oset = new HashMap<Action, Action>();
        for (Action a : origin.getActions()) {
            oset.put(a, a);
        }
        ArrayList<Action> isect = new ArrayList<Action>(origin.getActions());
        isect.retainAll(this.getActions());
        for (Action a : isect) {
            Action oa;
            Action sa = (Action)sset.get(a);
            if (!sa.isDifferent(oa = (Action)oset.get(a)) && !(sa instanceof LicenseAction)) continue;
            diff.changed.add(new Difference.ActionPair(oa, sa));
        }
        return diff;
    }

    boolean hasDuplicates() {
        List<Action> acts = this.getActions();
        HashSet<Action> dup = new HashSet<Action>(acts);
        return dup.size() != acts.size();
    }

    public String getAttribute(String name) {
        return this.attrs.get(name);
    }

    public int getPackageSize() {
        int size = 0;
        for (Action a : this.getActions()) {
            size += a.getSize();
        }
        return size;
    }

    static class Difference {
        List<Action> added;
        List<Action> removed;
        List<ActionPair> changed;

        Difference() {
        }

        static class ActionPair {
            Action from;
            Action to;

            ActionPair(Action f, Action t) {
                this.from = f;
                this.to = t;
            }
        }
    }
}

