/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.AbstractModulesRegistryImpl;
import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import com.sun.enterprise.module.common_impl.ModuleId;
import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModuleDefinition;
import org.jvnet.hk2.osgiadapter.OSGiModuleId;
import org.jvnet.hk2.osgiadapter.OSGiModuleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiModulesRegistryImpl
extends AbstractModulesRegistryImpl
implements SynchronousBundleListener {
    BundleContext bctx;
    private PackageAdmin pa;
    private Map<ModuleChangeListener, BundleListener> moduleChangeListeners = new HashMap<ModuleChangeListener, BundleListener>();
    private Map<ModuleLifecycleListener, BundleListener> moduleLifecycleListeners = new HashMap<ModuleLifecycleListener, BundleListener>();

    OSGiModulesRegistryImpl(BundleContext bctx) {
        super(null);
        this.bctx = bctx;
        bctx.addBundleListener((BundleListener)this);
        for (Bundle b : bctx.getBundles()) {
            if (b.getLocation().equals("System Bundle")) continue;
            try {
                this.add(this.makeModule(b));
            }
            catch (Exception e) {
                Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "OSGiModulesRegistryImpl", "Not able convert bundle [{0}] having location [{1}] to module because of exception: {2}", new Object[]{b, b.getLocation(), e});
            }
        }
        ServiceReference ref = bctx.getServiceReference(PackageAdmin.class.getName());
        this.pa = (PackageAdmin)PackageAdmin.class.cast(bctx.getService(ref));
    }

    public void bundleChanged(BundleEvent event) {
        try {
            Bundle bundle = event.getBundle();
            switch (event.getType()) {
                case 1: {
                    this.add(this.makeModule(bundle));
                    break;
                }
                case 16: {
                    Module m = this.getModule(bundle);
                    if (m == null) break;
                    this.remove(m);
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "bundleChanged", "e = {0}", new Object[]{e});
        }
    }

    private Module makeModule(Bundle bundle) throws IOException, URISyntaxException {
        OSGiModuleDefinition md = this.makeModuleDef(bundle);
        OSGiModuleImpl m = new OSGiModuleImpl(this, bundle, md);
        return m;
    }

    private OSGiModuleDefinition makeModuleDef(Bundle bundle) throws IOException, URISyntaxException {
        OSGiModuleDefinition md = new OSGiModuleDefinition(bundle);
        return md;
    }

    protected synchronized void add(Module newModule) {
        super.add(newModule);
    }

    public synchronized void remove(Module module) {
        super.remove(module);
    }

    protected Module newModule(ModuleDefinition moduleDef) {
        String location = moduleDef.getLocations()[0].toString();
        try {
            File l;
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.FINE, "OSGiModulesRegistryImpl", "newModule", "location = {0}", location);
            }
            if ((l = new File(moduleDef.getLocations()[0])).isDirectory()) {
                location = "reference:" + location;
            }
            Bundle bundle = this.bctx.installBundle(location);
            return new OSGiModuleImpl(this, bundle, moduleDef);
        }
        catch (BundleException e) {
            Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "newModule", "Exception {0} while adding location = {1}", new Object[]{e, location});
            return null;
        }
    }

    public void parseInhabitants(Module module, String name, InhabitantsParser inhabitantsParser) throws IOException {
        ((OSGiModuleImpl)OSGiModuleImpl.class.cast(module)).parseInhabitants(name, inhabitantsParser);
    }

    public ModulesRegistry createChild() {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    public synchronized void detachAll() {
        for (Module m : this.modules.values()) {
            m.detach();
        }
    }

    public synchronized void shutdown() {
        for (Module m : this.modules.values()) {
            if (!((OSGiModuleImpl)OSGiModuleImpl.class.cast(m)).isTransientlyActive()) continue;
            m.stop();
        }
        this.modules.clear();
        for (Repository repo : this.repositories.values()) {
            try {
                repo.shutdown();
            }
            catch (Exception e) {
                java.util.logging.Logger.getAnonymousLogger().log(Level.SEVERE, "Error while closing repository " + repo, e);
            }
        }
    }

    public void setParentClassLoader(ClassLoader parent) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    public ClassLoader getParentClassLoader() {
        return Bundle.class.getClassLoader();
    }

    public ClassLoader getModulesClassLoader(final ClassLoader parent, Collection<ModuleDefinition> mds, URL[] urls) throws ResolveError {
        final ArrayList<ClassLoader> delegateCLs = new ArrayList<ClassLoader>();
        final ArrayList<Module> delegateModules = new ArrayList<Module>();
        for (ModuleDefinition md : mds) {
            Module m = this.makeModuleFor(md.getName(), md.getVersion());
            delegateModules.add(m);
            delegateCLs.add(m.getClassLoader());
        }
        return new URLClassLoader(urls != null ? urls : new URL[]{}, parent){

            @Override
            public URL[] getURLs() {
                ArrayList<URL> result = new ArrayList<URL>();
                if (parent instanceof URLClassLoader) {
                    URL[] parentURLs = ((URLClassLoader)URLClassLoader.class.cast(parent)).getURLs();
                    result.addAll(Arrays.asList(parentURLs));
                }
                for (Module m : delegateModules) {
                    ModuleDefinition md = m.getModuleDefinition();
                    URI[] uris = md.getLocations();
                    URL[] urls = new URL[uris.length];
                    for (int i = 0; i < uris.length; ++i) {
                        try {
                            urls[i] = uris[i].toURL();
                            continue;
                        }
                        catch (MalformedURLException e) {
                            Logger.logger.warning("Exception " + e + " while converting " + uris[i] + " to URL");
                        }
                    }
                    result.addAll(Arrays.asList(urls));
                }
                return result.toArray(new URL[0]);
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                for (ClassLoader delegate : delegateCLs) {
                    try {
                        return delegate.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
                throw new ClassNotFoundException(name);
            }

            @Override
            public URL findResource(String name) {
                URL resource = null;
                for (ClassLoader delegate : delegateCLs) {
                    resource = delegate.getResource(name);
                    if (resource == null) continue;
                    return resource;
                }
                return resource;
            }

            @Override
            public Enumeration<URL> findResources(String name) throws IOException {
                ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
                for (ClassLoader delegate : delegateCLs) {
                    Enumeration<URL> enumerator = delegate.getResources(name);
                    enumerators.add(enumerator);
                }
                return new CompositeEnumeration(enumerators);
            }
        };
    }

    public ClassLoader getModulesClassLoader(ClassLoader parent, Collection<ModuleDefinition> defs) throws ResolveError {
        return this.getModulesClassLoader(parent, defs, null);
    }

    public Module find(Class clazz) {
        Bundle b = this.pa.getBundle(clazz);
        if (b != null) {
            return this.getModule(b);
        }
        return null;
    }

    public PackageAdmin getPackageAdmin() {
        return this.pa;
    }

    public void addModuleChangeListener(final ModuleChangeListener listener, final OSGiModuleImpl module) {
        BundleListener bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == module.getBundle() && (event.getType() & 8) == 8) {
                    listener.changed((Module)module);
                }
            }
        };
        this.bctx.addBundleListener(bundleListener);
        this.moduleChangeListeners.put(listener, bundleListener);
    }

    public boolean removeModuleChangeListener(ModuleChangeListener listener) {
        BundleListener bundleListener = this.moduleChangeListeners.remove(listener);
        if (bundleListener != null) {
            this.bctx.removeBundleListener(bundleListener);
            return true;
        }
        return false;
    }

    public void register(final ModuleLifecycleListener listener) {
        BundleListener bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                switch (event.getType()) {
                    case 2: {
                        listener.moduleStarted(OSGiModulesRegistryImpl.this.getModule(event.getBundle()));
                        break;
                    }
                    case 4: {
                        listener.moduleStopped(OSGiModulesRegistryImpl.this.getModule(event.getBundle()));
                    }
                }
            }
        };
        this.bctx.addBundleListener(bundleListener);
        this.moduleLifecycleListeners.put(listener, bundleListener);
    }

    public void unregister(ModuleLifecycleListener listener) {
        BundleListener bundleListener = this.moduleLifecycleListeners.remove(listener);
        if (bundleListener != null) {
            this.bctx.removeBundleListener(bundleListener);
        }
    }

    Map<ModuleId, Module> getExistingModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    Module getModule(Bundle bundle) {
        return (Module)this.modules.get((Object)new OSGiModuleId(bundle));
    }
}

