/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CascadeTypes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipAccessor
extends MappingAccessor {
    private Boolean m_orphanRemoval;
    private boolean m_privateOwned;
    private CascadeTypes m_cascadeTypes;
    protected Class m_referenceClass;
    private Class m_targetEntity;
    private Enum m_fetch;
    private Enum m_joinFetch;
    private JoinTableMetadata m_joinTable;
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();
    private String m_targetEntityName;

    protected RelationshipAccessor(String string) {
        super(string);
    }

    protected RelationshipAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        this.m_fetch = annotation == null ? this.getDefaultFetchType() : (Enum)MetadataHelper.invokeMethod("fetch", annotation);
        this.m_targetEntity = annotation == null ? Void.TYPE : (Class)MetadataHelper.invokeMethod("targetEntity", annotation);
        CascadeTypes cascadeTypes = this.m_cascadeTypes = annotation == null ? null : new CascadeTypes((Enum[])MetadataHelper.invokeMethod("cascade", annotation), metadataAccessibleObject);
        if (this.isAnnotationPresent(JoinFetch.class)) {
            this.m_joinFetch = (Enum)MetadataHelper.invokeMethod("value", this.getAnnotation(JoinFetch.class));
        }
        this.m_privateOwned = this.isAnnotationPresent(PrivateOwned.class);
        if (this.isAnnotationPresent(JoinColumns.class)) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", this.getAnnotation(JoinColumns.class))) {
                this.m_joinColumns.add(new JoinColumnMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if (this.isAnnotationPresent(JoinColumn.class)) {
            this.m_joinColumns.add(new JoinColumnMetadata((Annotation)this.getAnnotation(JoinColumn.class), metadataAccessibleObject));
        }
        if (this.isAnnotationPresent(JoinTable.class)) {
            this.m_joinTable = new JoinTableMetadata((Annotation)this.getAnnotation(JoinTable.class), metadataAccessibleObject);
        }
    }

    protected void addManyToManyRelationKeyFields(List<JoinColumnMetadata> list, ManyToManyMapping manyToManyMapping, String string, MetadataDescriptor metadataDescriptor, boolean bl) {
        String string2;
        String string3;
        if (bl) {
            string3 = "metadata_default_source_pk_column";
            string2 = "metadata_default_source_fk_column";
        } else {
            string3 = "metadata_default_target_pk_column";
            string2 = "metadata_default_target_fk_column";
        }
        for (JoinColumnMetadata joinColumnMetadata : list) {
            String string4 = metadataDescriptor.getPrimaryKeyFieldName();
            DatabaseField databaseField = joinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, string4, string3));
            databaseField.setTable(metadataDescriptor.getPrimaryKeyTable());
            DatabaseField databaseField2 = joinColumnMetadata.getForeignKeyField();
            String string5 = string + "_" + string4;
            databaseField2.setName(this.getName(databaseField2, string5, string2));
            databaseField2.setTable(manyToManyMapping.getRelationTable());
            if (bl) {
                manyToManyMapping.addSourceRelationKeyField(databaseField2, databaseField);
                continue;
            }
            manyToManyMapping.addTargetRelationKeyField(databaseField2, databaseField);
        }
    }

    public CascadeTypes getCascadeTypes() {
        return this.m_cascadeTypes;
    }

    @Override
    public abstract Enum getDefaultFetchType();

    public Enum getFetch() {
        return this.m_fetch;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    public JoinTableMetadata getJoinTable() {
        return this.m_joinTable;
    }

    protected abstract String getLoggingContext();

    public Boolean getOrphanRemoval() {
        return this.m_orphanRemoval;
    }

    protected DatabaseMapping getOwningMapping(String string) {
        MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
        DatabaseMapping databaseMapping = metadataDescriptor.getMappingForAttributeName(string, this);
        if (databaseMapping == null) {
            throw ValidationException.noMappedByAttributeFound((Class)metadataDescriptor.getJavaClass(), (String)string, (Class)this.getJavaClass(), (String)this.getAttributeName());
        }
        return databaseMapping;
    }

    public String getPrivateOwned() {
        return null;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        MetadataDescriptor metadataDescriptor;
        try {
            metadataDescriptor = super.getReferenceDescriptor();
        }
        catch (Exception exception) {
            metadataDescriptor = null;
        }
        if (metadataDescriptor == null || metadataDescriptor.isEmbeddable() || metadataDescriptor.isEmbeddableCollection()) {
            throw ValidationException.nonEntityTargetInRelationship((Class)this.getJavaClass(), (Class)this.getReferenceClass(), (AnnotatedElement)this.getAnnotatedElement());
        }
        return metadataDescriptor;
    }

    public Class getTargetEntity() {
        return this.m_targetEntity;
    }

    public String getTargetEntityName() {
        return this.m_targetEntityName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_joinColumns, metadataAccessibleObject);
        this.initXMLObject(this.m_joinTable, metadataAccessibleObject);
        this.initXMLObject(this.m_cascadeTypes, metadataAccessibleObject);
        this.m_targetEntity = this.initXMLClassName(this.m_targetEntityName);
    }

    public boolean isLazy() {
        Enum enum_ = this.getFetch();
        if (enum_ == null) {
            enum_ = this.getDefaultFetchType();
        }
        return enum_.name().equals(FetchType.LAZY.name());
    }

    public boolean isPrivateOwned() {
        return this.m_privateOwned;
    }

    protected void processCascadeTypes(ForeignReferenceMapping foreignReferenceMapping) {
        if (this.m_cascadeTypes != null) {
            for (Enum enum_ : this.m_cascadeTypes.getTypes()) {
                this.setCascadeType(enum_, foreignReferenceMapping);
            }
        }
        if (this.getDescriptor().isCascadePersist() && !foreignReferenceMapping.isCascadePersist()) {
            this.setCascadeType((Enum)CascadeType.PERSIST, foreignReferenceMapping);
        }
    }

    protected void processJoinTable(ManyToManyMapping manyToManyMapping) {
        if (this.m_joinTable == null) {
            this.m_joinTable = new JoinTableMetadata(null, this.getAccessibleObject());
        }
        String string = this.getDescriptor().getPrimaryTableName() + "_" + this.getReferenceDescriptor().getPrimaryTableName();
        this.processTable(this.m_joinTable, string);
        manyToManyMapping.setRelationTable(this.m_joinTable.getDatabaseTable());
        String string2 = this.getReferenceDescriptor().hasBiDirectionalManyToManyAccessorFor(this.getJavaClassName(), this.getAttributeName()) ? this.getReferenceDescriptor().getBiDirectionalManyToManyAccessor(this.getJavaClassName(), this.getAttributeName()).getAttributeName() : this.getDescriptor().getAlias();
        this.addManyToManyRelationKeyFields(this.getJoinColumns(this.m_joinTable.getJoinColumns(), this.getOwningDescriptor()), manyToManyMapping, string2, this.getOwningDescriptor(), true);
        String string3 = this.getAttributeName();
        this.addManyToManyRelationKeyFields(this.getJoinColumns(this.m_joinTable.getInverseJoinColumns(), this.getReferenceDescriptor()), manyToManyMapping, string3, this.getReferenceDescriptor(), false);
    }

    public void processRelationship() {
        if (!this.isProcessed()) {
            if (this.hasColumn()) {
                throw ValidationException.invalidColumnAnnotationOnRelationship((Class)this.getJavaClass(), (String)this.getAttributeName());
            }
            if (this.hasConvert(false)) {
                throw ValidationException.invalidMappingForConverter((Class)this.getJavaClass(), (Object)this.getAttributeName());
            }
            if (!(this.getTargetEntity() == ValueHolderInterface.class || this.getTargetEntity() == Void.TYPE && this.getReferenceClass().getName().equalsIgnoreCase(ValueHolderInterface.class.getName()))) {
                this.process();
            }
        }
    }

    @Override
    protected void setAccessorMethods(DatabaseMapping databaseMapping) {
        super.setAccessorMethods(databaseMapping);
        ((ForeignReferenceMapping)databaseMapping).setRequiresTransientWeavedFields(this.usesPropertyAccess(this.getDescriptor()) && !this.getClassAccessor().usesPropertyAccess());
    }

    protected void setCascadeType(Enum enum_, ForeignReferenceMapping foreignReferenceMapping) {
        if (enum_.name().equals(CascadeType.ALL.name())) {
            foreignReferenceMapping.setCascadeAll(true);
        } else if (enum_.name().equals(CascadeType.MERGE.name())) {
            foreignReferenceMapping.setCascadeMerge(true);
        } else if (enum_.name().equals(CascadeType.PERSIST.name())) {
            foreignReferenceMapping.setCascadePersist(true);
        } else if (enum_.name().equals(CascadeType.REFRESH.name())) {
            foreignReferenceMapping.setCascadeRefresh(true);
        } else if (enum_.name().equals(CascadeType.REMOVE.name())) {
            foreignReferenceMapping.setCascadeRemove(true);
        }
    }

    public void setCascadeTypes(CascadeTypes cascadeTypes) {
        this.m_cascadeTypes = cascadeTypes;
    }

    public void setFetch(Enum enum_) {
        this.m_fetch = enum_;
    }

    public void setJoinColumns(List<JoinColumnMetadata> list) {
        this.m_joinColumns = list;
    }

    public void setJoinFetch(Enum enum_) {
        this.m_joinFetch = enum_;
    }

    public void setJoinTable(JoinTableMetadata joinTableMetadata) {
        this.m_joinTable = joinTableMetadata;
    }

    public void setOrphanRemoval(Boolean bl) {
        this.m_orphanRemoval = bl;
    }

    public void setPrivateOwned(String string) {
        this.m_privateOwned = true;
    }

    public void setTargetEntity(Class clazz) {
        this.m_targetEntity = clazz;
    }

    public void setTargetEntityName(String string) {
        this.m_targetEntityName = string;
    }

    @Override
    protected boolean usesIndirection() {
        if (this.getProject().weaveEager()) {
            return true;
        }
        return this.isLazy();
    }
}

