/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListener;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethods;
import org.eclipse.persistence.internal.security.PrivilegedGetMethods;

public class EntityListenerMetadata
extends ORMetadata {
    private Class m_entityListenerClass;
    protected EntityListener m_listener;
    private String m_className;
    private String m_postLoad;
    private String m_postPersist;
    private String m_postRemove;
    private String m_postUpdate;
    private String m_prePersist;
    private String m_preRemove;
    private String m_preUpdate;

    public EntityListenerMetadata() {
        super("<entity-listener>");
    }

    public EntityListenerMetadata(Annotation annotation, Class clazz, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_entityListenerClass = clazz;
    }

    public Object clone() {
        EntityListenerMetadata entityListenerMetadata = new EntityListenerMetadata();
        entityListenerMetadata.setClassName(this.getClassName());
        entityListenerMetadata.setPostLoad(this.getPostLoad());
        entityListenerMetadata.setPostPersist(this.getPostPersist());
        entityListenerMetadata.setPostRemove(this.getPostRemove());
        entityListenerMetadata.setPostUpdate(this.getPostUpdate());
        entityListenerMetadata.setPrePersist(this.getPrePersist());
        entityListenerMetadata.setPreRemove(this.getPreRemove());
        entityListenerMetadata.setPreUpdate(this.getPreUpdate());
        return entityListenerMetadata;
    }

    protected Method getCallbackMethod(String string, Method[] methodArray) {
        Method method = this.getMethod(string, methodArray);
        if (method == null) {
            throw ValidationException.invalidCallbackMethod((Class)this.m_listener.getListenerClass(), (String)string);
        }
        return method;
    }

    Method[] getCandidateCallbackMethodsForEntityListener() {
        HashSet<Method> hashSet = new HashSet<Method>();
        Class clazz = this.m_listener.getListenerClass();
        Method[] methodArray = this.getDeclaredMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            hashSet.add(methodArray[i]);
        }
        Method[] methodArray2 = this.getMethods(clazz);
        for (int i = 0; i < methodArray2.length; ++i) {
            if (hashSet.contains(methodArray2[i])) continue;
            hashSet.add(methodArray2[i]);
        }
        return hashSet.toArray(new Method[hashSet.size()]);
    }

    Class getClassForName(String string, ClassLoader classLoader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ValidationException.unableToLoadClass((String)string, (Exception)privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName((String)string, (boolean)true, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.unableToLoadClass((String)string, (Exception)classNotFoundException);
        }
    }

    public String getClassName() {
        return this.m_className;
    }

    Method[] getDeclaredMethods(Class clazz) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(clazz));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredMethods((Class)clazz);
    }

    public String getIdentifier() {
        return this.m_className;
    }

    Method getMethod(String string, Method[] methodArray) {
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    Method[] getMethods(Class clazz) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetMethods(clazz));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethods((Class)clazz);
    }

    public String getPostLoad() {
        return this.m_postLoad;
    }

    public String getPostPersist() {
        return this.m_postPersist;
    }

    public String getPostRemove() {
        return this.m_postRemove;
    }

    public String getPostUpdate() {
        return this.m_postUpdate;
    }

    public String getPrePersist() {
        return this.m_prePersist;
    }

    public String getPreRemove() {
        return this.m_preRemove;
    }

    public String getPreUpdate() {
        return this.m_preUpdate;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.m_entityListenerClass = this.initXMLClassName(this.m_className);
    }

    public void process(MetadataDescriptor metadataDescriptor, ClassLoader classLoader, boolean bl) {
        if (this.m_entityListenerClass == null) {
            this.m_entityListenerClass = this.getClassForName(this.m_className, classLoader);
        }
        this.m_listener = new EntityListener(this.getClassForName(this.m_entityListenerClass.getName(), classLoader), metadataDescriptor.getJavaClass());
        this.processCallbackMethods(this.getCandidateCallbackMethodsForEntityListener(), metadataDescriptor);
        if (bl) {
            metadataDescriptor.addDefaultEventListener(this.m_listener);
        } else {
            metadataDescriptor.addEntityListenerEventListener(this.m_listener);
        }
    }

    protected void processCallbackMethods(Method[] methodArray, MetadataDescriptor metadataDescriptor) {
        if (this.m_postLoad != null) {
            this.setPostLoad(this.getCallbackMethod(this.m_postLoad, methodArray));
        }
        if (this.m_postPersist != null) {
            this.setPostPersist(this.getCallbackMethod(this.m_postPersist, methodArray));
        }
        if (this.m_postRemove != null) {
            this.setPostRemove(this.getCallbackMethod(this.m_postRemove, methodArray));
        }
        if (this.m_postUpdate != null) {
            this.setPostUpdate(this.getCallbackMethod(this.m_postUpdate, methodArray));
        }
        if (this.m_prePersist != null) {
            this.setPrePersist(this.getCallbackMethod(this.m_prePersist, methodArray));
        }
        if (this.m_preRemove != null) {
            this.setPreRemove(this.getCallbackMethod(this.m_preRemove, methodArray));
        }
        if (this.m_preUpdate != null) {
            this.setPreUpdate(this.getCallbackMethod(this.m_preUpdate, methodArray));
        }
        for (Method method : methodArray) {
            MetadataMethod metadataMethod = new MetadataMethod(method, metadataDescriptor.getLogger());
            if (metadataMethod.isAnnotationPresent(PostLoad.class, metadataDescriptor)) {
                this.setPostLoad(method);
            }
            if (metadataMethod.isAnnotationPresent(PostPersist.class, metadataDescriptor)) {
                this.setPostPersist(method);
            }
            if (metadataMethod.isAnnotationPresent(PostRemove.class, metadataDescriptor)) {
                this.setPostRemove(method);
            }
            if (metadataMethod.isAnnotationPresent(PostUpdate.class, metadataDescriptor)) {
                this.setPostUpdate(method);
            }
            if (metadataMethod.isAnnotationPresent(PrePersist.class, metadataDescriptor)) {
                this.setPrePersist(method);
            }
            if (metadataMethod.isAnnotationPresent(PreRemove.class, metadataDescriptor)) {
                this.setPreRemove(method);
            }
            if (!metadataMethod.isAnnotationPresent(PreUpdate.class, metadataDescriptor)) continue;
            this.setPreUpdate(method);
        }
    }

    public void setClassName(String string) {
        this.m_className = string;
    }

    protected void setPostLoad(Method method) {
        this.m_listener.setPostCloneMethod(method);
        this.m_listener.setPostRefreshMethod(method);
    }

    public void setPostLoad(String string) {
        this.m_postLoad = string;
    }

    protected void setPostPersist(Method method) {
        this.m_listener.setPostInsertMethod(method);
    }

    public void setPostPersist(String string) {
        this.m_postPersist = string;
    }

    protected void setPostRemove(Method method) {
        this.m_listener.setPostDeleteMethod(method);
    }

    public void setPostRemove(String string) {
        this.m_postRemove = string;
    }

    protected void setPostUpdate(Method method) {
        this.m_listener.setPostUpdateMethod(method);
    }

    public void setPostUpdate(String string) {
        this.m_postUpdate = string;
    }

    protected void setPrePersist(Method method) {
        this.m_listener.setPrePersistMethod(method);
    }

    public void setPrePersist(String string) {
        this.m_prePersist = string;
    }

    protected void setPreRemove(Method method) {
        this.m_listener.setPreRemoveMethod(method);
    }

    public void setPreRemove(String string) {
        this.m_preRemove = string;
    }

    protected void setPreUpdate(Method method) {
        this.m_listener.setPreUpdateWithChangesMethod(method);
    }

    public void setPreUpdate(String string) {
        this.m_preUpdate = string;
    }
}

