/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultCallbackHandler;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.UDPSelectorHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadUnit;
import com.sun.grizzly.async.AsyncQueueReadable;
import com.sun.grizzly.async.AsyncQueueWritable;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.async.ByteBufferCloner;
import com.sun.grizzly.util.DefaultThreadPool;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPConnectorHandler
implements ConnectorHandler<UDPSelectorHandler, CallbackHandler>,
AsyncQueueWritable,
AsyncQueueReadable {
    protected UDPSelectorHandler selectorHandler;
    protected CallbackHandler callbackHandler;
    protected DatagramChannel datagramChannel;
    protected volatile boolean isConnected;
    protected Controller controller;
    protected CountDownLatch isConnectedLatch;
    private boolean isStandalone = false;
    protected InputReader inputStream;

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.connect(remoteAddress, localAddress, callbackHandler, (UDPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler, UDPSelectorHandler selectorHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler, selectorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, UDPSelectorHandler selectorHandler) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        if (selectorHandler == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.selectorHandler = selectorHandler;
        if (callbackHandler == null) {
            callbackHandler = new DefaultCallbackHandler(this);
        } else {
            this.callbackHandler = callbackHandler;
        }
        UDPConnectorHandler uDPConnectorHandler = this;
        synchronized (uDPConnectorHandler) {
            this.isConnectedLatch = new CountDownLatch(1);
            selectorHandler.connect(remoteAddress, localAddress, callbackHandler);
        }
        try {
            this.isConnectedLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            this.isStandalone = true;
            this.controller = new Controller();
            this.controller.setSelectorHandler(new UDPSelectorHandler(true));
            DefaultThreadPool threadPool = new DefaultThreadPool();
            this.controller.setThreadPool((ExecutorService)threadPool);
            final CountDownLatch latch = new CountDownLatch(1);
            this.controller.addStateListener(new ControllerStateListenerAdapter(){

                public void onReady() {
                    latch.countDown();
                }

                public void onException(Throwable e) {
                    latch.countDown();
                }
            });
            this.callbackHandler = new DefaultCallbackHandler(this, false);
            new WorkerThreadImpl("GrizzlyUDPConnectorHandler-Controller", (Runnable)this.controller).start();
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        this.connect(remoteAddress, localAddress, this.callbackHandler, (UDPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        SelectionKey key = this.datagramChannel.keyFor(this.selectorHandler.getSelector());
        if (blocking) {
            if (this.inputStream == null) {
                this.inputStream = new InputReader();
            }
            this.inputStream.setSelectionKey(key);
            this.inputStream.setChannelType(InputReader.ChannelType.DatagramChannel);
            int nRead = -1;
            try {
                try {
                    this.inputStream.read(byteBuffer);
                }
                catch (IOException ex) {
                    nRead = -1;
                    throw ex;
                }
                Object var7_6 = null;
                if (nRead != -1) return nRead;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (nRead != -1) return nRead;
                SelectionKeyHandler skh22 = this.selectorHandler.getSelectionKeyHandler();
                if (skh22 instanceof BaseSelectionKeyHandler) {
                    ((BaseSelectionKeyHandler)skh22).notifyRemotlyClose(key);
                }
                return nRead;
            }
            SelectionKeyHandler skh22 = this.selectorHandler.getSelectionKeyHandler();
            if (skh22 instanceof BaseSelectionKeyHandler) {
                ((BaseSelectionKeyHandler)skh22).notifyRemotlyClose(key);
            }
            return nRead;
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        int nRead = this.datagramChannel.read(byteBuffer);
        if (nRead == 0) {
            this.selectorHandler.register(key, 1);
        }
        return nRead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        int nWrite;
        SelectionKey key;
        block10: {
            if (!this.isConnected) {
                throw new NotYetConnectedException();
            }
            if (blocking) {
                throw new IllegalStateException("Blocking mode not supported");
            }
            if (this.callbackHandler == null) {
                throw new IllegalStateException("Non blocking write needs a CallbackHandler");
            }
            key = this.datagramChannel.keyFor(this.selectorHandler.getSelector());
            nWrite = -1;
            try {
                try {
                    nWrite = this.datagramChannel.write(byteBuffer);
                }
                catch (IOException ex) {
                    nWrite = -1;
                    throw ex;
                }
                Object var7_5 = null;
                if (nWrite != -1) break block10;
            }
            catch (Throwable throwable) {
                SelectionKeyHandler skh222;
                Object var7_6 = null;
                if (nWrite == -1 && (skh222 = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                    ((DefaultSelectionKeyHandler)skh222).notifyRemotlyClose(key);
                }
                throw throwable;
            }
            SelectionKeyHandler skh222 = this.selectorHandler.getSelectionKeyHandler();
            if (skh222 instanceof BaseSelectionKeyHandler) {
                ((DefaultSelectionKeyHandler)skh222).notifyRemotlyClose(key);
            }
        }
        if (nWrite == 0) {
            this.selectorHandler.register(key, 4);
        }
        return nWrite;
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        return this.readFromAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        return this.readFromAsyncQueue(buffer, callbackHandler, condition, null);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        return this.selectorHandler.getAsyncQueueReader().read(this.datagramChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, condition, readPostProcessor);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer) throws IOException {
        return this.writeToAsyncQueue(buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.writeToAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.writeToAsyncQueue(buffer, callbackHandler, writePreProcessor, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        return this.selectorHandler.getAsyncQueueWriter().write(this.datagramChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, writePreProcessor, cloner);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, writePreProcessor, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        return this.selectorHandler.getAsyncQueueWriter().write(this.datagramChannel.keyFor(this.selectorHandler.getSelector()), dstAddress, buffer, callbackHandler, writePreProcessor, cloner);
    }

    public long send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        return this.datagramChannel.send(byteBuffer, socketAddress);
    }

    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        SelectionKey key = this.datagramChannel.keyFor(this.selectorHandler.getSelector());
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        SocketAddress socketAddress = this.datagramChannel.receive(byteBuffer);
        return socketAddress;
    }

    @Override
    public void close() throws IOException {
        if (this.datagramChannel != null) {
            if (this.selectorHandler != null) {
                SelectionKey key = this.datagramChannel.keyFor(this.selectorHandler.getSelector());
                if (key == null) {
                    return;
                }
                this.selectorHandler.getSelectionKeyHandler().cancel(key);
            } else {
                this.datagramChannel.close();
            }
        }
        if (this.controller != null && this.isStandalone) {
            this.controller.stop();
            this.controller = null;
        }
        this.isStandalone = false;
        this.isConnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishConnect(SelectionKey key) throws IOException {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, "Finish connect");
        }
        this.datagramChannel = (DatagramChannel)key.channel();
        this.isConnected = this.datagramChannel.isConnected();
        UDPConnectorHandler uDPConnectorHandler = this;
        synchronized (uDPConnectorHandler) {
            if (this.isConnectedLatch != null) {
                this.isConnectedLatch.countDown();
            }
        }
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.UDP;
    }

    public boolean isConnected() {
        return this.isConnected && this.datagramChannel.isOpen();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public SelectableChannel getUnderlyingChannel() {
        return this.datagramChannel;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public UDPSelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }
}

