/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.LocalRemoteCommand;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Map;

public class RestartDomainCommand
extends LocalRemoteCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        long uptimeOldServer = this.getUptime();
        this.runRemoteCommand("restart-domain", new String[0]);
        this.waitForRestart(uptimeOldServer);
        logger.printMessage(strings.get("restartDomain.success"));
    }

    private long getUptime() throws CommandException {
        CLIRemoteCommand rc = this.runRemoteCommand("uptime", new String[0]);
        Map<String, String> map = rc.getMainAtts();
        String up = map.get("message");
        long up_ms = this.parseUptime(up);
        if (up_ms <= 0L) {
            throw new CommandException(strings.get("StopDomain.dasNotRunning"));
        }
        logger.printDebugMessage("server uptime: " + up_ms);
        return up_ms;
    }

    private long parseUptime(String up) {
        if (up == null || up.length() < 4) {
            return 0L;
        }
        int index = up.lastIndexOf(58);
        if (index < 0) {
            return 0L;
        }
        if (up.length() - index < 3) {
            return 0L;
        }
        try {
            return Long.parseLong(up.substring(index + 2));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private void waitForRestart(long uptimeOldServer) throws CommandException {
        long end = 90000L + System.currentTimeMillis();
        while (System.currentTimeMillis() < end) {
            try {
                Thread.sleep(300L);
                long up = this.getUptime();
                if (up <= 0L || up >= uptimeOldServer) continue;
                return;
            }
            catch (Exception e) {
            }
        }
        throw new CommandException(strings.get("restartDomain.noGFStart"));
    }
}

