/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.util;

import com.sun.mojarra.scales.util.PrettyUrlRequestWrapper;
import com.sun.mojarra.scales.util.UrlMatcher;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;

public class PrettyUrlPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    public static final String URL_PATTERNS_INIT_PARAM = "com.sun.mojarra.scales.urlPatterns";
    private Map<String, String> urlPatterns;

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            FacesContext context = event.getFacesContext();
            if (this.urlPatterns == null) {
                this.loadUrlPatterns(context);
            }
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            String uri = request.getRequestURI();
            String contextPath = request.getContextPath();
            if ((uri = uri.substring(contextPath.length())) != null) {
                for (Map.Entry<String, String> entry : this.urlPatterns.entrySet()) {
                    String urlPattern = entry.getKey().trim();
                    String viewId = entry.getValue().trim();
                    UrlMatcher um = new UrlMatcher(urlPattern);
                    Map<String, String> injections = um.getInjections(uri);
                    if (injections == null) continue;
                    for (Map.Entry<String, String> injection : injections.entrySet()) {
                        try {
                            String elExpression = injection.getKey();
                            String uriValue = injection.getValue();
                            ELContext elContext = context.getELContext();
                            ValueExpression ve = expressionFactory.createValueExpression(elContext, elExpression, Object.class);
                            if (ve == null) continue;
                            ve.setValue(elContext, expressionFactory.coerceToType((Object)URLDecoder.decode(uriValue, "UTF-8"), ve.getType(elContext)));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new FacesException((Throwable)e);
                        }
                    }
                    PrettyUrlRequestWrapper wrapper = new PrettyUrlRequestWrapper(request);
                    wrapper.setViewId(viewId);
                    context.getExternalContext().setRequest((Object)wrapper);
                    break;
                }
            }
        }
    }

    protected void loadUrlPatterns(FacesContext context) {
        if (this.urlPatterns == null) {
            this.urlPatterns = new HashMap<String, String>();
            String patternInitParam = context.getExternalContext().getInitParameter(URL_PATTERNS_INIT_PARAM);
            if (patternInitParam != null) {
                String[] entries;
                for (String entry : entries = patternInitParam.split("\n")) {
                    int index = entry.indexOf("=");
                    if (index <= -1) continue;
                    String templateName = entry.substring(0, index);
                    String pattern = entry.substring(index + 1);
                    this.urlPatterns.put(pattern.trim(), templateName.trim());
                }
            }
            if (this.urlPatterns.size() == 0) {
                System.out.println("Removing PhaseListener instance");
                LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
                Iterator i = factory.getLifecycleIds();
                while (i.hasNext()) {
                    Lifecycle lifecycle = factory.getLifecycle((String)i.next());
                    lifecycle.removePhaseListener((PhaseListener)this);
                }
            }
        }
    }

    public void afterPhase(PhaseEvent event) {
    }
}

