/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.ext;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.RuntimeMgr;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.intf.config.ConfigConfig;
import org.glassfish.admin.amx.intf.config.DomainConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListener;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListeners;
import org.glassfish.admin.amx.intf.config.grizzly.Protocol;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeMgrImpl
extends AMXImplBase {
    private final ApplicationRegistry appRegistry = (ApplicationRegistry)Globals.getDefaultHabitat().getComponent(ApplicationRegistry.class);
    private static final String ADMIN_LISTENER_NAME = "admin-listener";

    public RuntimeMgrImpl(ObjectName parent) {
        super(parent, RuntimeMgr.class);
    }

    public Map<String, String> getDeploymentConfigurations(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            throw new IllegalArgumentException(appName);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            for (Sniffer sniffer : appInfo.getSniffers()) {
                result.putAll(sniffer.getDeploymentConfigurations(appInfo.getSource()));
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void stopDomain() {
        this.executeREST("stop-domain");
    }

    private NetworkConfig networkConfig() {
        return (NetworkConfig)((ConfigConfig)((DomainConfig)this.getDomainRootProxy().child(DomainConfig.class)).getConfigs().getConfig().get("server-config")).getNetworkConfig().as(NetworkConfig.class);
    }

    private NetworkListener getAdminListener() {
        NetworkConfig network = this.networkConfig();
        NetworkListeners listeners = network.getNetworkListeners();
        Map listenersMap = listeners.getNetworkListener();
        NetworkListener listener = (NetworkListener)listenersMap.get(ADMIN_LISTENER_NAME);
        return listener;
    }

    private int getRESTPort() {
        return this.getAdminListener().resolveInteger("Port");
    }

    private String get_asadmin() {
        Protocol protocol = (Protocol)this.networkConfig().getProtocols().getProtocol().get(ADMIN_LISTENER_NAME);
        return protocol.getHttp().resolveAttribute("DefaultVirtualServer");
    }

    public String getRESTBaseURL() {
        Protocol protocol = (Protocol)this.networkConfig().getProtocols().getProtocol().get(ADMIN_LISTENER_NAME);
        String scheme = protocol.resolveBoolean("SecurityEnabled") != false ? "https" : "http";
        String host = "localhost";
        return scheme + "://" + "localhost" + ":" + this.getRESTPort() + "/" + this.get_asadmin() + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeREST(String cmd) {
        String result = null;
        HttpURLConnection conn = null;
        try {
            String url = this.getRESTBaseURL() + cmd;
            URL invoke = new URL(url);
            conn = (HttpURLConnection)invoke.openConnection();
            InputStream is = conn.getInputStream();
            result = RuntimeMgrImpl.toString((Object)is);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = ExceptionUtil.toString((Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }

    public Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(String datasourceClassName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Habitat habitat = Globals.getDefaultHabitat();
        if (habitat == null) {
            result.put("PropertyMapKey", null);
            result.put("ReasonFailedKey", "Habitat is null");
            return result;
        }
        try {
            ConnectorRuntime connRuntime = (ConnectorRuntime)habitat.getComponent(ConnectorRuntime.class, null);
            Map connProps = connRuntime.getConnectionDefinitionPropertiesAndDefaults(datasourceClassName);
            result.put("PropertyMapKey", connProps);
        }
        catch (ComponentException e) {
            result.put("PropertyMapKey", null);
            result.put("ReasonFailedKey", ExceptionUtil.toString((Throwable)e));
        }
        return result;
    }
}

