/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.AbstractMain;
import com.sun.enterprise.glassfish.bootstrap.ClassPathBuilder;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.logging.Logger;

public abstract class ASMainOSGi
extends AbstractMain {
    protected ClassLoader launcherCL;
    protected Logger logger;
    protected ASMainHelper helper;
    protected File glassfishDir;
    protected File domainDir;
    protected File fwDir;
    private String[] additionalJars = new String[0];

    public ASMainOSGi(Logger logger, String ... args) {
        this.logger = logger;
        this.glassfishDir = this.bootstrapFile.getParentFile().getParentFile();
        this.helper = new ASMainHelper(logger);
        this.helper.parseAsEnv(this.glassfishDir);
        this.domainDir = this.helper.getDomainRoot(new StartupContext(this.bootstrapFile, args));
        this.helper.verifyAndSetDomainRoot(this.domainDir);
        this.setFwDir();
        System.setProperty("hk2.startup.context.root", this.bootstrapFile.getParent());
    }

    protected abstract void setFwDir();

    public ASMainOSGi(String ... args) {
        this(Logger.getAnonymousLogger(), args);
    }

    protected abstract void addFrameworkJars(ClassPathBuilder var1) throws IOException;

    protected abstract void launchOSGiFW() throws Exception;

    public void run() {
        try {
            this.setSystemProperties();
            this.setupLauncherClassLoader();
            this.launchOSGiFW();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setSystemProperties() throws MalformedURLException, Exception {
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        URI installRootURI = new File(installRoot).toURI();
        System.setProperty("com.sun.aas.installRootURI", installRootURI.toString());
        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        URI instanceRootURI = new File(instanceRoot).toURI();
        System.setProperty("com.sun.aas.instanceRootURI", instanceRootURI.toString());
        System.setProperty("org.jvnet.hk2.osgimain.bundlesDir", new File(this.glassfishDir, "modules/").getAbsolutePath());
        if (System.getProperty("org.jvnet.hk2.osgimain.autostartBundles") == null) {
            String bundlePaths = "org.apache.felix.shell.jar, org.apache.felix.shell.remote.jar, org.apache.felix.configadmin.jar, org.apache.felix.fileinstall.jar, osgi-adapter.jar";
            System.setProperty("org.jvnet.hk2.osgimain.autostartBundles", "org.apache.felix.shell.jar, org.apache.felix.shell.remote.jar, org.apache.felix.configadmin.jar, org.apache.felix.fileinstall.jar, osgi-adapter.jar");
        }
    }

    private void setupLauncherClassLoader() throws Exception {
        ClassLoader extCL = ClassLoader.getSystemClassLoader().getParent();
        ClassPathBuilder cpb = new ClassPathBuilder(extCL);
        try {
            this.addFrameworkJars(cpb);
            this.addJDKToolsJar(cpb);
            this.findDerbyClient(cpb);
            File moduleDir = this.bootstrapFile.getParentFile();
            cpb.addGlob(moduleDir, this.additionalJars);
            this.launcherCL = cpb.create();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Thread.currentThread().setContextClassLoader(this.launcherCL);
    }

    protected void addJDKToolsJar(ClassPathBuilder cpb) {
        try {
            File jdkToolsJar = this.helper.getJDKToolsJar();
            if (jdkToolsJar.exists()) {
                cpb.addJar(jdkToolsJar);
            } else {
                this.logger.fine("JDK tools.jar does not exist at " + jdkToolsJar);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void findDerbyClient(ClassPathBuilder cpb) throws IOException {
        String derbyHome = System.getProperty("AS_DERBY_INSTALL");
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "../db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.info("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        cpb.addGlob(derbyLib, "derby*.jar");
    }

    long getSettingsLastModification() {
        return this.getLastModified(this.fwDir, 0L);
    }

    Logger getLogger() {
        return this.logger;
    }

    boolean createCache(File cacheDir) throws IOException {
        return cacheDir.mkdirs();
    }
}

