/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.admin.cli.optional.BaseLifeCycleCommand;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.admin.cli.remote.CommandInvoker;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;

public class AsadminLoginCommand
extends BaseLifeCycleCommand {
    private String adminUser = null;
    private String adminPassword = null;

    public void runCommand() throws CommandException, CommandValidationException {
        super.validateOptions();
        this.setOption("interactive", "true");
        this.adminUser = this.getAdminUser();
        if (this.adminUser == null || this.adminUser.length() == 0) {
            this.adminUser = "anonymous";
            this.adminPassword = "";
        } else {
            this.adminPassword = this.adminUser.equals("anonymous") && (this.adminPassword == null || this.adminPassword.length() == 0) ? "" : this.getAdminPassword();
        }
        this.setOption("user", this.adminUser);
        this.setOption("password", this.adminPassword);
        if (!this.verifyAuth()) {
            throw new CommandException(this.getLocalizedString("InvalidCredentials", new Object[]{this.adminUser}));
        }
        String portStr = this.getOption("port");
        int port = portStr != null ? Integer.parseInt(portStr) : 4848;
        this.saveLogin(this.getOption("host"), port, this.adminUser, this.adminPassword);
    }

    private boolean verifyAuth() {
        CommandInvoker invoker = new CommandInvoker("version");
        invoker.put("port", "" + this.getOption("port"));
        invoker.put("user", this.adminUser);
        invoker.put("password", this.adminPassword);
        return CLIRemoteCommand.pingDASWithAuth((CommandInvoker)invoker);
    }

    private String getAdminPassword() throws CommandValidationException, CommandException {
        return this.getPassword("adminpassword", "AdminPasswordPrompt", "", true, false, false, false, null, null, true, false, false, true);
    }

    private void saveLogin(String host, int port, String user, String passwd) {
        block4: {
            CLILogger logger = CLILogger.getInstance();
            LoginInfo login = null;
            try {
                String msg;
                Object[] params;
                LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
                if (host == null || host.equals("")) {
                    host = "localhost";
                }
                if (store.exists((login = new LoginInfo(host, port, user, passwd)).getHost(), login.getPort())) {
                    params = new Object[]{login.getHost(), "" + login.getPort()};
                    msg = this.getLocalizedString("OverwriteLoginMsgCreateDomain", params);
                    logger.printMessage(msg);
                }
                store.store(login, true);
                params = new String[]{user, login.getHost(), "" + port, store.getName()};
                msg = this.getLocalizedString("LoginInfoStored", params);
                logger.printMessage(msg);
            }
            catch (Exception e) {
                Object[] params = new String[]{login.getHost(), "" + port};
                String msg = this.getLocalizedString("LoginInfoNotStored", params);
                logger.printWarning(msg);
                if (!logger.isDebug()) break block4;
                logger.printExceptionStackTrace((Throwable)e);
            }
        }
    }
}

