/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.jruby.RackGrizzlyAdapter;
import com.sun.grizzly.jruby.config.JRubyRuntimeConfig;
import com.sun.grizzly.jruby.rack.RackAdapter;
import com.sun.grizzly.jruby.rack.RackApplication;
import com.sun.grizzly.jruby.rack.RackApplicationFactory;
import com.sun.grizzly.jruby.rack.RackApplicationPoolAdapter;
import com.sun.grizzly.scripting.pool.DynamicPool;
import com.sun.grizzly.scripting.pool.DynamicPoolConfig;

public class SingleThreadedRackAdapter
implements RackAdapter {
    private final RackApplicationFactory myFactory;
    private final DynamicPoolConfig myConfig;
    private DynamicPool<RackApplication> pool;
    private final int numThreads;

    public SingleThreadedRackAdapter(RackApplicationFactory f, RackGrizzlyAdapter settings) {
        JRubyRuntimeConfig config = settings.config.runtimeConfig();
        this.myConfig = new DynamicPoolConfig(config.getInitRuntime(), -1, config.getMaxRuntime(), config.getMinRuntime(), -1, -1, -1, settings.async(), false);
        this.numThreads = settings.getNumThreads();
        this.myFactory = f;
        RackApplicationPoolAdapter adapter = new RackApplicationPoolAdapter(this.myFactory, settings);
        this.pool = new DynamicPool<RackApplication>(adapter, this.myConfig);
        this.pool.start(this.numThreads);
        settings.config.getListener().runtimePoolStartEvent(settings.config.runtimeConfig().getMinRuntime(), settings.config.runtimeConfig().getMaxRuntime(), this.myConfig.getNumberOfObjects(), settings.config.runtimeConfig().getMaxRuntime() - this.myConfig.getNumberOfObjects(), this.myConfig.getQueueThreashold(), this.myConfig.getDownThreashold(), this.myConfig.getNewThreashold());
    }

    public void shutdown() {
        this.myFactory.destroy();
        this.pool.stop();
    }

    public RackApplication getApp() {
        return this.pool.borrowObject();
    }

    public void returnApp(RackApplication returned) {
        this.pool.returnObject(returned);
    }

    public RackApplicationFactory getFactory() {
        return this.myFactory;
    }
}

