/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-system-properties")
@Scoped(value=PerLookup.class)
@I18n(value="list.system.properties")
public class ListSystemProperties
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListSystemProperties.class);
    @Param(optional=true, primary=true)
    String target = "server";
    @Inject
    Server[] servers;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            for (Server server : this.servers) {
                if (!server.getName().equals(this.target)) continue;
                List sysProps = server.getSystemProperty();
                if (sysProps.isEmpty()) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(localStrings.getLocalString("NothingToList", "Nothing to List."));
                    continue;
                }
                for (SystemProperty prop : sysProps) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(prop.getName() + "=" + prop.getValue());
                }
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.system.properties.failed", "list-system-properties failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

