/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;

public class BasicMapAccessor
extends BasicCollectionAccessor {
    private ColumnMetadata m_keyColumn;
    private String m_keyConverter;
    private String m_valueConverter;

    public BasicMapAccessor() {
        super("<basic-map>");
    }

    public BasicMapAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        this.m_keyColumn = new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("keyColumn", annotation), metadataAccessibleObject, this.getAttributeName());
        Annotation annotation2 = (Annotation)MetadataHelper.invokeMethod("keyConverter", annotation);
        this.m_keyConverter = (String)MetadataHelper.invokeMethod("value", annotation2);
        Annotation annotation3 = (Annotation)MetadataHelper.invokeMethod("valueConverter", annotation);
        this.m_valueConverter = (String)MetadataHelper.invokeMethod("value", annotation3);
        this.setValueColumn(new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("valueColumn", annotation), metadataAccessibleObject, this.getAttributeName()));
        this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", annotation));
    }

    protected ColumnMetadata getColumn(String string) {
        if (string.equals("metadata_default_value_column")) {
            return super.getColumn(string);
        }
        return this.m_keyColumn == null ? super.getColumn(string) : this.m_keyColumn;
    }

    protected String getDefaultCollectionTableName() {
        if (this.m_keyColumn != null && this.m_keyColumn.getTable() != null && !this.m_keyColumn.getTable().equals("")) {
            return this.m_keyColumn.getTable();
        }
        return super.getDefaultCollectionTableName();
    }

    public ColumnMetadata getKeyColumn() {
        return this.m_keyColumn;
    }

    public String getKeyConverter() {
        return this.m_keyConverter;
    }

    public Class getReferenceClass() {
        return this.getReferenceClassFromGeneric();
    }

    public String getValueConverter() {
        return this.m_valueConverter;
    }

    protected boolean hasConvert(boolean bl) {
        return true;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_keyColumn, metadataAccessibleObject);
    }

    public boolean isBasicMap() {
        return true;
    }

    public void process() {
        if (!this.isValidDirectMapType()) {
            throw ValidationException.invalidTypeForBasicMapAttribute((String)this.getAttributeName(), (Class)this.getRawClass(), (Class)this.getJavaClass());
        }
        this.processDirectMapMapping();
    }

    public void setKeyColumn(ColumnMetadata columnMetadata) {
        this.m_keyColumn = columnMetadata;
    }

    public void setKeyConverter(String string) {
        this.m_keyConverter = string;
    }

    public void setValueConverter(String string) {
        this.m_valueConverter = string;
    }
}

