/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.eclipse.persistence.internal.jpa.ExceptionFactory;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.internal.jpa.transaction.TransactionImpl;

public class TransactionManagerImpl
implements TransactionManager,
UserTransaction {
    TransactionImpl tx = null;

    private void debug(String string) {
        System.out.println(string);
    }

    public boolean isTransactionActive() {
        return this.tx != null;
    }

    public Connection getConnection(DataSourceImpl dataSourceImpl, String string, String string2) throws SQLException {
        return this.tx == null ? null : this.tx.getConnection(dataSourceImpl, string, string2);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.debug("Tx - begin");
        if (this.isTransactionActive()) {
            throw new ExceptionFactory().txActiveException();
        }
        this.tx = new TransactionImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.debug("Tx - commit");
        if (!this.isTransactionActive()) {
            throw new ExceptionFactory().txNotActiveException();
        }
        try {
            this.tx.commit();
        }
        finally {
            this.tx = null;
        }
    }

    public int getStatus() throws SystemException {
        return !this.isTransactionActive() ? 6 : this.tx.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.debug("Tx - rollback");
        if (!this.isTransactionActive()) {
            throw new ExceptionFactory().txNotActiveException();
        }
        try {
            this.tx.rollback();
        }
        finally {
            this.tx = null;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.debug("Tx - rollback");
        if (!this.isTransactionActive()) {
            throw new ExceptionFactory().txNotActiveException();
        }
        this.tx.setRollbackOnly();
    }

    public Transaction suspend() throws SystemException {
        return null;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
    }

    public void setTransactionTimeout(int n) throws SystemException {
    }
}

