/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Query;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.factories.SessionFactory;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

public class JpaHelper {
    public static boolean isEclipseLink(EntityManager entityManager) {
        return JpaHelper.getEntityManager(entityManager) != null;
    }

    public static boolean isEclipseLink(EntityManagerFactory entityManagerFactory) {
        try {
            JpaHelper.getEntityManagerFactory(entityManagerFactory);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public static boolean isEclipseLink(Query query) {
        return query instanceof JpaQuery;
    }

    public static boolean isReportQuery(Query query) {
        return JpaHelper.isEclipseLink(query) && JpaHelper.getDatabaseQuery(query).isReportQuery();
    }

    public static ReportQuery getReportQuery(Query query) {
        DatabaseQuery databaseQuery = JpaHelper.getDatabaseQuery(query);
        if (databaseQuery.isReportQuery()) {
            return (ReportQuery)databaseQuery;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_report_query" + query.getClass())));
    }

    public static DatabaseQuery getDatabaseQuery(Query query) {
        if (query instanceof JpaQuery) {
            return ((JpaQuery)query).getDatabaseQuery();
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_query" + query.getClass())));
    }

    public static ReadAllQuery getReadAllQuery(Query query) {
        DatabaseQuery databaseQuery = JpaHelper.getDatabaseQuery(query);
        if (databaseQuery.isReadAllQuery()) {
            return (ReadAllQuery)databaseQuery;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_read_all_query" + query.getClass())));
    }

    public static Query createQuery(DatabaseQuery databaseQuery, EntityManager entityManager) {
        return JpaHelper.getEntityManager(entityManager).createQuery(databaseQuery);
    }

    public static JpaEntityManager getEntityManager(EntityManager entityManager) {
        if (entityManager instanceof JpaEntityManager) {
            return (JpaEntityManager)entityManager;
        }
        if (entityManager.getDelegate() != null) {
            return JpaHelper.getEntityManager((JpaEntityManager)entityManager.getDelegate());
        }
        return null;
    }

    public static EntityManagerFactoryImpl getEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        if (entityManagerFactory instanceof EntityManagerFactoryImpl) {
            return (EntityManagerFactoryImpl)entityManagerFactory;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_entity_manager_factory" + entityManagerFactory.getClass())));
    }

    public static Server getServerSession(EntityManagerFactory entityManagerFactory) {
        return JpaHelper.getEntityManagerFactory(entityManagerFactory).getServerSession();
    }

    public static EntityManagerFactory createEntityManagerFactory(Server server) {
        return new EntityManagerFactoryImpl((ServerSession)server);
    }

    public static EntityManagerFactoryImpl createEntityManagerFactory(String string) {
        SessionFactory sessionFactory = new SessionFactory(string);
        return new EntityManagerFactoryImpl((ServerSession)sessionFactory.getSharedSession());
    }

    public static void loadUnfetchedObject(Object object) {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery(object);
        readObjectQuery.setShouldUseDefaultFetchGroup(false);
        Object object2 = ((FetchGroupTracker)object)._persistence_getSession().executeQuery((DatabaseQuery)readObjectQuery);
        if (object2 == null) {
            Object[] objectArray = new Object[]{readObjectQuery.getSelectionKey()};
            String string = ExceptionLocalization.buildMessage((String)"no_entities_retrieved_for_get_reference", (Object[])objectArray);
            throw new EntityNotFoundException(string);
        }
    }
}

