/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.jdbc.admin.cli.JDBCResourceManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-jdbc-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.jdbc.resource")
public class CreateJdbcResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJdbcResource.class);
    @Param(name="connectionpoolid")
    String connectionPoolId;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true)
    String description;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        JDBCResourceManager jdbcMgr = new JDBCResourceManager();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("jndi-name", this.jndiName);
        attrList.put("pool-name", this.connectionPoolId);
        attrList.put("description", this.description);
        attrList.put("enabled", this.enabled.toString());
        try {
            rs = jdbcMgr.create(this.resources, attrList, this.properties, targetServer);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.jdbc.resource.failed", "JDBC resource {0} creation failed", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() != null) {
                report.setMessage(rs.getMessage());
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

