/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.client;

import java.io.File;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.X509TrustManager;
import org.glassfish.admin.amx.client.TrustStoreTrustManager;

public final class TLSParams {
    private final X509TrustManager[] mTrustManagers;
    private final HandshakeCompletedListener mHandshakeCompletedListener;

    public static X509TrustManager[] getTrustManagers(File trustStore, char[] trustStorePassword, boolean prompt) {
        TrustStoreTrustManager mgr = new TrustStoreTrustManager(trustStore, trustStorePassword);
        mgr.setPrompt(prompt);
        X509TrustManager[] trustMgrs = new X509TrustManager[]{mgr};
        return trustMgrs;
    }

    public TLSParams(File trustStore, char[] trustStorePassword, boolean prompt, HandshakeCompletedListener handshakeCompletedListener) {
        this(TLSParams.getTrustManagers(trustStore, trustStorePassword, prompt), handshakeCompletedListener);
    }

    public TLSParams(X509TrustManager[] trustManagers, HandshakeCompletedListener handshakeCompletedListener) {
        if (trustManagers == null) {
            throw new IllegalArgumentException();
        }
        this.mTrustManagers = trustManagers;
        this.mHandshakeCompletedListener = handshakeCompletedListener;
    }

    public TLSParams(X509TrustManager trustManager, HandshakeCompletedListener handshakeCompletedListener) {
        this(new X509TrustManager[]{trustManager}, handshakeCompletedListener);
    }

    public X509TrustManager[] getTrustManagers() {
        return this.mTrustManagers;
    }

    public HandshakeCompletedListener getHandshakeCompletedListener() {
        return this.mHandshakeCompletedListener;
    }
}

