/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.CompareUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.TypeCast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapUtil {
    private MapUtil() {
    }

    public static <K, V> V getWithDefault(Map<K, V> m, K key, V defaultValue) {
        return m.containsKey(key) ? m.get(key) : defaultValue;
    }

    public static Object[] getKeyObjects(Map<?, ?> m) {
        Object[] keys = new Object[m.keySet().size()];
        m.keySet().toArray(keys);
        return keys;
    }

    public static String[] getKeyStrings(Map<?, ?> m) {
        return SetUtil.toSortedStringArray(m.keySet());
    }

    public static <K, V> Map<K, V> newMap() {
        return new HashMap();
    }

    public static <V> Map<String, V> newMap(String key, V value) {
        HashMap<String, V> m = new HashMap<String, V>();
        m.put(key, value);
        return m;
    }

    public static <K, V> Map<K, V> newMap(Map<K, V> m1, Map<K, V> m2) {
        HashMap<K, V> m = new HashMap<K, V>();
        if (m1 != null) {
            m.putAll(m1);
        }
        if (m2 != null) {
            m.putAll(m2);
        }
        return m;
    }

    private static <K, V> Map<K, V> toMap(Object[] params, Class<K> keyClass, Class<V> valueClass) {
        HashMap<K, V> m = new HashMap<K, V>();
        for (int i = 0; i < params.length; i += 2) {
            Object key = params[i];
            if (key == null) {
                throw new IllegalArgumentException();
            }
            if (!keyClass.isAssignableFrom(key.getClass())) {
                throw new IllegalArgumentException("Key of class " + key.getClass().getName() + " not assignable to " + keyClass.getName());
            }
            Object value = params[i + 1];
            if (value != null && !valueClass.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Value of class " + value.getClass().getName() + " not assignable to " + valueClass.getName());
            }
            m.put(keyClass.cast(key), valueClass.cast(value));
        }
        return m;
    }

    public static <T> Map<T, T> newMap(T ... mappings) {
        if (mappings.length % 2 != 0) {
            throw new IllegalArgumentException("mappings must have even length");
        }
        HashMap<T, T> m = new HashMap<T, T>();
        for (int i = 0; i < mappings.length; i += 2) {
            m.put(mappings[i], mappings[i + 1]);
        }
        return m;
    }

    public static Map<String, String> newMap(String ... mappings) {
        if (mappings.length % 2 != 0) {
            throw new IllegalArgumentException("mappings must have even length");
        }
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < mappings.length; i += 2) {
            m.put(mappings[i], mappings[i + 1]);
        }
        return m;
    }

    public static <T> void removeAll(Map<T, ?> m, T[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            m.remove(keys[i]);
        }
    }

    public static boolean mapsEqual(Map<?, ?> m1, Map<?, ?> m2) {
        if (m1 == m2) {
            return true;
        }
        boolean equal = false;
        if (m1.size() == m2.size() && ((Object)m1.keySet()).equals(m2.keySet())) {
            equal = true;
            for (Object key : m1.keySet()) {
                Object value2;
                Object value1 = m1.get(key);
                if (CompareUtil.objectsEqual(value1, value2 = m2.get(key))) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    public static <K, V> Map<K, V> newMapNoNullValues(Map<K, V> m) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (K key : m.keySet()) {
            V value = m.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String toString(Map<?, ?> m) {
        return MapUtil.toString(m, ",");
    }

    public static String toString(Map<?, ?> m, String separator) {
        String[] keyStrings;
        if (m == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        for (String key : keyStrings = MapUtil.getKeyStrings(m)) {
            Object value = m.get(key);
            buf.append(key);
            buf.append("=");
            buf.append(StringUtil.toString(value));
            buf.append(separator);
        }
        if (buf.length() != 0) {
            buf.setLength(buf.length() - separator.length());
        }
        return buf.toString();
    }

    public static <K> Set<K> getNullValueKeys(Map<K, ?> m) {
        HashSet<K> s = new HashSet<K>();
        for (K key : m.keySet()) {
            if (m.get(key) != null) continue;
            s.add(key);
        }
        return s;
    }

    public static <K, V> Map<K, V> toMap(Properties props, Class<K> kClass, Class<V> vClass) {
        return TypeCast.checkMap(props, kClass, vClass);
    }

    public static <K> void removeAll(Map<K, ?> m, Set<K> s) {
        for (K key : s) {
            m.remove(key);
        }
    }

    public static boolean isAllStrings(Map<?, ?> m) {
        return m != null && CollectionUtil.isAllStrings(m.keySet()) && CollectionUtil.isAllStrings(m.values());
    }

    public static Map<String, String> toStringStringMap(Map<?, ?> m) {
        if (m == null) {
            return null;
        }
        Map<String, String> result = null;
        if (MapUtil.isAllStrings(m)) {
            result = TypeCast.asMap(m);
        } else {
            result = new HashMap();
            for (Object key : m.keySet()) {
                Object value = m.get(key);
                if (key instanceof String && value instanceof String) {
                    result.put((String)key, (String)value);
                    continue;
                }
                result.put("" + key, "" + value);
            }
        }
        return result;
    }
}

