/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.FieldsLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;

public class SelectedFieldsLockingPolicy
extends FieldsLockingPolicy {
    protected Map lockFieldsByTable = new HashMap(5);
    protected Vector lockFields = NonSynchronizedVector.newInstance();

    public void addLockFieldName(String string) {
        this.getLockFields().addElement(new DatabaseField(string));
    }

    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        this.verifyUsage(objectLevelModifyQuery.getSession());
        Object object = objectLevelModifyQuery.isDeleteObjectQuery() ? objectLevelModifyQuery.getObject() : objectLevelModifyQuery.getBackupClone();
        Iterator iterator = this.getLockFieldsByTable().values().iterator();
        while (iterator.hasNext()) {
            Enumeration enumeration = ((Vector)iterator.next()).elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                DatabaseMapping databaseMapping = this.descriptor.getObjectBuilder().getMappingForField(databaseField);
                if (databaseMapping == null) {
                    throw DatabaseException.specifiedLockingFieldsNotFoundInDatabase(databaseField.getQualifiedName());
                }
                databaseMapping.writeFromObjectIntoRow(object, objectLevelModifyQuery.getTranslationRow(), objectLevelModifyQuery.getSession());
            }
        }
    }

    protected Vector getFieldsToCompare(DatabaseTable databaseTable, AbstractRecord abstractRecord, AbstractRecord abstractRecord2) {
        return this.getLockFields(databaseTable);
    }

    public Vector getLockFields() {
        return this.lockFields;
    }

    protected Vector getLockFields(DatabaseTable databaseTable) {
        Vector vector = (Vector)this.lockFieldsByTable.get(databaseTable);
        if (vector == null) {
            return new Vector();
        }
        return vector;
    }

    protected Map getLockFieldsByTable() {
        return this.lockFieldsByTable;
    }

    public void initialize(AbstractSession abstractSession) {
        super.initialize(abstractSession);
        Vector vector = this.getLockFields();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)vector.get(i);
            databaseField = this.descriptor.buildField(databaseField);
            vector.set(i, databaseField);
            Vector vector2 = (Vector)this.getLockFieldsByTable().get(databaseField.getTable());
            if (vector2 == null) {
                vector2 = NonSynchronizedVector.newInstance();
                this.getLockFieldsByTable().put(databaseField.getTable(), vector2);
            }
            vector2.addElement(databaseField);
        }
    }

    public void setLockFieldNames(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addLockFieldName((String)enumeration.nextElement());
        }
    }

    public void setLockFields(Map map) {
        this.lockFieldsByTable = map;
    }

    protected void setLockFields(Vector vector) {
        this.lockFields = vector;
    }

    protected void setLockFieldsByTable(Map map) {
        this.lockFieldsByTable = map;
    }
}

