/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class VersionLockingPolicy
implements OptimisticLockingPolicy,
Serializable {
    protected DatabaseField writeLockField;
    protected boolean isCascaded;
    protected int lockValueStored;
    protected ClassDescriptor descriptor;
    protected transient Expression cachedExpression;
    public static final int IN_CACHE = 1;
    public static final int IN_OBJECT = 2;
    protected AbstractDirectMapping lockMapping;

    public VersionLockingPolicy() {
        this.storeInCache();
    }

    public VersionLockingPolicy(String string) {
        this(new DatabaseField(string));
    }

    public VersionLockingPolicy(DatabaseField databaseField) {
        this();
        this.setWriteLockField(databaseField);
    }

    public void addLockFieldsToUpdateRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isStoredInCache()) {
            abstractRecord.put(this.getWriteLockField(), (Object)null);
        }
    }

    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery objectLevelModifyQuery) {
        Object object = this.isStoredInCache() ? objectLevelModifyQuery.getSession().getIdentityMapAccessorInstance().getWriteLockValue(objectLevelModifyQuery.getPrimaryKey(), objectLevelModifyQuery.getObject().getClass(), this.getDescriptor()) : this.lockValueFromObject(objectLevelModifyQuery.getObject());
        if (object == null) {
            if (objectLevelModifyQuery.isDeleteObjectQuery()) {
                throw OptimisticLockException.noVersionNumberWhenDeleting(objectLevelModifyQuery.getObject(), objectLevelModifyQuery);
            }
            throw OptimisticLockException.noVersionNumberWhenUpdating(objectLevelModifyQuery.getObject(), objectLevelModifyQuery);
        }
        objectLevelModifyQuery.getTranslationRow().put(this.writeLockField, object);
    }

    public Expression buildDeleteExpression(DatabaseTable databaseTable, Expression expression, AbstractRecord abstractRecord) {
        return this.buildUpdateExpression(databaseTable, expression, abstractRecord, null);
    }

    protected Expression buildExpression() {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        return expressionBuilder.getField(this.getWriteLockField()).equal(expressionBuilder.getParameter(this.getWriteLockField()));
    }

    public Expression buildUpdateExpression(DatabaseTable databaseTable, Expression expression, AbstractRecord abstractRecord, AbstractRecord abstractRecord2) {
        if (this.cachedExpression == null) {
            this.cachedExpression = this.buildExpression();
        }
        if (this.getWriteLockField().getTableName().equals(databaseTable.getName())) {
            return expression.and(this.cachedExpression);
        }
        return expression;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean supportsWriteLockValuesComparison() {
        return true;
    }

    public int compareWriteLockValues(Object object, Object object2) {
        long l;
        long l2 = ((Number)object).longValue();
        if (l2 < (l = ((Number)object2).longValue())) {
            return -1;
        }
        if (l2 == l) {
            return 0;
        }
        return 1;
    }

    protected Class getDefaultLockingFieldType() {
        return ClassConstants.LONG;
    }

    public Object getBaseValue() {
        return new Long(0L);
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected Object getInitialWriteValue(AbstractSession abstractSession) {
        return new Long(1L);
    }

    public Object getNewLockValue(ModifyQuery modifyQuery) {
        Class clazz = modifyQuery.getDescriptor().getJavaClass();
        Number number = null;
        Number number2 = this.isStoredInCache() ? (Number)((Number)modifyQuery.getSession().getIdentityMapAccessorInstance().getWriteLockValue(((WriteObjectQuery)modifyQuery).getPrimaryKey(), clazz, this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(((ObjectLevelModifyQuery)modifyQuery).getObject()));
        if (number2 == null) {
            throw OptimisticLockException.noVersionNumberWhenUpdating(((ObjectLevelModifyQuery)modifyQuery).getObject(), (ObjectLevelModifyQuery)modifyQuery);
        }
        number = this.incrementWriteLockValue(number2);
        return number;
    }

    protected Vector getUnmappedFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        if (this.isStoredInCache()) {
            vector.addElement(this.getWriteLockField());
        }
        return vector;
    }

    public Object getValueToPutInCache(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isStoredInCache()) {
            return abstractRecord.get(this.getWriteLockField());
        }
        return null;
    }

    public int getVersionDifference(Object object, Object object2, Vector vector, AbstractSession abstractSession) {
        Number number = (Number)object;
        if (number == null) {
            return 0;
        }
        Number number2 = this.isStoredInCache() ? (Number)((Number)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, object2.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(object2));
        if (number2 == null) {
            number2 = new Long(0L);
        }
        return (int)(number.longValue() - number2.longValue());
    }

    public DatabaseField getWriteLockField() {
        return this.writeLockField;
    }

    public String getWriteLockFieldName() {
        return this.getWriteLockField().getQualifiedName();
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder expressionBuilder, AbstractSession abstractSession) {
        return ExpressionMath.add(expressionBuilder.getField(this.writeLockField.getName()), 1);
    }

    public Object getWriteLockValue(Object object, Vector vector, AbstractSession abstractSession) {
        Number number = this.isStoredInCache() ? (Number)((Number)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(object));
        return number;
    }

    protected Number incrementWriteLockValue(Number number) {
        return new Long(number.longValue() + 1L);
    }

    public void initialize(AbstractSession abstractSession) {
        DatabaseMapping databaseMapping = this.descriptor.getObjectBuilder().getMappingForField(this.getWriteLockField());
        if (databaseMapping == null) {
            if (this.isStoredInObject()) {
                if (this.descriptor.getObjectBuilder().getReadOnlyMappingsForField(this.getWriteLockField()) != null) {
                    databaseMapping = this.descriptor.getObjectBuilder().getReadOnlyMappingsForField(this.getWriteLockField()).get(0);
                    abstractSession.getIntegrityChecker().handleError(DescriptorException.mappingCanNotBeReadOnly(databaseMapping));
                } else {
                    abstractSession.getIntegrityChecker().handleError(OptimisticLockException.mustHaveMappingWhenStoredInObject(this.descriptor.getJavaClass()));
                }
            } else {
                return;
            }
        }
        if (this.isStoredInCache()) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.mustBeReadOnlyMappingWhenStoredInCache(databaseMapping));
        }
        if (databaseMapping.isDirectToFieldMapping() && this.descriptor.getObjectBuilder().getReadOnlyMappingsForField(this.getWriteLockField()) == null) {
            this.lockMapping = (AbstractDirectMapping)databaseMapping;
        }
    }

    public void initializeProperties() {
        DatabaseField databaseField = this.getWriteLockField();
        databaseField = this.descriptor.buildField(databaseField);
        this.setWriteLockField(databaseField);
        if (this.isStoredInCache() && databaseField.getType() == null) {
            databaseField.setType(this.getDefaultLockingFieldType());
        }
        Enumeration enumeration = this.getUnmappedFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField2 = (DatabaseField)enumeration.nextElement();
            this.descriptor.getFields().addElement(databaseField2);
        }
    }

    public boolean isCascaded() {
        return this.isCascaded;
    }

    public boolean isChildWriteLockValueGreater(AbstractSession abstractSession, Vector vector, Class clazz, ObjectChangeSet objectChangeSet) {
        if (this.isStoredInCache()) {
            Number number = (Number)objectChangeSet.getWriteLockValue();
            Number number2 = (Number)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz, this.getDescriptor());
            if (number != null && (number2 == null || number2.longValue() < number.longValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNewerVersion(Object object, Object object2, Vector vector, AbstractSession abstractSession) {
        Number number = (Number)object;
        Number number2 = this.isStoredInCache() ? (Number)((Number)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, object2.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(object2));
        if (number2 == null) {
            return false;
        }
        if (number == null) {
            return true;
        }
        return number.longValue() > number2.longValue();
    }

    public boolean isNewerVersion(AbstractRecord abstractRecord, Object object, Vector vector, AbstractSession abstractSession) {
        Number number = (Number)abstractRecord.get(this.getWriteLockField());
        Number number2 = this.isStoredInCache() ? (Number)((Number)abstractSession.getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(object));
        if (number2 == null) {
            return false;
        }
        if (number == null) {
            return true;
        }
        return number.longValue() > number2.longValue();
    }

    public boolean isStoredInCache() {
        return this.lockValueStored == 1;
    }

    public boolean isStoredInObject() {
        return this.lockValueStored == 2;
    }

    protected Object lockValueFromObject(Object object) {
        if (this.lockMapping != null) {
            return this.lockMapping.getAttributeValueFromObject(object);
        }
        return this.descriptor.getObjectBuilder().getBaseValueForField(this.writeLockField, object);
    }

    public AbstractDirectMapping getVersionMapping() {
        if (this.lockMapping != null) {
            return this.lockMapping;
        }
        return (AbstractDirectMapping)this.descriptor.getObjectBuilder().getBaseMappingForField(this.writeLockField);
    }

    public void mergeIntoParentCache(UnitOfWorkImpl unitOfWorkImpl, Vector vector, Object object) {
        if (this.isStoredInCache()) {
            Object object2 = unitOfWorkImpl.getParent().getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor());
            unitOfWorkImpl.getIdentityMapAccessor().updateWriteLockValue(vector, object.getClass(), object2);
        }
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void setIsStoredInCache(boolean bl) {
        if (bl) {
            this.storeInCache();
        } else {
            this.storeInObject();
        }
    }

    public void setIsCascaded(boolean bl) {
        this.isCascaded = bl;
    }

    public void setupWriteFieldsForInsert(ObjectLevelModifyQuery objectLevelModifyQuery) {
        Object object = this.getInitialWriteValue(objectLevelModifyQuery.getSession());
        ObjectChangeSet objectChangeSet = objectLevelModifyQuery.getObjectChangeSet();
        if (objectChangeSet != null) {
            objectChangeSet.setInitialWriteLockValue(object);
        }
        this.updateWriteLockValueForWrite(objectLevelModifyQuery, object);
    }

    protected void updateWriteLockValueForWrite(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
        objectLevelModifyQuery.getModifyRow().put(this.writeLockField, object);
        this.updateObjectWithWriteValue(objectLevelModifyQuery, object);
    }

    public void updateObjectWithWriteValue(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
        AbstractSession abstractSession = objectLevelModifyQuery.getSession();
        Object object2 = objectLevelModifyQuery.getObject();
        ObjectChangeSet objectChangeSet = objectLevelModifyQuery.getObjectChangeSet();
        if (objectChangeSet == null && abstractSession.isUnitOfWork() && ((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet() != null) {
            objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object2);
        }
        if (this.lockMapping != null) {
            this.lockMapping.setAttributeValueInObject(object2, this.lockMapping.getAttributeValue(object, abstractSession));
            if (objectChangeSet != null) {
                objectChangeSet.setWriteLockValue(object);
                objectChangeSet.updateChangeRecordForAttribute(this.lockMapping, object, abstractSession);
            }
        } else {
            ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
            AbstractRecord abstractRecord = objectBuilder.createRecord(1, abstractSession);
            abstractRecord.put(this.writeLockField, object);
            objectBuilder.assignReturnRow(object2, abstractSession, abstractRecord);
            if (objectChangeSet != null) {
                objectChangeSet.setWriteLockValue(object);
                objectLevelModifyQuery.getQueryMechanism().updateChangeSet(this.descriptor, objectChangeSet, abstractRecord, object2);
            }
        }
    }

    public void setWriteLockField(DatabaseField databaseField) {
        this.writeLockField = databaseField;
    }

    public void setWriteLockFieldName(String string) {
        this.setWriteLockField(new DatabaseField(string));
    }

    public void storeInCache() {
        this.lockValueStored = 1;
    }

    public void storeInObject() {
        this.lockValueStored = 2;
    }

    public void updateRowAndObjectForUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
        Object object2 = this.getNewLockValue(objectLevelModifyQuery);
        if (this.isStoredInCache()) {
            objectLevelModifyQuery.getSession().getIdentityMapAccessor().updateWriteLockValue(objectLevelModifyQuery.getPrimaryKey(), object.getClass(), object2);
        }
        this.updateWriteLockValueForWrite(objectLevelModifyQuery, object2);
    }

    public void writeLockValueIntoRow(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
        Object object2 = this.getWriteLockValue(object, objectLevelModifyQuery.getPrimaryKey(), objectLevelModifyQuery.getSession());
        objectLevelModifyQuery.getModifyRow().put(this.writeLockField, object2);
        if (this.isStoredInCache()) {
            objectLevelModifyQuery.getSession().getIdentityMapAccessor().updateWriteLockValue(objectLevelModifyQuery.getPrimaryKey(), object.getClass(), object2);
        }
    }

    public void validateDelete(int n, Object object, DeleteObjectQuery deleteObjectQuery) {
        if (n <= 0) {
            Object object2;
            Object object3;
            Vector vector = deleteObjectQuery.getPrimaryKey();
            AbstractSession abstractSession = deleteObjectQuery.getSession().getParentIdentityMapSession(deleteObjectQuery, true, true);
            CacheKey cacheKey = abstractSession.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, deleteObjectQuery.getReferenceClass(), deleteObjectQuery.getDescriptor());
            if (cacheKey != null && cacheKey.getObject() != null && deleteObjectQuery.getObjectChangeSet() != null && this.compareWriteLockValues(object3 = deleteObjectQuery.getObjectChangeSet().getInitialWriteLockValue(), object2 = this.getWriteLockValue(cacheKey.getObject(), vector, abstractSession)) != 0) {
                cacheKey.setInvalidationState(-1);
            }
            throw OptimisticLockException.objectChangedSinceLastReadWhenDeleting(object, deleteObjectQuery);
        }
    }

    public void validateUpdate(int n, Object object, WriteObjectQuery writeObjectQuery) {
        if (n <= 0) {
            Object object2;
            Object object3;
            Vector vector = writeObjectQuery.getPrimaryKey();
            AbstractSession abstractSession = writeObjectQuery.getSession().getParentIdentityMapSession(writeObjectQuery, true, true);
            CacheKey cacheKey = abstractSession.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, writeObjectQuery.getReferenceClass(), writeObjectQuery.getDescriptor());
            if (cacheKey != null && cacheKey.getObject() != null && writeObjectQuery.getObjectChangeSet() != null && this.compareWriteLockValues(object3 = writeObjectQuery.getObjectChangeSet().getInitialWriteLockValue(), object2 = this.getWriteLockValue(cacheKey.getObject(), vector, abstractSession)) >= 0) {
                cacheKey.setInvalidationState(-1);
            }
            throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating(object, writeObjectQuery);
        }
    }
}

