/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISLogin;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.Session;

public class EISConnectionSpec
implements Connector {
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    protected ConnectionSpec connectionSpec;
    protected ConnectionFactory connectionFactory;
    protected Context context;
    protected Name name;
    protected Writer log;

    public EISConnectionSpec() {
    }

    public EISConnectionSpec(Context context, String string) throws ValidationException {
        this.context = context;
        this.setName(string);
    }

    public EISConnectionSpec(String string) throws ValidationException {
        this();
        this.setName(string);
    }

    public EISConnectionSpec(Context context, Name name) {
        this.context = context;
        this.name = name;
    }

    public EISConnectionSpec(Name name) {
        this();
        this.name = name;
    }

    public Writer getLog() {
        return this.log;
    }

    public void setLog(Writer writer) {
        this.log = writer;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    public java.sql.Connection connect(Properties properties, Session session) {
        throw EISException.incorrectLoginInstanceProvided(EISLogin.class);
    }

    public Connection connectToDataSource(EISAccessor eISAccessor, Properties properties) throws DatabaseException, ValidationException {
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        if (connectionFactory == null) {
            try {
                connectionFactory = (ConnectionFactory)this.getContext().lookup(this.getName());
                this.setConnectionFactory(connectionFactory);
            }
            catch (Exception exception) {
                throw ValidationException.cannotAcquireDataSource(this.getName(), exception);
            }
        }
        try {
            eISAccessor.setRecordFactory(connectionFactory.getRecordFactory());
            if (this.getConnectionSpec() == null) {
                return connectionFactory.getConnection();
            }
            return connectionFactory.getConnection(this.getConnectionSpec());
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, eISAccessor, null);
        }
    }

    public Context getContext() {
        if (this.context == null) {
            try {
                this.context = new InitialContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.context;
    }

    public String getPasswordFromProperties(Properties properties) {
        Object object = properties.get(PASSWORD);
        String string = null;
        if (object instanceof char[]) {
            string = new String((char[])object);
        } else if (object instanceof String) {
            string = (String)object;
        }
        return string;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public Name getName() {
        return this.name;
    }

    public String getConnectionDetails() {
        return this.getName().toString();
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
    }

    public void setName(String string) throws ValidationException {
        try {
            this.name = new CompositeName(string);
        }
        catch (InvalidNameException invalidNameException) {
            throw ValidationException.invalidDataSourceName(string, invalidNameException);
        }
    }

    public void setName(Name name) {
        this.name = name;
    }

    public String toString() {
        if (this.getName() != null) {
            return Helper.getShortClassName(this.getClass()) + "(connection manager url => " + this.getName() + ")";
        }
        return Helper.getShortClassName(this.getClass()) + "()";
    }

    public void toString(PrintWriter printWriter) {
        printWriter.println(this.toString());
    }
}

