/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.lang.reflect.Method;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;

public class DescriptorException
extends ValidationException {
    protected transient ClassDescriptor descriptor;
    protected transient DatabaseMapping mapping;
    public static final int ATTRIBUTE_AND_MAPPING_WITH_INDIRECTION_MISMATCH = 1;
    public static final int ATTRIBUTE_AND_MAPPING_WITHOUT_INDIRECTION_MISMATCH = 2;
    public static final int ATTRIBUTE_NAME_NOT_SPECIFIED = 6;
    public static final int ATTRIBUTE_TYPE_NOT_VALID = 7;
    public static final int CLASS_INDICATOR_FIELD_NOT_FOUND = 8;
    public static final int DIRECT_FIELD_NAME_NOT_SET = 9;
    public static final int FIELD_NAME_NOT_SET_IN_MAPPING = 10;
    public static final int FOREIGN_KEYS_DEFINED_INCORRECTLY = 11;
    public static final int IDENTITY_MAP_NOT_SPECIFIED = 12;
    public static final int ILLEGAL_ACCESS_WHILE_GETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 13;
    public static final int ILLEGAL_ACCESS_WHILE_CLONING = 14;
    public static final int ILLEGAL_ACCESS_WHILE_CONSTRUCTOR_INSTANTIATION = 15;
    public static final int ILLEGAL_ACCESS_WHILE_EVENT_EXECUTION = 16;
    public static final int ILLEGAL_ACCESS_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 17;
    public static final int ILLEGAL_ACCESS_WHILE_INSTANTIATING_METHOD_BASED_PROXY = 18;
    public static final int ILLEGAL_ACCESS_WHILE_INVOKING_ATTRIBUTE_METHOD = 19;
    public static final int ILLEGAL_ACCESS_WHILE_INVOKING_FIELD_TO_METHOD = 20;
    public static final int ILLEGAL_ACCESS_WHILE_INVOKING_ROW_EXTRACTION_METHOD = 21;
    public static final int ILLEGAL_ACCESS_WHILE_METHOD_INSTANTIATION = 22;
    public static final int ILLEGAL_ACCESS_WHILE_OBSOLETE_EVENT_EXECUTION = 23;
    public static final int ILLEGAL_ACCESS_WHILE_SETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 24;
    public static final int ILLEGAL_ACCESS_WHILE_SETTING_VALUE_THRU_METHOD_ACCESSOR = 25;
    public static final int ILLEGAL_ARGUMENT_WHILE_GETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 26;
    public static final int ILLEGAL_ARGUMENT_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 27;
    public static final int ILLEGAL_ARGUMENT_WHILE_INSTANTIATING_METHOD_BASED_PROXY = 28;
    public static final int ILLEGAL_ARGUMENT_WHILE_INVOKING_ATTRIBUTE_METHOD = 29;
    public static final int ILLEGAL_ARGUMENT_WHILE_INVOKING_FIELD_TO_METHOD = 30;
    public static final int ILLEGAL_ARGUMENT_WHILE_OBSOLETE_EVENT_EXECUTION = 31;
    public static final int ILLEGAL_ARGUMENT_WHILE_SETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 32;
    public static final int ILLEGAL_ARGUMENT_WHILE_SETTING_VALUE_THRU_METHOD_ACCESSOR = 33;
    public static final int INSTANTIATION_WHILE_CONSTRUCTOR_INSTANTIATION = 34;
    public static final int INVALID_DATA_MODIFICATION_EVENT = 35;
    public static final int INVALID_DATA_MODIFICATION_EVENT_CODE = 36;
    public static final int INVALID_DESCRIPTOR_EVENT_CODE = 37;
    public static final int INVALID_IDENTITY_MAP = 38;
    public static final int JAVA_CLASS_NOT_SPECIFIED = 39;
    public static final int DESCRIPTOR_FOR_INTERFACE_IS_MISSING = 40;
    public static final int MAPPING_FOR_SEQUENCE_NUMBER_FIELD = 41;
    public static final int MISSING_CLASS_FOR_INDICATOR_FIELD_VALUE = 43;
    public static final int MISSING_CLASS_INDICATOR_FIELD = 44;
    public static final int MISSING_MAPPING_FOR_FIELD = 45;
    public static final int NO_MAPPING_FOR_PRIMARY_KEY = 46;
    public static final int MULTIPLE_TABLE_PRIMARY_KEY_NOT_SPECIFIED = 47;
    public static final int MULTIPLE_WRITE_MAPPINGS_FOR_FIELD = 48;
    public static final int NO_ATTRIBUTE_TRANSFORMATION_METHOD = 49;
    public static final int NO_FIELD_NAME_FOR_MAPPING = 50;
    public static final int NO_FOREIGN_KEYS_ARE_SPECIFIED = 51;
    public static final int NO_REFERENCE_KEY_IS_SPECIFIED = 52;
    public static final int NO_RELATION_TABLE = 53;
    public static final int NO_SOURCE_RELATION_KEYS_SPECIFIED = 54;
    public static final int NO_SUCH_METHOD_ON_FIND_OBSOLETE_METHOD = 55;
    public static final int NO_SUCH_METHOD_ON_INITIALIZING_ATTRIBUTE_METHOD = 56;
    public static final int NO_SUCH_METHOD_WHILE_CONSTRUCTOR_INSTANTIATION = 57;
    public static final int NO_SUCH_METHOD_WHILE_CONVERTING_TO_METHOD = 58;
    public static final int NO_SUCH_FIELD_WHILE_INITIALIZING_ATTRIBUTES_IN_INSTANCE_VARIABLE_ACCESSOR = 59;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_ATTRIBUTES_IN_METHOD_ACCESSOR = 60;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_CLASS_EXTRACTION_METHOD = 61;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_COPY_POLICY = 62;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_INSTANTIATION_POLICY = 63;
    public static final int NO_TARGET_FOREIGN_KEYS_SPECIFIED = 64;
    public static final int NO_TARGET_RELATION_KEYS_SPECIFIED = 65;
    public static final int NOT_DESERIALIZABLE = 66;
    public static final int NOT_SERIALIZABLE = 67;
    public static final int NULL_FOR_NON_NULL_AGGREGATE = 68;
    public static final int NULL_POINTER_WHILE_GETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 69;
    public static final int NULL_POINTER_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 70;
    public static final int NULL_POINTER_WHILE_SETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 71;
    public static final int NULL_POINTER_WHILE_SETTING_VALUE_THRU_METHOD_ACCESSOR = 72;
    public static final int PARENT_DESCRIPTOR_NOT_SPECIFIED = 73;
    public static final int PRIMARY_KEY_FIELDS_NOT_SPECIFIED = 74;
    public static final int REFERENCE_CLASS_NOT_SPECIFIED = 75;
    public static final int REFERENCE_DESCRIPTOR_IS_NOT_AGGREGATE = 77;
    public static final int REFERENCE_KEY_FIELD_NOT_PROPERLY_SPECIFIED = 78;
    public static final int REFERENCE_TABLE_NOT_SPECIFIED = 79;
    public static final int RELATION_KEY_FIELD_NOT_PROPERLY_SPECIFIED = 80;
    public static final int RETURN_TYPE_IN_GET_ATTRIBUTE_ACCESSOR = 81;
    public static final int SECURITY_ON_FIND_METHOD = 82;
    public static final int SECURITY_ON_FIND_OBSOLETE_METHOD = 83;
    public static final int SECURITY_ON_INITIALIZING_ATTRIBUTE_METHOD = 84;
    public static final int SECURITY_WHILE_CONVERTING_TO_METHOD = 85;
    public static final int SECURITY_WHILE_INITIALIZING_ATTRIBUTES_IN_INSTANCE_VARIABLE_ACCESSOR = 86;
    public static final int SECURITY_WHILE_INITIALIZING_ATTRIBUTES_IN_METHOD_ACCESSOR = 87;
    public static final int SECURITY_WHILE_INITIALIZING_CLASS_EXTRACTION_METHOD = 88;
    public static final int SECURITY_WHILE_INITIALIZING_COPY_POLICY = 89;
    public static final int SECURITY_WHILE_INITIALIZING_INSTANTIATION_POLICY = 90;
    public static final int SEQUENCE_NUMBER_PROPERTY_NOT_SPECIFIED = 91;
    public static final int SIZE_MISMATCH_OF_FOREIGN_KEYS = 92;
    public static final int TABLE_NOT_PRESENT = 93;
    public static final int TABLE_NOT_SPECIFIED = 94;
    public static final int TARGET_FOREIGN_KEYS_SIZE_MISMATCH = 96;
    public static final int TARGET_INVOCATION_WHILE_CLONING = 97;
    public static final int TARGET_INVOCATION_WHILE_EVENT_EXECUTION = 98;
    public static final int TARGET_INVOCATION_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 99;
    public static final int TARGET_INVOCATION_WHILE_INSTANTIATING_METHOD_BASED_PROXY = 100;
    public static final int TARGET_INVOCATION_WHILE_INVOKING_ATTRIBUTE_METHOD = 101;
    public static final int TARGET_INVOCATION_WHILE_INVOKING_FIELD_TO_METHOD = 102;
    public static final int TARGET_INVOCATION_WHILE_INVOKING_ROW_EXTRACTION_METHOD = 103;
    public static final int TARGET_INVOCATION_WHILE_METHOD_INSTANTIATION = 104;
    public static final int TARGET_INVOCATION_WHILE_OBSOLETE_EVENT_EXECUTION = 105;
    public static final int TARGET_INVOCATION_WHILE_SETTING_VALUE_THRU_METHOD_ACESSOR = 106;
    public static final int VALUE_NOT_FOUND_IN_CLASS_INDICATOR_MAPPING = 108;
    public static final int WRITE_LOCK_FIELD_IN_CHILD_DESCRIPTOR = 109;
    public static final int DESCRIPTOR_IS_MISSING = 110;
    public static final int MULTIPLE_TABLE_PRIMARY_KEY_MUST_BE_FULLY_QUALIFIED = 111;
    public static final int ONLY_ONE_TABLE_CAN_BE_ADDED_WITH_THIS_METHOD = 112;
    public static final int NULL_POINTER_WHILE_CONSTRUCTOR_INSTANTIATION = 113;
    public static final int NULL_POINTER_WHILE_METHOD_INSTANTIATION = 114;
    public static final int NO_ATTRBUTE_VALUE_CONVERSION_TO_FIELD_VALUE_PROVIDED = 115;
    public static final int NO_FIELD_VALUE_CONVERSION_TO_ATTRIBUTE_VALUE_PROVIDED = 116;
    public static final int LOCK_MAPPING_CANNOT_BE_READONLY = 118;
    public static final int LOCK_MAPPING_MUST_BE_READONLY = 119;
    public static final int CHILD_DOES_NOT_DEFINE_ABSTRACT_QUERY_KEY = 120;
    public static final int SET_EXISTENCE_CHECKING_NOT_UNDERSTOOD = 122;
    public static final int VALUE_HOLDER_INSTANTIATION_MISMATCH = 125;
    public static final int NO_SUB_CLASS_MATCH = 126;
    public static final int RETURN_AND_MAPPING_WITH_INDIRECTION_MISMATCH = 127;
    public static final int RETURN_AND_MAPPING_WITHOUT_INDIRECTION_MISMATCH = 128;
    public static final int PARAMETER_AND_MAPPING_WITH_INDIRECTION_MISMATCH = 129;
    public static final int PARAMETER_AND_MAPPING_WITHOUT_INDIRECTION_MISMATCH = 130;
    public static final int GET_METHOD_RETURN_TYPE_NOT_VALID = 131;
    public static final int SET_METHOD_PARAMETER_TYPE_NOT_VALID = 133;
    public static final int ILLEGAL_TABLE_NAME_IN_MULTIPLE_TABLE_FOREIGN_KEY = 135;
    public static final int ATTRIBUTE_AND_MAPPING_WITH_TRANSPARENT_INDIRECTION_MISMATCH = 138;
    public static final int RETURN_AND_MAPPING_WITH_TRANSPARENT_INDIRECTION_MISMATCH = 139;
    public static final int PARAMETER_AND_MAPPING_WITH_TRANSPARENT_INDIRECTION_MISMATCH = 140;
    public static final int FIELD_IS_NOT_PRESENT_IN_DATABASE = 141;
    public static final int TABLE_IS_NOT_PRESENT_IN_DATABASE = 142;
    public static final int MULTIPLE_TABLE_INSERT_ORDER_MISMATCH = 143;
    public static final int INVALID_USE_OF_TRANSPARENT_INDIRECTION = 144;
    public static final int MISSING_INDIRECT_CONTAINER_CONSTRUCTOR = 145;
    public static final int COULD_NOT_INSTANTIATE_INDIRECT_CONTAINER_CLASS = 146;
    public static final int INVALID_CONTAINER_POLICY = 147;
    public static final int INVALID_CONTAINER_POLICY_WITH_TRANSPARENT_INDIRECTION = 148;
    public static final int INVALID_USE_OF_NO_INDIRECTION = 149;
    public static final int INDIRECT_CONTAINER_INSTANTIATION_MISMATCH = 150;
    public static final int INVALID_MAPPING_OPERATION = 151;
    public static final int INVALID_INDIRECTION_POLICY_OPERATION = 152;
    public static final int REFERENCE_DESCRIPTOR_IS_NOT_AGGREGATECOLLECTION = 153;
    public static final int INVALID_INDIRECTION_CONTAINER_CLASS = 154;
    public static final int MISSING_FOREIGN_KEY_TRANSLATION = 155;
    public static final int STRUCTURE_NAME_NOT_SET_IN_MAPPING = 156;
    public static final int NORMAL_DESCRIPTORS_DO_NOT_SUPPORT_NON_RELATIONAL_EXTENSIONS = 157;
    public static final int PARENT_CLASS_IS_SELF = 158;
    public static final int PROXY_INDIRECTION_NOT_AVAILABLE = 159;
    public static final int INVALID_ATTRIBUTE_TYPE_FOR_PROXY_INDIRECTION = 160;
    public static final int INVALID_GET_RETURN_TYPE_FOR_PROXY_INDIRECTION = 161;
    public static final int INVALID_SET_PARAMETER_TYPE_FOR_PROXY_INDIRECTION = 162;
    public static final int INCORRECT_COLLECTION_POLICY = 163;
    public static final int INVALID_AMENDMENT_METHOD = 164;
    public static final int ERROR_OCCURED_IN_AMENDMENT_METHOD = 165;
    public static final int VARIABLE_ONE_TO_ONE_MAPPING_IS_NOT_DEFINED = 166;
    public static final int NO_CONSTRUCTOR_INDIRECT_COLLECTION_CLASS = 167;
    public static final int TARGET_INVOCATION_WHILE_CONSTRUCTOR_INSTANTIATION = 168;
    public static final int TARGET_INVOCATION_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 169;
    public static final int ILLEGAL_ACCESS_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 170;
    public static final int INSTANTIATION_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 171;
    public static final int NO_SUCH_METHOD_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 172;
    public static final int NULL_POINTER_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 173;
    public static final int ILLEGAL_ACCESS_WHILE_METHOD_INSTANTIATION_OF_FACTORY = 174;
    public static final int TARGET_INVOCATION_WHILE_METHOD_INSTANTIATION_OF_FACTORY = 175;
    public static final int NULL_POINTER_WHILE_METHOD_INSTANTIATION_OF_FACTORY = 176;
    public static final int NO_MAPPING_FOR_ATTRIBUTENAME = 177;
    public static final int NO_MAPPING_FOR_ATTRIBUTENAME_IN_ENTITY_BEAN = 178;
    public static final int UNSUPPORTED_TYPE_FOR_BIDIRECTIONAL_RELATIONSHIP_MAINTENANCE = 179;
    public static final int REFERENCE_DESCRIPTOR_CANNOT_BE_AGGREGATE = 180;
    public static final int ATTRIBUTE_TRANSFORMER_CLASS_NOT_FOUND = 181;
    public static final int FIELD_TRANSFORMER_CLASS_NOT_FOUND = 182;
    public static final int ATTRIBUTE_TRANSFORMER_CLASS_INVALID = 183;
    public static final int FIELD_TRANSFORMER_CLASS_INVALID = 184;
    public static final int RETURNING_POLICY_FIELD_TYPE_CONFLICT = 185;
    public static final int RETURNING_POLICY_FIELD_INSERT_CONFLICT = 186;
    public static final int RETURNING_POLICY_AND_DESCRIPTOR_FIELD_TYPE_CONFLICT = 187;
    public static final int RETURNING_POLICY_UNMAPPED_FIELD_TYPE_NOT_SET = 188;
    public static final int RETURNING_POLICY_MAPPED_FIELD_TYPE_NOT_SET = 189;
    public static final int RETURNING_POLICY_MAPPING_NOT_SUPPORTED = 190;
    public static final int RETURNING_POLICY_FIELD_NOT_SUPPORTED = 191;
    public static final int CUSTOM_QUERY_AND_RETURNING_POLICY_CONFLICT = 192;
    public static final int NO_CUSTOM_QUERY_FOR_RETURNING_POLICY = 193;
    public static final int CLASS_EXTRACTION_METHOD_MUST_BE_STATIC = 194;
    public static final int ISOLATED_DESCRIPTOR_REFERENCED_BY_SHARED_DESCRIPTOR = 195;
    public static final int UPDATE_ALL_FIELDS_NOT_SET = 196;
    public static final int INVALID_MAPPING_TYPE = 197;
    public static final int NEED_TO_IMPLEMENT_CHANGETRACKER = 198;
    public static final int NEED_TO_IMPLEMENT_FETCHGROUPTRACKER = 199;
    public static final int ATTEMPT_TO_REGISTER_DEAD_INDIRECTION = 200;
    public static final int UNIT_OF_WORK_ISOLATED_OBJECTS_ACCESSED_IN_SESSION = 201;
    public static final int INTERNAL_ERROR_ACCESSING_PKFIELD = 202;
    public static final int INTERNAL_ERROR_SET_METHOD = 203;
    public static final int INSERT_ORDER_CONFLICTS_WITH_MULTIPLE_TABLE_FOREIGN_KEYS = 204;
    public static final int INSERT_ORDER_CYCLICAL_DEPENDENCY_BETWEEN_TWO_TABLES = 205;
    public static final int INSERT_ORDER_CYCLICAL_DEPENDENCY_BETWEEN_THREE_OR_MORE_TABLES = 206;
    public static final int INSERT_ORDER_CHILD_BEFORE_PARENT = 207;
    public static final int CANNOT_SET_CONVERTER_FOR_NON_DIRECT_MAPPING = 208;
    public static final int DIRECT_KEY_NOT_SET = 209;

    protected DescriptorException(String string) {
        super(string);
    }

    protected DescriptorException(String string, DatabaseMapping databaseMapping) {
        this(string);
        if (databaseMapping != null) {
            this.mapping = databaseMapping;
            this.descriptor = databaseMapping.getDescriptor();
        }
    }

    protected DescriptorException(String string, ClassDescriptor classDescriptor) {
        this(string);
        this.descriptor = classDescriptor;
    }

    protected DescriptorException(String string, ClassDescriptor classDescriptor, Throwable throwable) {
        this(string, classDescriptor);
        this.setInternalException(throwable);
    }

    public static DescriptorException attemptToRegisterDeadIndirection(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 200, objectArray), databaseMapping);
        descriptorException.setErrorCode(200);
        return descriptorException;
    }

    public static DescriptorException attributeAndMappingWithIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 1, objectArray), databaseMapping);
        descriptorException.setErrorCode(1);
        return descriptorException;
    }

    public static DescriptorException attributeAndMappingWithoutIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 2, objectArray), databaseMapping);
        descriptorException.setErrorCode(2);
        return descriptorException;
    }

    public static DescriptorException attributeAndMappingWithTransparentIndirectionMismatch(DatabaseMapping databaseMapping, Class clazz, String string) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), clazz, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 138, objectArray), databaseMapping);
        descriptorException.setErrorCode(138);
        return descriptorException;
    }

    public static DescriptorException attributeNameNotSpecified() {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 6, objectArray));
        descriptorException.setErrorCode(6);
        return descriptorException;
    }

    public static DescriptorException attributeTransformerClassNotFound(String string, AbstractTransformationMapping abstractTransformationMapping, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 181, objectArray));
        descriptorException.setErrorCode(181);
        descriptorException.setMapping(abstractTransformationMapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException attributeTransformerClassInvalid(String string, AbstractTransformationMapping abstractTransformationMapping, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 183, objectArray));
        descriptorException.setErrorCode(183);
        descriptorException.setMapping(abstractTransformationMapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException attributeTypeNotValid(CollectionMapping collectionMapping, Class clazz) {
        Object[] objectArray = new Object[]{collectionMapping.getAttributeName(), clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 7, objectArray), collectionMapping);
        descriptorException.setErrorCode(7);
        return descriptorException;
    }

    public static DescriptorException childDoesNotDefineAbstractQueryKeyOfParent(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2, String string) {
        Object[] objectArray = new Object[]{string, classDescriptor2, classDescriptor};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 120, objectArray));
        descriptorException.setErrorCode(120);
        return descriptorException;
    }

    public static DescriptorException classIndicatorFieldNotFound(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2) {
        Object[] objectArray = new Object[]{classDescriptor2, classDescriptor, CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 8, objectArray), classDescriptor2);
        descriptorException.setErrorCode(8);
        return descriptorException;
    }

    public static DescriptorException couldNotInstantiateIndirectContainerClass(Class clazz, Exception exception) {
        Object[] objectArray = new Object[]{clazz, Helper.getShortClassName(clazz)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 146, objectArray));
        descriptorException.setErrorCode(146);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException descriptorForInterfaceIsMissing(String string) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 40, objectArray));
        descriptorException.setErrorCode(40);
        return descriptorException;
    }

    public static DescriptorException descriptorIsMissing(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 110, objectArray), databaseMapping);
        descriptorException.setErrorCode(110);
        return descriptorException;
    }

    public static DescriptorException directFieldNameNotSet(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 9, objectArray), databaseMapping);
        descriptorException.setErrorCode(9);
        return descriptorException;
    }

    public static DescriptorException errorAccessingSetMethodOfEntity(Class clazz, String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{clazz, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 203, objectArray), classDescriptor, exception);
        descriptorException.initCause(exception);
        return descriptorException;
    }

    public static DescriptorException errorOccuredInAmendmentMethod(Class clazz, String string, Exception exception, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{clazz, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 165, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(165);
        return descriptorException;
    }

    public static DescriptorException fieldIsNotPresentInDatabase(ClassDescriptor classDescriptor, String string, String string2) {
        Object[] objectArray = new Object[]{string2, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 141, objectArray), classDescriptor);
        descriptorException.setErrorCode(141);
        return descriptorException;
    }

    public static DescriptorException fieldNameNotSetInMapping(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 10, objectArray), databaseMapping);
        descriptorException.setErrorCode(10);
        return descriptorException;
    }

    public static DescriptorException fieldTransformerClassNotFound(String string, AbstractTransformationMapping abstractTransformationMapping, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 182, objectArray));
        descriptorException.setErrorCode(182);
        descriptorException.setMapping(abstractTransformationMapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException fieldTransformerClassInvalid(String string, AbstractTransformationMapping abstractTransformationMapping, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 184, objectArray));
        descriptorException.setErrorCode(182);
        descriptorException.setMapping(abstractTransformationMapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException foreignKeysDefinedIncorrectly(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 11, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(11);
        return descriptorException;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public String getMessage() {
        if (this.getDescriptor() == null) {
            return super.getMessage();
        }
        if (this.getMapping() != null) {
            return super.getMessage() + DescriptorException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("MappingHeader") + this.getMapping().toString() + DescriptorException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("DescriptorHeader") + this.getDescriptor().toString();
        }
        return super.getMessage() + DescriptorException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("DescriptorHeader") + this.getDescriptor().toString();
    }

    public static DescriptorException getMethodReturnTypeNotValid(CollectionMapping collectionMapping) {
        Object[] objectArray = new Object[]{collectionMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 131, objectArray), collectionMapping);
        descriptorException.setErrorCode(131);
        return descriptorException;
    }

    public static DescriptorException identityMapNotSpecified(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 12, objectArray), classDescriptor);
        descriptorException.setErrorCode(12);
        return descriptorException;
    }

    public static DescriptorException illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 13, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(13);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileCloning(Object object, String string, ClassDescriptor classDescriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{object, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 14, objectArray), classDescriptor, throwable);
        descriptorException.setErrorCode(14);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileConstructorInstantiation(ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 15, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(15);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileConstructorInstantiationOfFactory(ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 170, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(170);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileEventExecution(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 16, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(16);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileGettingValueThruMethodAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 17, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(17);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInstantiatingMethodBasedProxy(Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 18, objectArray));
        descriptorException.setErrorCode(18);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInvokingAttributeMethod(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 19, objectArray));
        descriptorException.setErrorCode(19);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInvokingFieldToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 20, objectArray));
        descriptorException.setErrorCode(20);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInvokingRowExtractionMethod(AbstractRecord abstractRecord, Method method, ClassDescriptor classDescriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{abstractRecord, method};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 21, objectArray), classDescriptor, throwable);
        descriptorException.setErrorCode(21);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileMethodInstantiation(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 22, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(22);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileMethodInstantiationOfFactory(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 174, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(174);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileObsoleteEventExecute(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 23, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(23);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileSettingValueThruInstanceVariableAccessor(String string, String string2, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, String.valueOf(object), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 24, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(24);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileSettingValueThruMethodAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 25, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(25);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileGettingValueThruInstanceVariableAccessor(String string, String string2, String string3, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 26, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(26);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileGettingValueThruMethodAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 27, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(27);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileInstantiatingMethodBasedProxy(Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 28, objectArray));
        descriptorException.setErrorCode(28);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileInvokingAttributeMethod(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 29, objectArray));
        descriptorException.setErrorCode(29);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileInvokingFieldToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 30, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setErrorCode(30);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileObsoleteEventExecute(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 31, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(31);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileSettingValueThruInstanceVariableAccessor(String string, String string2, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{String.valueOf(object), string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 32, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(32);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileSettingValueThruMethodAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 33, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(33);
        return descriptorException;
    }

    public static DescriptorException illegalTableNameInMultipleTableForeignKeyField(ClassDescriptor classDescriptor, DatabaseTable databaseTable) {
        Object[] objectArray = new Object[]{databaseTable};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 135, objectArray), classDescriptor);
        descriptorException.setErrorCode(135);
        return descriptorException;
    }

    public static DescriptorException incorrectCollectionPolicy(DatabaseMapping databaseMapping, Class clazz, Class clazz2) {
        Object[] objectArray = new Object[]{clazz, clazz2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 163, objectArray), databaseMapping);
        descriptorException.setErrorCode(163);
        return descriptorException;
    }

    public static DescriptorException indirectContainerInstantiationMismatch(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), object, CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 150, objectArray), databaseMapping);
        descriptorException.setErrorCode(150);
        return descriptorException;
    }

    public static DescriptorException instantiationWhileConstructorInstantiation(ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 34, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(34);
        return descriptorException;
    }

    public static DescriptorException instantiationWhileConstructorInstantiationOfFactory(ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 171, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(171);
        return descriptorException;
    }

    public static DescriptorException invalidAmendmentMethod(Class clazz, String string, Exception exception, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{clazz, string, CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 164, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(164);
        return descriptorException;
    }

    public static DescriptorException invalidAttributeTypeForProxyIndirection(Class clazz, Class[] classArray, DatabaseMapping databaseMapping) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i == classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), databaseMapping.getDescriptor().getJavaClass().getName(), clazz.getName(), stringBuffer.toString(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 160, objectArray), databaseMapping);
        descriptorException.setErrorCode(160);
        return descriptorException;
    }

    public static DescriptorException invalidContainerPolicy(ContainerPolicy containerPolicy, Class clazz) {
        Object[] objectArray = new Object[]{containerPolicy, clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 147, objectArray));
        descriptorException.setErrorCode(147);
        return descriptorException;
    }

    public static DescriptorException invalidContainerPolicyWithTransparentIndirection(DatabaseMapping databaseMapping, ContainerPolicy containerPolicy) {
        Object[] objectArray = new Object[]{containerPolicy};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 148, objectArray), databaseMapping);
        descriptorException.setErrorCode(148);
        return descriptorException;
    }

    public static DescriptorException invalidDataModificationEvent(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 35, objectArray), databaseMapping);
        descriptorException.setErrorCode(35);
        return descriptorException;
    }

    public static DescriptorException invalidDataModificationEventCode(Object object, ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 36, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(36);
        return descriptorException;
    }

    public static DescriptorException invalidDescriptorEventCode(DescriptorEvent descriptorEvent, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{new Integer(descriptorEvent.getEventCode())};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 37, objectArray), classDescriptor);
        descriptorException.setErrorCode(37);
        return descriptorException;
    }

    public static DescriptorException invalidGetMethodReturnTypeForProxyIndirection(Class clazz, Class[] classArray, DatabaseMapping databaseMapping) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i == classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        Object[] objectArray = new Object[]{databaseMapping.getGetMethodName(), databaseMapping.getDescriptor().getJavaClass().getName(), clazz.getName(), stringBuffer.toString(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 161, objectArray), databaseMapping);
        descriptorException.setErrorCode(161);
        return descriptorException;
    }

    public static DescriptorException invalidIdentityMap(ClassDescriptor classDescriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 38, objectArray), classDescriptor, throwable);
        descriptorException.setErrorCode(38);
        return descriptorException;
    }

    public static DescriptorException invalidIndirectionContainerClass(ContainerIndirectionPolicy containerIndirectionPolicy, Class clazz) {
        Object[] objectArray = new Object[]{clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 154, objectArray), containerIndirectionPolicy.getMapping());
        descriptorException.setErrorCode(154);
        return descriptorException;
    }

    public static DescriptorException invalidIndirectionPolicyOperation(IndirectionPolicy indirectionPolicy, String string) {
        Object[] objectArray = new Object[]{indirectionPolicy, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 152, objectArray), indirectionPolicy.getMapping());
        descriptorException.setErrorCode(152);
        return descriptorException;
    }

    public static DescriptorException invalidMappingOperation(DatabaseMapping databaseMapping, String string) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 151, objectArray), databaseMapping);
        descriptorException.setErrorCode(151);
        return descriptorException;
    }

    public static DescriptorException invalidSetMethodParameterTypeForProxyIndirection(Class clazz, Class[] classArray, DatabaseMapping databaseMapping) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i == classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        Object[] objectArray = new Object[]{databaseMapping.getSetMethodName(), databaseMapping.getDescriptor().getJavaClass().getName(), clazz.getName(), stringBuffer.toString(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 162, objectArray), databaseMapping);
        descriptorException.setErrorCode(162);
        return descriptorException;
    }

    public static DescriptorException invalidUseOfNoIndirection(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 149, objectArray), databaseMapping);
        descriptorException.setErrorCode(149);
        return descriptorException;
    }

    public static DescriptorException invalidUseOfTransparentIndirection(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        String string = ExceptionMessageGenerator.buildMessage(DescriptorException.class, 144, objectArray);
        DescriptorException descriptorException = new DescriptorException(string, databaseMapping);
        descriptorException.setErrorCode(144);
        return descriptorException;
    }

    public static DescriptorException isolateDescriptorReferencedBySharedDescriptor(String string, String string2, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string, string2};
        String string3 = ExceptionMessageGenerator.buildMessage(DescriptorException.class, 195, objectArray);
        DescriptorException descriptorException = new DescriptorException(string3, databaseMapping);
        descriptorException.setErrorCode(195);
        return descriptorException;
    }

    public static DescriptorException javaClassNotSpecified(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 39, objectArray), classDescriptor);
        descriptorException.setErrorCode(39);
        return descriptorException;
    }

    public static DescriptorException mappingCanNotBeReadOnly(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getDescriptor().getJavaClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 118, objectArray), databaseMapping);
        descriptorException.setErrorCode(118);
        return descriptorException;
    }

    public static DescriptorException mappingForSequenceNumberField(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 41, objectArray));
        descriptorException.setErrorCode(41);
        descriptorException.setDescriptor(classDescriptor);
        return descriptorException;
    }

    public static DescriptorException missingClassForIndicatorFieldValue(Object object, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{object, object.getClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 43, objectArray), classDescriptor);
        descriptorException.setErrorCode(43);
        return descriptorException;
    }

    public static DescriptorException missingClassIndicatorField(AbstractRecord abstractRecord, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{abstractRecord};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 44, objectArray), classDescriptor);
        descriptorException.setErrorCode(44);
        return descriptorException;
    }

    public static DescriptorException missingForeignKeyTranslation(ForeignReferenceMapping foreignReferenceMapping, DatabaseField databaseField) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 155, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(155);
        return descriptorException;
    }

    public static DescriptorException missingIndirectContainerConstructor(Class clazz) {
        Object[] objectArray = new Object[]{clazz.getName(), clazz.getName() + "()"};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 145, objectArray));
        descriptorException.setErrorCode(145);
        return descriptorException;
    }

    public static DescriptorException missingMappingForField(DatabaseField databaseField, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 45, objectArray));
        descriptorException.setErrorCode(45);
        descriptorException.setDescriptor(classDescriptor);
        return descriptorException;
    }

    public static DescriptorException multipleTableInsertOrderMismatch(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{classDescriptor.getMultipleTableInsertOrder(), classDescriptor.getTables(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 143, objectArray));
        descriptorException.setErrorCode(143);
        descriptorException.setDescriptor(classDescriptor);
        return descriptorException;
    }

    public static DescriptorException multipleTablePrimaryKeyMustBeFullyQualified(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 111, objectArray), classDescriptor);
        descriptorException.setErrorCode(111);
        return descriptorException;
    }

    public static DescriptorException multipleTablePrimaryKeyNotSpecified(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 47, objectArray), classDescriptor);
        descriptorException.setErrorCode(47);
        return descriptorException;
    }

    public static DescriptorException multipleWriteMappingsForField(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 48, objectArray), databaseMapping);
        descriptorException.setErrorCode(48);
        return descriptorException;
    }

    public static DescriptorException mustBeReadOnlyMappingWhenStoredInCache(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getDescriptor().getJavaClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 119, objectArray), databaseMapping);
        descriptorException.setErrorCode(119);
        return descriptorException;
    }

    public static DescriptorException noAttributeTransformationMethod(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 49, objectArray), databaseMapping);
        descriptorException.setErrorCode(49);
        return descriptorException;
    }

    public static DescriptorException noAttributeValueConversionToFieldValueProvided(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 115, objectArray), databaseMapping);
        descriptorException.setErrorCode(115);
        return descriptorException;
    }

    public static DescriptorException noConstructorIndirectionContainerClass(ContainerIndirectionPolicy containerIndirectionPolicy, Class clazz) {
        Object[] objectArray = new Object[]{clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 167, objectArray), containerIndirectionPolicy.getMapping());
        descriptorException.setErrorCode(167);
        return descriptorException;
    }

    public static DescriptorException noFieldNameForMapping(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 50, objectArray), databaseMapping);
        descriptorException.setErrorCode(50);
        return descriptorException;
    }

    public static DescriptorException noFieldValueConversionToAttributeValueProvided(Object object, DatabaseField databaseField, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{object, databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 116, objectArray), databaseMapping);
        descriptorException.setErrorCode(116);
        return descriptorException;
    }

    public static DescriptorException noForeignKeysAreSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 51, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(51);
        return descriptorException;
    }

    public static DescriptorException noMappingForPrimaryKey(DatabaseField databaseField, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 46, objectArray), classDescriptor);
        descriptorException.setErrorCode(46);
        return descriptorException;
    }

    public static DescriptorException noReferenceKeyIsSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 52, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(52);
        return descriptorException;
    }

    public static DescriptorException noRelationTable(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 53, objectArray), databaseMapping);
        descriptorException.setErrorCode(53);
        return descriptorException;
    }

    public static DescriptorException normalDescriptorsDoNotSupportNonRelationalExtensions(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 157, objectArray), classDescriptor);
        descriptorException.setErrorCode(157);
        return descriptorException;
    }

    public static DescriptorException noSourceRelationKeysSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 54, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(54);
        return descriptorException;
    }

    public static DescriptorException noSubClassMatch(Class clazz, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 126, objectArray), databaseMapping);
        descriptorException.setErrorCode(126);
        return descriptorException;
    }

    public static DescriptorException noSuchFieldWhileInitializingAttributesInInstanceVariableAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 59, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(59);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodOnFindObsoleteMethod(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 55, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(55);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodOnInitializingAttributeMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 56, objectArray));
        descriptorException.setErrorCode(56);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileConstructorInstantiation(ClassDescriptor classDescriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 57, objectArray), classDescriptor, throwable);
        descriptorException.setErrorCode(57);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileConstructorInstantiationOfFactory(ClassDescriptor classDescriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 172, objectArray), classDescriptor, throwable);
        descriptorException.setErrorCode(172);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileConvertingToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 58, objectArray));
        descriptorException.setErrorCode(58);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingAttributesInMethodAccessor(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 60, objectArray));
        descriptorException.setErrorCode(60);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingClassExtractionMethod(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 61, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(61);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingCopyPolicy(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 62, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(62);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingInstantiationPolicy(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 63, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(63);
        return descriptorException;
    }

    public static DescriptorException noTargetForeignKeysSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 64, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(64);
        return descriptorException;
    }

    public static DescriptorException noTargetRelationKeysSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 65, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(65);
        return descriptorException;
    }

    public static DescriptorException notDeserializable(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 66, objectArray));
        descriptorException.setErrorCode(66);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException notSerializable(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 67, objectArray));
        descriptorException.setErrorCode(67);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException nullForNonNullAggregate(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 68, objectArray), databaseMapping);
        descriptorException.setErrorCode(68);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileConstructorInstantiation(ClassDescriptor classDescriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 113, objectArray), classDescriptor, throwable);
        descriptorException.setErrorCode(113);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileConstructorInstantiationOfFactory(ClassDescriptor classDescriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 173, objectArray), classDescriptor, throwable);
        descriptorException.setErrorCode(173);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileGettingValueThruInstanceVariableAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 69, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(69);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileGettingValueThruMethodAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 70, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(70);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileMethodInstantiation(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 114, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(114);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileMethodInstantiationOfFactory(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 176, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(176);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileSettingValueThruInstanceVariableAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 71, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(71);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileSettingValueThruMethodAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 72, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(72);
        return descriptorException;
    }

    public static DescriptorException onlyOneTableCanBeAddedWithThisMethod(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 112, objectArray), classDescriptor);
        descriptorException.setErrorCode(112);
        return descriptorException;
    }

    public static DescriptorException parameterAndMappingWithIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 129, objectArray), databaseMapping);
        descriptorException.setErrorCode(129);
        return descriptorException;
    }

    public static DescriptorException parameterAndMappingWithoutIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 130, objectArray), databaseMapping);
        descriptorException.setErrorCode(130);
        return descriptorException;
    }

    public static DescriptorException parameterAndMappingWithTransparentIndirectionMismatch(DatabaseMapping databaseMapping, Class clazz, String string) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), clazz, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 140, objectArray), databaseMapping);
        descriptorException.setErrorCode(140);
        return descriptorException;
    }

    public static DescriptorException parentClassIsSelf(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 158, objectArray), classDescriptor);
        descriptorException.setErrorCode(158);
        return descriptorException;
    }

    public static DescriptorException parentDescriptorNotSpecified(String string, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 73, objectArray), classDescriptor);
        descriptorException.setErrorCode(73);
        return descriptorException;
    }

    public static DescriptorException primaryKeyFieldsNotSepcified(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 74, objectArray), classDescriptor);
        descriptorException.setErrorCode(74);
        return descriptorException;
    }

    public static DescriptorException proxyIndirectionNotAvailable(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 159, objectArray), databaseMapping);
        descriptorException.setErrorCode(159);
        return descriptorException;
    }

    public static DescriptorException referenceClassNotSpecified(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 75, objectArray), databaseMapping);
        descriptorException.setErrorCode(75);
        return descriptorException;
    }

    public static DescriptorException referenceDescriptorIsNotAggregate(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 77, objectArray), databaseMapping);
        descriptorException.setErrorCode(77);
        return descriptorException;
    }

    public static DescriptorException referenceDescriptorCannotBeAggregate(DatabaseMapping databaseMapping) {
        DescriptorException descriptorException = new DescriptorException("Reference descriptor cannot be aggregate.", databaseMapping);
        descriptorException.setErrorCode(180);
        return descriptorException;
    }

    public static DescriptorException referenceDescriptorIsNotAggregateCollection(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 153, objectArray), databaseMapping);
        descriptorException.setErrorCode(153);
        return descriptorException;
    }

    public static DescriptorException referenceKeyFieldNotProperlySpecified(DatabaseField databaseField, ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 78, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(78);
        return descriptorException;
    }

    public static DescriptorException referenceTableNotSpecified(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 79, objectArray), databaseMapping);
        descriptorException.setErrorCode(79);
        return descriptorException;
    }

    public static DescriptorException relationKeyFieldNotProperlySpecified(DatabaseField databaseField, ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 80, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(80);
        return descriptorException;
    }

    public static DescriptorException returnAndMappingWithIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 127, objectArray), databaseMapping);
        descriptorException.setErrorCode(127);
        return descriptorException;
    }

    public static DescriptorException returnAndMappingWithoutIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 128, objectArray), databaseMapping);
        descriptorException.setErrorCode(128);
        return descriptorException;
    }

    public static DescriptorException returnAndMappingWithTransparentIndirectionMismatch(DatabaseMapping databaseMapping, Class clazz, String string) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), clazz, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 139, objectArray), databaseMapping);
        descriptorException.setErrorCode(139);
        return descriptorException;
    }

    public static DescriptorException returnTypeInGetAttributeAccessor(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 81, objectArray));
        descriptorException.setErrorCode(81);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException securityOnFindMethod(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 82, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(82);
        return descriptorException;
    }

    public static DescriptorException securityOnFindObsoleteMethod(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 83, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(83);
        return descriptorException;
    }

    public static DescriptorException securityOnInitializingAttributeMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 84, objectArray));
        descriptorException.setErrorCode(84);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException securityWhileConvertingToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 85, objectArray));
        descriptorException.setErrorCode(85);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingAttributesInInstanceVariableAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 86, objectArray));
        descriptorException.setErrorCode(86);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingAttributesInMethodAccessor(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 87, objectArray));
        descriptorException.setErrorCode(87);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingClassExtractionMethod(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 88, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(88);
        return descriptorException;
    }

    public static DescriptorException classExtractionMethodMustBeStatic(String string, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 194, objectArray), classDescriptor);
        descriptorException.setErrorCode(194);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingCopyPolicy(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 89, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(89);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingInstantiationPolicy(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 90, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(90);
        return descriptorException;
    }

    public static DescriptorException sequenceNumberPropertyNotSpecified(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 91, objectArray), classDescriptor);
        descriptorException.setErrorCode(91);
        return descriptorException;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public static DescriptorException setExistenceCheckingNotUnderstood(String string, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 122, objectArray), classDescriptor);
        descriptorException.setErrorCode(122);
        return descriptorException;
    }

    public void setMapping(DatabaseMapping databaseMapping) {
        if (databaseMapping != null) {
            this.mapping = databaseMapping;
            this.setDescriptor(databaseMapping.getDescriptor());
        }
    }

    public static DescriptorException setMethodParameterTypeNotValid(CollectionMapping collectionMapping) {
        Object[] objectArray = new Object[]{collectionMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 133, objectArray), collectionMapping);
        descriptorException.setErrorCode(133);
        return descriptorException;
    }

    public static DescriptorException sizeMismatchOfForeignKeys(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 92, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(92);
        return descriptorException;
    }

    public static DescriptorException structureNameNotSetInMapping(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 156, objectArray), databaseMapping);
        descriptorException.setErrorCode(156);
        return descriptorException;
    }

    public static DescriptorException tableIsNotPresentInDatabase(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{classDescriptor.getTableName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 142, objectArray), classDescriptor);
        descriptorException.setErrorCode(142);
        return descriptorException;
    }

    public static DescriptorException tableNotPresent(String string, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 93, objectArray), classDescriptor);
        descriptorException.setErrorCode(93);
        return descriptorException;
    }

    public static DescriptorException tableNotSpecified(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 94, objectArray), classDescriptor);
        descriptorException.setErrorCode(94);
        return descriptorException;
    }

    public static DescriptorException targetForeignKeysSizeMismatch(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 96, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(96);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileCloning(Object object, String string, ClassDescriptor classDescriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{object, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 97, objectArray), classDescriptor, throwable);
        descriptorException.setErrorCode(97);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileConstructorInstantiation(ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 168, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(168);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileConstructorInstantiationOfFactory(ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 169, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(169);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileEventExecution(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 98, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(98);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileGettingValueThruMethodAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 99, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(99);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInstantiatingMethodBasedProxy(Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 100, objectArray));
        descriptorException.setErrorCode(100);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInvokingAttributeMethod(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 101, objectArray));
        descriptorException.setErrorCode(101);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInvokingFieldToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 102, objectArray));
        descriptorException.setErrorCode(102);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInvokingRowExtractionMethod(AbstractRecord abstractRecord, Method method, ClassDescriptor classDescriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{abstractRecord, method};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 103, objectArray), classDescriptor, throwable);
        descriptorException.setErrorCode(103);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileMethodInstantiation(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 104, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(104);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileMethodInstantiationOfFactory(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 175, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(175);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileObsoleteEventExecute(String string, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 105, objectArray), classDescriptor, exception);
        descriptorException.setErrorCode(105);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileSettingValueThruMethodAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 106, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(106);
        return descriptorException;
    }

    public static DescriptorException unsupportedTypeForBidirectionalRelationshipMaintenance(DatabaseMapping databaseMapping, ContainerPolicy containerPolicy) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), containerPolicy};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 179, objectArray), databaseMapping);
        descriptorException.setErrorCode(179);
        return descriptorException;
    }

    public static DescriptorException valueHolderInstantiationMismatch(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 125, objectArray), databaseMapping);
        descriptorException.setErrorCode(125);
        return descriptorException;
    }

    public static DescriptorException valueNotFoundInClassIndicatorMapping(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2) {
        Object[] objectArray = new Object[]{classDescriptor};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 108, objectArray), classDescriptor2);
        descriptorException.setErrorCode(108);
        return descriptorException;
    }

    public static DescriptorException variableOneToOneMappingIsNotDefinedProperly(DatabaseMapping databaseMapping, ClassDescriptor classDescriptor, String string) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 166, objectArray), databaseMapping);
        descriptorException.setErrorCode(166);
        return descriptorException;
    }

    public static DescriptorException writeLockFieldInChildDescriptor(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 109, objectArray), classDescriptor);
        descriptorException.setErrorCode(109);
        return descriptorException;
    }

    public static DescriptorException mappingForAttributeIsMissing(String string, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 177, objectArray), classDescriptor);
        descriptorException.setErrorCode(177);
        return descriptorException;
    }

    public static DescriptorException attributeMappingIsMissingForEntityBean(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 178, objectArray));
        descriptorException.setErrorCode(178);
        return descriptorException;
    }

    public static DescriptorException returningPolicyFieldTypeConflict(String string, String string2, String string3, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 185, objectArray), classDescriptor);
        descriptorException.setErrorCode(185);
        return descriptorException;
    }

    public static DescriptorException returningPolicyFieldInsertConflict(String string, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 186, objectArray), classDescriptor);
        descriptorException.setErrorCode(186);
        return descriptorException;
    }

    public static DescriptorException returningPolicyAndDescriptorFieldTypeConflict(String string, String string2, String string3, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 187, objectArray), classDescriptor);
        descriptorException.setErrorCode(187);
        return descriptorException;
    }

    public static DescriptorException returningPolicyUnmappedFieldTypeNotSet(String string, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 188, objectArray), classDescriptor);
        descriptorException.setErrorCode(188);
        return descriptorException;
    }

    public static DescriptorException returningPolicyMappedFieldTypeNotSet(String string, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 189, objectArray), classDescriptor);
        descriptorException.setErrorCode(189);
        return descriptorException;
    }

    public static DescriptorException returningPolicyMappingNotSupported(String string, String string2, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 190, objectArray), databaseMapping);
        descriptorException.setErrorCode(190);
        return descriptorException;
    }

    public static DescriptorException returningPolicyFieldNotSupported(String string, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 191, objectArray), classDescriptor);
        descriptorException.setErrorCode(191);
        return descriptorException;
    }

    public static DescriptorException customQueryAndReturningPolicyFieldConflict(String string, String string2, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 192, objectArray), classDescriptor);
        descriptorException.setErrorCode(192);
        return descriptorException;
    }

    public static DescriptorException noCustomQueryForReturningPolicy(String string, String string2, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 193, objectArray), classDescriptor);
        descriptorException.setErrorCode(193);
        return descriptorException;
    }

    public static DescriptorException updateAllFieldsNotSet(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 196, objectArray), classDescriptor);
        descriptorException.setErrorCode(196);
        return descriptorException;
    }

    public static DescriptorException invalidMappingType(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 197, objectArray), databaseMapping);
        descriptorException.setErrorCode(197);
        return descriptorException;
    }

    public static DescriptorException needToImplementChangeTracker(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{classDescriptor.getJavaClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 198, objectArray), classDescriptor);
        descriptorException.setErrorCode(198);
        return descriptorException;
    }

    public static DescriptorException needToImplementFetchGroupTracker(Class clazz, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 199, objectArray), classDescriptor);
        descriptorException.setErrorCode(199);
        return descriptorException;
    }

    public static DescriptorException errorUsingPrimaryKey(Object object, ClassDescriptor classDescriptor, Exception exception) {
        Object[] objectArray = new Object[]{String.valueOf(202), object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 202, objectArray), classDescriptor, exception);
        return descriptorException;
    }

    public static DescriptorException unitOfWorkIsolatedObjectsAccessedInSession(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 201, objectArray), classDescriptor);
        descriptorException.setErrorCode(201);
        return descriptorException;
    }

    public static DescriptorException insertOrderConflictsWithMultipleTableForeignKeys(ClassDescriptor classDescriptor, DatabaseTable databaseTable, DatabaseTable databaseTable2) {
        Object[] objectArray = new Object[]{databaseTable, databaseTable2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 204, objectArray), classDescriptor);
        descriptorException.setErrorCode(204);
        return descriptorException;
    }

    public static DescriptorException insertOrderCyclicalDependencyBetweenTwoTables(ClassDescriptor classDescriptor, DatabaseTable databaseTable, DatabaseTable databaseTable2) {
        Object[] objectArray = new Object[]{databaseTable, databaseTable2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 205, objectArray), classDescriptor);
        descriptorException.setErrorCode(205);
        return descriptorException;
    }

    public static DescriptorException insertOrderCyclicalDependencyBetweenThreeOrMoreTables(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 206, objectArray), classDescriptor);
        descriptorException.setErrorCode(206);
        return descriptorException;
    }

    public static DescriptorException insertOrderChildBeforeParent(ClassDescriptor classDescriptor, DatabaseTable databaseTable, DatabaseTable databaseTable2) {
        Object[] objectArray = new Object[]{databaseTable, databaseTable2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 207, objectArray), classDescriptor);
        descriptorException.setErrorCode(207);
        return descriptorException;
    }

    public static DescriptorException cannotSetConverterForNonDirectMapping(ClassDescriptor classDescriptor, DatabaseMapping databaseMapping, String string) {
        Object[] objectArray = new Object[]{databaseMapping, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 208, objectArray), classDescriptor);
        descriptorException.setErrorCode(208);
        return descriptorException;
    }

    public static DescriptorException directKeyNotSet(ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(DescriptorException.class, 209, objectArray), classDescriptor);
        descriptorException.setErrorCode(209);
        return descriptorException;
    }
}

