/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.internal.codegen.CodeDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;

public abstract class MethodDefinition
extends CodeDefinition {
    protected boolean isAbstract;
    protected boolean isConstructor = false;
    protected String returnType = "void";
    protected Vector argumentNames;
    protected Vector lines = new Vector();
    protected Vector exceptions = new Vector();
    protected StringBuffer storedBuffer = new StringBuffer();

    public void addException(String string) {
        this.exceptions.add(string);
    }

    public void addLine(String string) {
        this.storedBuffer.append(string);
        this.getLines().addElement(this.storedBuffer.toString());
        this.storedBuffer = new StringBuffer();
    }

    public void addToBuffer(String string) {
        this.storedBuffer.append(string);
    }

    private void adjustExceptions(Map map) {
        for (String string : new Vector(this.getExceptions())) {
            String string2;
            if (string.equals(string2 = MethodDefinition.adjustTypeName(string, map))) continue;
            this.replaceException(string, string2);
        }
    }

    private void adjustLine(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Set set = MethodDefinition.parseForTypeNames(stringBuffer.toString());
        for (String string2 : set) {
            String string3;
            if (string2.equals(string3 = MethodDefinition.adjustTypeName(string2, map))) continue;
            int n = stringBuffer.toString().indexOf(string2);
            while (n != -1) {
                stringBuffer.replace(n, n + string2.length(), string3);
                n = stringBuffer.toString().indexOf(string2);
            }
        }
        this.replaceLine(string, stringBuffer.toString());
    }

    private void adjustLines(Map map) {
        Iterator iterator = new Vector(this.getLines()).iterator();
        while (iterator.hasNext()) {
            this.adjustLine((String)iterator.next(), map);
        }
    }

    private void adjustReturnType(Map map) {
        String string = MethodDefinition.adjustTypeName(this.getReturnType(), map);
        if (!this.getReturnType().equals(string)) {
            this.setReturnType(string);
        }
    }

    protected void adjustTypeNames(Map map) {
        this.adjustReturnType(map);
        this.adjustExceptions(map);
        this.adjustLines(map);
    }

    protected abstract boolean argumentsEqual(MethodDefinition var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodDefinition)) {
            return false;
        }
        MethodDefinition methodDefinition = (MethodDefinition)object;
        if (this.name == null && methodDefinition.getName() != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(methodDefinition.getName())) {
            return false;
        }
        if (!this.accessLevel.equals(methodDefinition.getAccessLevel())) {
            return false;
        }
        if (!this.returnType.equals(methodDefinition.getReturnType())) {
            return false;
        }
        if (!this.argumentsEqual(methodDefinition)) {
            return false;
        }
        return this.exceptionsEqual(methodDefinition);
    }

    protected boolean exceptionsEqual(MethodDefinition methodDefinition) {
        Object[] objectArray;
        Object[] objectArray2 = this.getExceptions().toArray();
        if (objectArray2.length == (objectArray = methodDefinition.getExceptions().toArray()).length) {
            for (int i = 0; i < objectArray2.length; ++i) {
                if ((objectArray2[i] != null || objectArray2[i] == objectArray[i]) && objectArray2[i].equals(objectArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected Vector getArgumentNames() {
        if (this.argumentNames == null) {
            this.argumentNames = new Vector(5);
        }
        return this.argumentNames;
    }

    public String getArgumentName(int n) {
        return (String)this.getArgumentNames().get(n);
    }

    public Iterator argumentNames() {
        return this.getArgumentNames().iterator();
    }

    public int argumentNamesSize() {
        return this.getArgumentNames().size();
    }

    protected abstract Vector getArgumentTypeNames();

    protected abstract Vector getArgumentTypes();

    public Vector getLines() {
        return this.lines;
    }

    protected Vector getExceptions() {
        return this.exceptions;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        int n = this.accessLevel.hashCode();
        n ^= this.returnType.hashCode();
        n ^= this.getArgumentTypes().hashCode();
        if (this.name != null) {
            n ^= this.name.hashCode();
        }
        if (this.name != null) {
            n ^= this.name.hashCode();
        }
        return n ^= this.getExceptions().hashCode();
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    protected void putTypeNamesInMap(Map map) {
        MethodDefinition.putTypeNameInMap(this.getReturnType(), map);
        Iterator iterator = this.getExceptions().iterator();
        while (iterator.hasNext()) {
            MethodDefinition.putTypeNameInMap((String)iterator.next(), map);
        }
        iterator = this.getArgumentTypeNames().iterator();
        while (iterator.hasNext()) {
            MethodDefinition.putTypeNameInMap((String)iterator.next(), map);
        }
    }

    protected void replaceException(String string, String string2) {
        int n = this.getExceptions().indexOf(string);
        this.getExceptions().remove(string);
        this.getExceptions().insertElementAt(string2, n);
    }

    protected void replaceLine(String string, String string2) {
        int n = this.getLines().indexOf(string);
        this.getLines().remove(string);
        this.getLines().insertElementAt(string2, n);
    }

    public void setIsAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public void setIsConstructor(boolean bl) {
        this.isConstructor = bl;
    }

    public void setReturnType(String string) {
        this.returnType = string;
    }

    public void writeBody(CodeGenerator codeGenerator) {
        if (!this.isConstructor()) {
            codeGenerator.writeType(this.getReturnType());
            codeGenerator.write(" ");
        }
        codeGenerator.write(this.getName());
        codeGenerator.write("(");
        this.writeArguments(codeGenerator);
        codeGenerator.write(")");
        if (!this.exceptions.isEmpty()) {
            this.writeThrowsClause(codeGenerator);
        }
        if (this.isAbstract()) {
            codeGenerator.write(";");
        } else {
            codeGenerator.write(" {");
            codeGenerator.cr();
            Enumeration enumeration = this.getLines().elements();
            while (enumeration.hasMoreElements()) {
                codeGenerator.tab();
                codeGenerator.writeln(enumeration.nextElement());
            }
            codeGenerator.write("}");
        }
    }

    protected abstract void writeArguments(CodeGenerator var1);

    protected void writeThrowsClause(CodeGenerator codeGenerator) {
        codeGenerator.write(" throws ");
        Iterator iterator = this.exceptions.iterator();
        while (iterator.hasNext()) {
            codeGenerator.write(iterator.next());
            if (!iterator.hasNext()) continue;
            codeGenerator.write(", ");
        }
    }
}

