/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.InOutputParameterForCallableStatement;
import org.eclipse.persistence.internal.databaseaccess.OutputParameterForCallableStatement;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public abstract class DatabaseCall
extends DatasourceCall {
    public static DatabaseField MAXROW_FIELD = new DatabaseField("EclipseLink-MaxResults");
    public static DatabaseField FIRSTRESULT_FIELD = new DatabaseField("EclipseLink-FirstRow");
    protected boolean ignoreFirstRowMaxResultsSettings;
    protected transient Statement statement;
    protected transient ResultSet result;
    protected Boolean usesBinding;
    protected Boolean shouldCacheStatement;
    protected transient Vector fields;
    protected boolean isFieldMatchingRequired;
    protected boolean hasOptimisticLock;
    protected boolean isResultSetScrollable;
    protected int resultSetFetchSize;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int queryTimeout;
    protected int maxRows;
    protected int firstResult;
    private transient AbstractRecord contexts;
    protected boolean isCursorOutputProcedure;
    protected Boolean returnsResultSet;
    protected boolean shouldBuildOutputRow;
    protected boolean isCallableStatementRequired;
    protected String sqlString;

    public DatabaseCall() {
        this.shouldProcessTokenInQuotes = false;
        this.usesBinding = null;
        this.shouldCacheStatement = null;
        this.isFieldMatchingRequired = false;
        this.returnType = 3;
        this.queryTimeout = 0;
        this.maxRows = 0;
        this.resultSetFetchSize = 0;
        this.isCursorOutputProcedure = false;
        this.shouldBuildOutputRow = false;
        this.returnsResultSet = null;
    }

    public void appendIn(Object object) {
        this.getParameters().add(object);
        this.getParameterTypes().add(IN);
    }

    public void appendInOut(DatabaseField databaseField) {
        Object[] objectArray = new Object[]{databaseField, databaseField};
        this.getParameters().add(objectArray);
        this.getParameterTypes().add(INOUT);
    }

    public void appendInOut(Object object, DatabaseField databaseField) {
        Object[] objectArray = new Object[]{object, databaseField};
        this.getParameters().add(objectArray);
        this.getParameterTypes().add(INOUT);
    }

    public void appendOut(DatabaseField databaseField) {
        this.getParameters().add(databaseField);
        this.getParameterTypes().add(OUT);
    }

    public void appendOutCursor(DatabaseField databaseField) {
        this.getParameters().add(databaseField);
        this.getParameterTypes().add(OUT_CURSOR);
    }

    public void appendParameter(Writer writer, Object object, AbstractSession abstractSession) {
        if (Boolean.TRUE.equals(this.usesBinding)) {
            this.bindParameter(writer, object);
        } else {
            abstractSession.getPlatform().appendParameter(this, writer, object);
        }
    }

    public void bindParameter(Writer writer, Object object) {
        if (object instanceof Collection) {
            throw QueryException.inCannotBeParameterized(this.getQuery());
        }
        try {
            writer.write("?");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(object);
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery databaseQuery) {
        return new CallQueryMechanism(databaseQuery, this);
    }

    public AbstractRecord buildOutputRow(CallableStatement callableStatement) throws SQLException {
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (int i = 0; i < this.parameters.size(); ++i) {
            OutputParameterForCallableStatement outputParameterForCallableStatement;
            Object e = this.parameters.elementAt(i);
            if (!(e instanceof OutputParameterForCallableStatement) || (outputParameterForCallableStatement = (OutputParameterForCallableStatement)e).isCursor()) continue;
            Object object = callableStatement.getObject(i + 1);
            DatabaseField databaseField = outputParameterForCallableStatement.getOutputField();
            if (object instanceof Struct) {
                ClassDescriptor classDescriptor = this.getQuery().getSession().getDescriptor(databaseField.getType());
                if (object != null && classDescriptor != null && classDescriptor.isObjectRelationalDataTypeDescriptor()) {
                    AbstractRecord abstractRecord = ((ObjectRelationalDataTypeDescriptor)classDescriptor).buildRowFromStructure((Struct)object);
                    ReadObjectQuery readObjectQuery = new ReadObjectQuery();
                    readObjectQuery.setSession(this.getQuery().getSession());
                    object = classDescriptor.getObjectBuilder().buildNewInstance();
                    classDescriptor.getObjectBuilder().buildAttributesIntoObject(object, abstractRecord, readObjectQuery, null, false);
                }
            } else if (object instanceof Array && databaseField.isObjectRelationalDatabaseField()) {
                object = ObjectRelationalDataTypeDescriptor.buildContainerFromArray((Array)object, (ObjectRelationalDatabaseField)databaseField, this.getQuery().getSession());
            }
            databaseRecord.put(databaseField, object);
        }
        return databaseRecord;
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery databaseQuery, DatabaseQueryMechanism databaseQueryMechanism) {
        if (databaseQueryMechanism.isCallQueryMechanism() && databaseQueryMechanism instanceof CallQueryMechanism) {
            CallQueryMechanism callQueryMechanism = (CallQueryMechanism)databaseQueryMechanism;
            if (!callQueryMechanism.hasMultipleCalls()) {
                callQueryMechanism.addCall(callQueryMechanism.getCall());
                callQueryMechanism.setCall(null);
            }
            callQueryMechanism.addCall(this);
            return databaseQueryMechanism;
        }
        return this.buildNewQueryMechanism(databaseQuery);
    }

    protected Object createInOutParameter(Object object, Object object2, AbstractSession abstractSession) {
        if (object2 instanceof OutputParameterForCallableStatement) {
            return new InOutputParameterForCallableStatement(object, (OutputParameterForCallableStatement)object2);
        }
        if (object2 instanceof DatabaseField) {
            return new InOutputParameterForCallableStatement(object, (DatabaseField)object2, abstractSession);
        }
        return null;
    }

    public String getCallString() {
        return this.getSQLString();
    }

    public Vector getFields() {
        return this.fields;
    }

    protected DatabaseField getFieldWithTypeFromDescriptor(DatabaseField databaseField) {
        if (this.getQuery().getDescriptor() != null) {
            return this.getQuery().getDescriptor().getTypedField(databaseField);
        }
        return null;
    }

    public int getCursorOutIndex() {
        for (int i = 0; i < this.getParameters().size(); ++i) {
            Object e = this.getParameters().elementAt(i);
            if (!(e instanceof OutputParameterForCallableStatement) || !((OutputParameterForCallableStatement)e).isCursor()) continue;
            return i + 1;
        }
        return -1;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public String getLogString(Accessor accessor) {
        if (this.hasParameters()) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(this.getSQLString());
            stringWriter.write(Helper.cr());
            if (this.hasParameters()) {
                AbstractSession abstractSession = null;
                if (this.getQuery() != null) {
                    abstractSession = this.getQuery().getSession();
                }
                DatabaseCall.appendLogParameters(this.getParameters(), accessor, stringWriter, abstractSession);
            }
            return stringWriter.toString();
        }
        return this.getSQLString();
    }

    public static void appendLogParameters(Collection collection, Accessor accessor, StringWriter stringWriter, AbstractSession abstractSession) {
        stringWriter.write("\tbind => [");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof DatabaseField) {
                stringWriter.write("null");
            } else {
                if (abstractSession != null) {
                    object = abstractSession.getPlatform().convertToDatabaseType(object);
                }
                stringWriter.write(String.valueOf(object));
            }
            if (iterator.hasNext()) {
                stringWriter.write(", ");
                continue;
            }
            stringWriter.write("]");
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Vector getOutputRowFields() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.getParameters().size(); ++i) {
            Integer n = (Integer)this.getParameterTypes().elementAt(i);
            Object e = this.getParameters().elementAt(i);
            if (n == OUT) {
                vector.add(e);
                continue;
            }
            if (n != INOUT) continue;
            vector.add(((Object[])e)[1]);
        }
        return vector;
    }

    public String getQueryString() {
        return this.getSQLString();
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public ResultSet getResult() {
        return this.result;
    }

    public boolean getReturnsResultSet() {
        if (this.returnsResultSet == null) {
            return !this.shouldBuildOutputRow();
        }
        return this.returnsResultSet;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetFetchSize() {
        return this.resultSetFetchSize;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public String getSQLString() {
        return this.sqlString;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean hasOptimisticLock() {
        return this.hasOptimisticLock;
    }

    protected boolean isCallableStatementRequired() {
        return this.isCallableStatementRequired;
    }

    protected boolean isDynamicCall(AbstractSession abstractSession) {
        return DatabaseAccessor.shouldUseDynamicStatements && !this.usesBinding(abstractSession) && !this.isResultSetScrollable() && !this.hasParameters();
    }

    public boolean isCursorOutputProcedure() {
        return this.isCursorOutputProcedure;
    }

    public boolean isCursorReturned() {
        return this.getReturnType() == 4;
    }

    public boolean isFieldMatchingRequired() {
        return this.isFieldMatchingRequired;
    }

    public boolean isFinished() {
        return !this.isCursorReturned();
    }

    public boolean isNonCursorOutputProcedure() {
        return !this.isCursorOutputProcedure() && this.shouldBuildOutputRow();
    }

    public boolean isResultSetScrollable() {
        return this.isResultSetScrollable;
    }

    public void matchFieldOrder(ResultSet resultSet, DatabaseAccessor databaseAccessor, AbstractSession abstractSession) {
        if (this.getFields() != null && !this.isFieldMatchingRequired()) {
            return;
        }
        this.setFields(databaseAccessor.buildSortedFields(this.getFields(), resultSet, abstractSession));
    }

    public void prepare(AbstractSession abstractSession) {
        if (this.isPrepared()) {
            return;
        }
        this.prepareInternal(abstractSession);
        this.setIsPrepared(true);
    }

    protected void prepareInternal(AbstractSession abstractSession) {
        this.prepareInternalParameters(abstractSession);
    }

    protected void prepareInternalParameters(AbstractSession abstractSession) {
        int n;
        if (this.isCursorOutputProcedure()) {
            n = -1;
            boolean bl = false;
            for (int i = 0; i < this.parameters.size(); ++i) {
                Integer n2 = (Integer)this.parameterTypes.elementAt(i);
                if (n2 == DatasourceCall.OUT_CURSOR) {
                    if (bl) {
                        throw ValidationException.multipleCursorsNotSupported(this.toString());
                    }
                    bl = true;
                    continue;
                }
                if (n2 == DatasourceCall.OUT) {
                    if (n != -1) continue;
                    n = i;
                    continue;
                }
                if (n2 != null) continue;
                throw ValidationException.wrongUsageOfSetCustomArgumentTypeMethod(this.toString());
            }
            if (!bl && n >= 0) {
                this.parameterTypes.setElementAt(DatasourceCall.OUT_CURSOR, n);
            }
        }
        for (n = 0; n < this.getParameters().size(); ++n) {
            Object object;
            boolean bl;
            Object object2;
            Object e = this.getParameters().elementAt(n);
            Integer n3 = (Integer)this.getParameterTypes().elementAt(n);
            if (n3 == MODIFY) {
                DatabaseField databaseField = (DatabaseField)e;
                if (databaseField.getType() != null && !abstractSession.getPlatform().shouldUseCustomModifyForCall(databaseField)) continue;
                this.getParameterTypes().setElementAt(CUSTOM_MODIFY, n);
                continue;
            }
            if (n3 == INOUT) {
                this.setShouldBuildOutputRow(true);
                this.setIsCallableStatementRequired(true);
                DatabaseField databaseField = (DatabaseField)((Object[])e)[1];
                if (databaseField.getType() == null && (object2 = this.getFieldWithTypeFromDescriptor(databaseField)) != null) {
                    databaseField = (DatabaseField)((DatabaseField)object2).clone();
                }
                if (databaseField.getType() == null) continue;
                ((Object[])e)[1] = object2 = new OutputParameterForCallableStatement(databaseField, abstractSession);
                continue;
            }
            if (n3 != OUT && n3 != OUT_CURSOR) continue;
            boolean bl2 = bl = n3 == OUT_CURSOR;
            if (!bl) {
                this.setShouldBuildOutputRow(true);
            }
            this.setIsCallableStatementRequired(true);
            object2 = (DatabaseField)e;
            if (((DatabaseField)object2).getType() == null && (object = this.getFieldWithTypeFromDescriptor((DatabaseField)object2)) != null) {
                object2 = (DatabaseField)((DatabaseField)object).clone();
            }
            object = new OutputParameterForCallableStatement((DatabaseField)object2, abstractSession, bl);
            this.getParameters().setElementAt(object, n);
            this.getParameterTypes().setElementAt(LITERAL, n);
        }
        if (this.returnsResultSet == null) {
            this.setReturnsResultSet(!this.isCallableStatementRequired());
        }
    }

    public Statement prepareStatement(DatabaseAccessor databaseAccessor, AbstractRecord abstractRecord, AbstractSession abstractSession) throws SQLException {
        Statement statement = databaseAccessor.prepareStatement(this, abstractSession);
        if (this.queryTimeout > 0) {
            statement.setQueryTimeout(this.queryTimeout);
        }
        if (!this.ignoreFirstRowMaxResultsSettings && this.maxRows > 0) {
            statement.setMaxRows(this.maxRows);
        }
        if (this.resultSetFetchSize > 0) {
            statement.setFetchSize(this.resultSetFetchSize);
        }
        if (this.parameters == null) {
            return statement;
        }
        Vector vector = this.getParameters();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            abstractSession.getPlatform().setParameterValueInDatabaseCall(vector.get(i), (PreparedStatement)statement, i + 1, abstractSession);
        }
        return statement;
    }

    public void setFields(Vector vector) {
        this.fields = vector;
    }

    public void setFirstResult(int n) {
        this.firstResult = n;
    }

    public void setHasOptimisticLock(boolean bl) {
        this.hasOptimisticLock = bl;
    }

    public void setIgnoreFirstRowMaxResultsSettings(boolean bl) {
        this.ignoreFirstRowMaxResultsSettings = bl;
    }

    protected void setIsCallableStatementRequired(boolean bl) {
        this.isCallableStatementRequired = bl;
    }

    public void setIsCursorOutputProcedure(boolean bl) {
        this.isCursorOutputProcedure = bl;
    }

    public void setIsFieldMatchingRequired(boolean bl) {
        this.isFieldMatchingRequired = bl;
    }

    public void setIsResultSetScrollable(boolean bl) {
        this.isResultSetScrollable = bl;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setQueryString(String string) {
        this.setSQLStringInternal(string);
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public void setResult(ResultSet resultSet) {
        this.result = resultSet;
    }

    public void setResultSetConcurrency(int n) {
        this.resultSetConcurrency = n;
    }

    protected void setSQLStringInternal(String string) {
        this.sqlString = string;
    }

    public void setResultSetFetchSize(int n) {
        this.resultSetFetchSize = n;
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }

    public void setReturnsResultSet(boolean bl) {
        this.returnsResultSet = bl;
    }

    protected void setShouldBuildOutputRow(boolean bl) {
        this.shouldBuildOutputRow = bl;
    }

    public void setShouldCacheStatement(boolean bl) {
        this.shouldCacheStatement = bl;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public void setUsesBinding(boolean bl) {
        this.usesBinding = bl;
    }

    public boolean shouldBuildOutputRow() {
        return this.shouldBuildOutputRow;
    }

    public boolean shouldCacheStatement(AbstractSession abstractSession) {
        return this.shouldCacheStatement(abstractSession.getPlatform());
    }

    public boolean shouldCacheStatement(DatabasePlatform databasePlatform) {
        if (this.isResultSetScrollable()) {
            return false;
        }
        if (this.shouldCacheStatement == null) {
            return databasePlatform.shouldCacheAllStatements();
        }
        return this.shouldCacheStatement;
    }

    public boolean shouldIgnoreFirstRowMaxResultsSettings() {
        return this.ignoreFirstRowMaxResultsSettings;
    }

    public String toString() {
        String string = Helper.getShortClassName(this.getClass());
        if (this.getSQLString() == null) {
            return string;
        }
        return string + "(" + this.getSQLString() + ")";
    }

    public void translate(AbstractRecord abstractRecord, AbstractRecord abstractRecord2, AbstractSession abstractSession) {
        if (!this.isPrepared()) {
            throw ValidationException.cannotTranslateUnpreparedCall(this.toString());
        }
        if (this.usesBinding(abstractSession) && this.parameters != null) {
            boolean bl = false;
            Vector vector = this.getParameters();
            Vector vector2 = this.getParameterTypes();
            Vector<Object> vector3 = new Vector<Object>(vector.size());
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                Object e = vector.get(i);
                Object e2 = vector2.get(i);
                if (e2 == MODIFY) {
                    object2 = (DatabaseField)e;
                    object = abstractRecord2.get((DatabaseField)object2);
                    if (object == null && (object = abstractRecord2.getField((DatabaseField)object2)) == null) {
                        object = object2;
                    }
                    vector3.add(object);
                    continue;
                }
                if (e2 == CUSTOM_MODIFY) {
                    object2 = (DatabaseField)e;
                    object = abstractRecord2.get((DatabaseField)object2);
                    object = abstractSession.getPlatform().getCustomModifyValueForCall(this, object, (DatabaseField)object2, true);
                    if (object != null && object instanceof BindCallCustomParameter && ((BindCallCustomParameter)object).shouldUseUnwrappedConnection()) {
                        this.isNativeConnectionRequired = true;
                    }
                    if (object == null && (object = abstractRecord2.getField((DatabaseField)object2)) == null) {
                        object = object2;
                    }
                    vector3.add(object);
                    continue;
                }
                if (e2 == TRANSLATION) {
                    object2 = null;
                    object = null;
                    if (e instanceof ParameterExpression) {
                        object = ((ParameterExpression)e).getField();
                        object2 = ((ParameterExpression)e).getValue(abstractRecord, abstractSession);
                    } else {
                        object = (DatabaseField)e;
                        object2 = abstractRecord.get((DatabaseField)object);
                        if (object2 == null) {
                            object2 = abstractRecord2.get((DatabaseField)object);
                        }
                    }
                    if (object2 instanceof Collection) {
                        bl = true;
                    }
                    if (object2 == null && object != null && (object2 = abstractRecord.getField((DatabaseField)object)) == null) {
                        object2 = object;
                    }
                    vector3.add(object2);
                    continue;
                }
                if (e2 == LITERAL) {
                    vector3.add(e);
                    continue;
                }
                if (e2 == IN) {
                    object2 = this.getValueForInParameter(e, abstractRecord, abstractRecord2, abstractSession, true);
                    vector3.add(object2);
                    continue;
                }
                if (e2 != INOUT) continue;
                object2 = this.getValueForInOutParameter(e, abstractRecord, abstractRecord2, abstractSession);
                vector3.add(object2);
            }
            this.setParameters(vector3);
            if (bl) {
                this.translateQueryStringForParameterizedIN(abstractRecord, abstractRecord2, abstractSession);
            }
            return;
        }
        this.translateQueryString(abstractRecord, abstractRecord2, abstractSession);
    }

    public void translateQueryStringForParameterizedIN(AbstractRecord abstractRecord, AbstractRecord abstractRecord2, AbstractSession abstractSession) {
        int n = 0;
        int n2 = 0;
        String string = this.getQueryString();
        CharArrayWriter charArrayWriter = new CharArrayWriter(string.length() + 50);
        try {
            Vector vector = this.getParameters();
            Vector vector2 = new Vector(vector.size());
            while (n != -1) {
                String string2;
                int n3 = string.indexOf(this.argumentMarker(), n);
                if (n3 == -1) {
                    string2 = string.substring(n, string.length());
                    n = -1;
                } else {
                    string2 = string.substring(n, n3);
                }
                charArrayWriter.write(string2);
                if (n3 == -1) continue;
                Object e = vector.get(n2);
                if (e instanceof Collection) {
                    Collection collection = (Collection)e;
                    vector2.addAll(collection);
                    int n4 = collection.size();
                    charArrayWriter.write("(");
                    for (int i = 0; i < n4; ++i) {
                        charArrayWriter.write("?");
                        if (i + 1 >= n4) continue;
                        charArrayWriter.write(",");
                    }
                    charArrayWriter.write(")");
                } else {
                    vector2.add(e);
                    charArrayWriter.write("?");
                }
                n = n3 + 1;
                ++n2;
            }
            this.setParameters(vector2);
            this.setQueryString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean usesBinding(AbstractSession abstractSession) {
        return this.usesBinding(abstractSession.getPlatform());
    }

    public boolean usesBinding(DatabasePlatform databasePlatform) {
        if (this.usesBinding == null) {
            return databasePlatform.shouldBindAllParameters();
        }
        return this.usesBinding;
    }

    public boolean isLOBLocatorNeeded() {
        return this.contexts != null;
    }

    public void addContext(DatabaseField databaseField, Object object) {
        if (this.contexts == null) {
            this.contexts = new DatabaseRecord(2);
        }
        this.contexts.add(databaseField, object);
    }

    public AbstractRecord getContexts() {
        return this.contexts;
    }

    public void setContexts(AbstractRecord abstractRecord) {
        this.contexts = abstractRecord;
    }

    public void useUnnamedCursorOutputAsResultSet() {
        this.setIsCursorOutputProcedure(true);
    }
}

