/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class LiteralExpression
extends Expression {
    protected String value;
    protected Expression localBase;

    public LiteralExpression() {
    }

    public LiteralExpression(String string, Expression expression) {
        this.value = string;
        this.localBase = expression;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LiteralExpression literalExpression = (LiteralExpression)object;
        return this.getValue() == literalExpression.getValue() || this.getValue() != null && this.getValue().equals(literalExpression.getValue());
    }

    public int computeHashCode() {
        int n = super.computeHashCode();
        if (this.getValue() != null) {
            n += this.getValue().hashCode();
        }
        return n;
    }

    public String descriptionOfNodeType() {
        return "Literal";
    }

    public ExpressionBuilder getBuilder() {
        return this.getLocalBase().getBuilder();
    }

    protected Expression getLocalBase() {
        return this.localBase;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isLiteralExpression() {
        return true;
    }

    protected void postCopyIn(Map map) {
        super.postCopyIn(map);
        this.localBase = this.localBase.copiedVersionFrom(map);
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        expressionSQLPrinter.printString(this.value);
    }

    public void printSQLWithoutConversion(ExpressionSQLPrinter expressionSQLPrinter) {
        this.printSQL(expressionSQLPrinter);
    }

    public Expression rebuildOn(Expression expression) {
        LiteralExpression literalExpression = (LiteralExpression)this.clone();
        ((Expression)literalExpression).setLocalBase(this.getLocalBase().rebuildOn(expression));
        return literalExpression;
    }

    public void setLocalBase(Expression expression) {
        this.localBase = expression;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        return (Expression)this.clone();
    }

    public Object valueFromObject(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord, int n, boolean bl) {
        return this.getLocalBase().getFieldValue(this.getValue(), abstractSession);
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.getValue().toString());
    }

    public void writeFields(ExpressionSQLPrinter expressionSQLPrinter, Vector vector, SQLSelectStatement sQLSelectStatement) {
        if (expressionSQLPrinter.isFirstElementPrinted()) {
            expressionSQLPrinter.printString(", ");
        } else {
            expressionSQLPrinter.setIsFirstElementPrinted(true);
        }
        vector.addElement(new DatabaseField(this.getValue()));
        this.printSQL(expressionSQLPrinter);
    }
}

