/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Serializable;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class DatabaseField
implements Cloneable,
Serializable {
    protected int scale;
    protected int length;
    protected int precision;
    protected boolean isUnique;
    protected boolean isNullable;
    protected boolean isUpdatable;
    protected boolean isInsertable;
    protected String columnDefinition;
    protected String name;
    protected String qualifiedName;
    protected DatabaseTable table;
    public transient Class type;
    public int sqlType = -1;
    public int index = -1;
    public static final int NULL_SQL_TYPE = -1;

    public DatabaseField() {
        this("", new DatabaseTable());
    }

    public DatabaseField(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            this.name = string;
            this.table = new DatabaseTable();
        } else {
            this.name = string.substring(n + 1, string.length());
            this.table = new DatabaseTable(string.substring(0, n));
        }
        this.initDDLFields();
    }

    public DatabaseField(String string, String string2) {
        this(string, new DatabaseTable(string2));
    }

    public DatabaseField(String string, DatabaseTable databaseTable) {
        this.name = string;
        this.table = databaseTable;
        this.initDDLFields();
    }

    public void initDDLFields() {
        this.scale = 0;
        this.length = 255;
        this.precision = 0;
        this.isUnique = false;
        this.isNullable = true;
        this.isUpdatable = true;
        this.isInsertable = true;
        this.columnDefinition = "";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatabaseField)) {
            return false;
        }
        return this.equals((DatabaseField)object);
    }

    public boolean equals(DatabaseField databaseField) {
        if (this == databaseField) {
            return true;
        }
        if (databaseField != null) {
            if (this.getQualifiedName().equals(databaseField.getQualifiedName())) {
                return true;
            }
            if (DatabasePlatform.shouldIgnoreCaseOnFieldComparisons()) {
                if (this.name.equalsIgnoreCase(databaseField.name)) {
                    if (this.getTableName().length() == 0 || databaseField.getTableName().length() == 0) {
                        return true;
                    }
                    return this.getTable().equals(databaseField.getTable());
                }
            } else if (this.name.equals(databaseField.name)) {
                if (this.getTableName().length() == 0 || databaseField.getTableName().length() == 0) {
                    return true;
                }
                return this.getTable().equals(databaseField.getTable());
            }
        }
        return false;
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.hasTableName() ? this.table.getQualifiedName() + "." + this.name : this.name;
        }
        return this.qualifiedName;
    }

    public int getScale() {
        return this.scale;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public void setTableName(String string) {
        this.setTable(new DatabaseTable(string));
    }

    public Class getType() {
        return this.type;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean hasTableName() {
        if (this.table == null) {
            return false;
        }
        if (this.table.getName() == null) {
            return false;
        }
        return !this.table.getName().equals("");
    }

    public boolean isObjectRelationalDatabaseField() {
        return false;
    }

    public boolean isInsertable() {
        return this.isInsertable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isReadOnly() {
        return !this.isUpdatable && !this.isInsertable;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public void resetQualifiedName(String string) {
        this.setIndex(-1);
        int n = string.lastIndexOf(46);
        if (n == -1) {
            this.setName(string);
            this.getTable().setName("");
            this.getTable().setTableQualifier("");
        } else {
            this.setName(string.substring(n + 1, string.length()));
            this.getTable().setPossiblyQualifiedName(string.substring(0, n));
        }
    }

    public void setColumnDefinition(String string) {
        this.columnDefinition = string;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setInsertable(boolean bl) {
        this.isInsertable = bl;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setName(String string) {
        this.name = string;
        this.qualifiedName = null;
    }

    public void setNullable(boolean bl) {
        this.isNullable = bl;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public void setSqlType(int n) {
        this.sqlType = n;
    }

    public void setTable(DatabaseTable databaseTable) {
        this.table = databaseTable;
        this.qualifiedName = null;
    }

    public void setType(Class clazz) {
        this.type = clazz;
    }

    public void setUnique(boolean bl) {
        this.isUnique = bl;
    }

    public void setUpdatable(boolean bl) {
        this.isUpdatable = bl;
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

