/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.io.Serializable;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class DatabaseValueHolder
implements WeavedAttributeValueHolderInterface,
Cloneable,
Serializable {
    protected Object value;
    protected boolean isInstantiated;
    protected transient AbstractSession session;
    protected AbstractRecord row;
    protected boolean isCoordinatedWithProperty = false;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public AbstractRecord getRow() {
        return this.row;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        if (!this.isInstantiated()) {
            DatabaseValueHolder databaseValueHolder = this;
            synchronized (databaseValueHolder) {
                if (!this.isInstantiated()) {
                    this.privilegedSetValue(this.instantiate());
                    this.setInstantiated();
                    this.resetFields();
                }
            }
        }
        return this.value;
    }

    protected abstract Object instantiate() throws DatabaseException;

    public abstract Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder var1);

    public boolean isCoordinatedWithProperty() {
        return this.isCoordinatedWithProperty;
    }

    public boolean isNewlyWeavedValueHolder() {
        return false;
    }

    public boolean isEasilyInstantiated() {
        return this.isInstantiated();
    }

    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public abstract boolean isPessimisticLockingValueHolder();

    protected boolean isTransactionalValueHolder() {
        return this.session != null && this.session.isUnitOfWork();
    }

    public boolean isSerializedRemoteUnitOfWorkValueHolder() {
        return false;
    }

    public void privilegedSetValue(Object object) {
        this.value = object;
        this.isCoordinatedWithProperty = false;
    }

    public void releaseWrappedValueHolder() {
        AbstractSession abstractSession = this.getSession();
        if (abstractSession != null && abstractSession.isUnitOfWork()) {
            this.setSession(abstractSession.getRootSession(null));
        }
    }

    protected void resetFields() {
        this.setRow(null);
        this.setSession(null);
    }

    public void setIsCoordinatedWithProperty(boolean bl) {
        this.isCoordinatedWithProperty = bl;
    }

    public void setIsNewlyWeavedValueHolder(boolean bl) {
    }

    public void setInstantiated() {
        this.isInstantiated = true;
    }

    public void setRow(AbstractRecord abstractRecord) {
        this.row = abstractRecord;
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public void setUninstantiated() {
        this.isInstantiated = false;
    }

    public void setValue(Object object) {
        this.value = object;
        this.setInstantiated();
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getValue() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": " + ToStringLocalization.buildMessage("not_instantiated", null) + "}";
    }
}

