/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class ConstructorNode
extends Node {
    private String className = null;
    public List constructorItems = new ArrayList();

    public ConstructorNode(String string) {
        this.className = string;
    }

    public void applyToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery instanceof ReportQuery) {
            SelectGenerationContext selectGenerationContext = (SelectGenerationContext)generationContext;
            ReportQuery reportQuery = (ReportQuery)objectLevelReadQuery;
            reportQuery.beginAddingConstructorArguments(this.getConstructorClass(generationContext.getParseTreeContext()));
            for (Node node : this.constructorItems) {
                if (this.selectingRelationshipField(node, generationContext)) {
                    selectGenerationContext.useOuterJoins();
                }
                node.applyToQuery(reportQuery, generationContext);
                selectGenerationContext.dontUseOuterJoins();
            }
            reportQuery.endAddingToConstructorItem();
        }
    }

    public void validate(ParseTreeContext parseTreeContext) {
        String string;
        int n;
        Object object2;
        for (Object object2 : this.constructorItems) {
            ((Node)object2).validate(parseTreeContext);
        }
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        object2 = typeHelper.resolveTypeName(this.className);
        if (object2 == null && (n = (string = this.className).lastIndexOf(46)) != -1) {
            string = string.substring(0, n) + '$' + string.substring(n + 1);
            object2 = typeHelper.resolveTypeName(string);
        }
        this.setType(object2);
    }

    public boolean isConstructorNode() {
        return true;
    }

    public void addConstructorItem(Object object) {
        this.constructorItems.add(object);
    }

    public void setConstructorItems(List list) {
        this.constructorItems = list;
    }

    public List getConstructorItems() {
        return this.constructorItems;
    }

    private Class getConstructorClass(ParseTreeContext parseTreeContext) {
        Object object = this.getType();
        if (object == null) {
            throw JPQLException.constructorClassNotFound(parseTreeContext.getQueryInfo(), this.getLine(), this.getColumn(), this.className);
        }
        return (Class)object;
    }

    private boolean selectingRelationshipField(Node node, GenerationContext generationContext) {
        if (node == null || !node.isDotNode()) {
            return false;
        }
        return !((DotNode)node).endsWithDirectToField(generationContext);
    }

    public String getAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NEW ").append(this.className);
        stringBuffer.append("(");
        Iterator iterator = this.constructorItems.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            stringBuffer.append(node.getAsString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

