/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AggregateNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class CountNode
extends AggregateNode {
    public void applyToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)objectLevelReadQuery;
            String string = this.getLeft().isDotNode() ? this.resolveAttribute() : "COUNT";
            reportQuery.addAttribute(string, this.generateExpression(generationContext), Long.class);
        }
    }

    public void validate(ParseTreeContext parseTreeContext) {
        if (this.left != null) {
            this.left.validate(parseTreeContext);
            TypeHelper typeHelper = parseTreeContext.getTypeHelper();
            this.setType(typeHelper.getLongClassType());
        }
    }

    protected Expression addAggregateExression(Expression expression) {
        return expression.count();
    }

    public boolean isCountNode() {
        return true;
    }

    public String getAsString() {
        return "COUNT(" + this.left.getAsString() + ")";
    }
}

